<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPReqAppResultReponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ IPReqAppResultReponseType «Ответы СПИ на запросы или заявления» | ЭП
 * - type: tns:IPReqAppResultReponseType
 * @subpackage Structs
 */
class IPReqAppResultReponseType extends AbstractStructBase
{
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор
     * должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The responseKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ответа | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор
     * должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $responseKey;
    /**
     * The origin
     * Meta informations extracted from the WSDL
     * - documentation: Адрес отправителя запроса
     * - minOccurs: 0
     * @var \StructType\RedAddress
     */
    public $origin;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа ответа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа ответа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The appStatus
     * Meta informations extracted from the WSDL
     * - documentation: Код смены статуса заявления
     * @var string
     */
    public $appStatus;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPReqAppResultReponseType
     * @uses IPReqAppResultReponseType::setRequestKey()
     * @uses IPReqAppResultReponseType::setResponseKey()
     * @uses IPReqAppResultReponseType::setOrigin()
     * @uses IPReqAppResultReponseType::setDocNumber()
     * @uses IPReqAppResultReponseType::setDocDate()
     * @uses IPReqAppResultReponseType::setAppStatus()
     * @uses IPReqAppResultReponseType::setSignature()
     * @uses IPReqAppResultReponseType::setId()
     * @param string $requestKey
     * @param string $responseKey
     * @param \StructType\RedAddress $origin
     * @param string $docNumber
     * @param string $docDate
     * @param string $appStatus
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($requestKey = null, $responseKey = null, \StructType\RedAddress $origin = null, $docNumber = null, $docDate = null, $appStatus = null, array $signature = array(), $id = null)
    {
        $this
            ->setRequestKey($requestKey)
            ->setResponseKey($responseKey)
            ->setOrigin($origin)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setAppStatus($appStatus)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \StructType\IPReqAppResultReponseType
     */
    public function setRequestKey($requestKey = null)
    {
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get responseKey value
     * @return string|null
     */
    public function getResponseKey()
    {
        return $this->responseKey;
    }
    /**
     * Set responseKey value
     * @param string $responseKey
     * @return \StructType\IPReqAppResultReponseType
     */
    public function setResponseKey($responseKey = null)
    {
        $this->responseKey = $responseKey;
        return $this;
    }
    /**
     * Get origin value
     * @return \StructType\RedAddress|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param \StructType\RedAddress $origin
     * @return \StructType\IPReqAppResultReponseType
     */
    public function setOrigin(\StructType\RedAddress $origin = null)
    {
        $this->origin = $origin;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \StructType\IPReqAppResultReponseType
     */
    public function setDocNumber($docNumber = null)
    {
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \StructType\IPReqAppResultReponseType
     */
    public function setDocDate($docDate = null)
    {
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get appStatus value
     * @return string|null
     */
    public function getAppStatus()
    {
        return $this->appStatus;
    }
    /**
     * Set appStatus value
     * @uses \EnumType\ApplicationStatus::valueIsValid()
     * @uses \EnumType\ApplicationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appStatus
     * @return \StructType\IPReqAppResultReponseType
     */
    public function setAppStatus($appStatus = null)
    {
        $this->appStatus = $appStatus;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\IPReqAppResultReponseType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\IPReqAppResultReponseType
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IPReqAppResultReponseType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPReqAppResultReponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
