<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPReqAppResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ IPReqAppResponseType «Подтверждение регистрации запроса или заявления в ОСП» | ЭП
 * - type: tns:IPReqAppResponseType
 * @subpackage Structs
 */
class IPReqAppResponseType extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ подтверждения | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта
     * от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The externalReqKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса или заявления ЕПГУ | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $externalReqKey;
    /**
     * The internalReqKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса или заявления АИС ФССП России | Ключ запроса, зарегистрированного в системе для последующего получения ответа на
     * него | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalReqKey;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPReqAppResponseType
     * @uses IPReqAppResponseType::setInternalKey()
     * @uses IPReqAppResponseType::setExternalReqKey()
     * @uses IPReqAppResponseType::setInternalReqKey()
     * @uses IPReqAppResponseType::setSignature()
     * @uses IPReqAppResponseType::setId()
     * @param int $internalKey
     * @param string $externalReqKey
     * @param int $internalReqKey
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $externalReqKey = null, $internalReqKey = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setExternalReqKey($externalReqKey)
            ->setInternalReqKey($internalReqKey)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \StructType\IPReqAppResponseType
     */
    public function setInternalKey($internalKey = null)
    {
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get externalReqKey value
     * @return string|null
     */
    public function getExternalReqKey()
    {
        return $this->externalReqKey;
    }
    /**
     * Set externalReqKey value
     * @param string $externalReqKey
     * @return \StructType\IPReqAppResponseType
     */
    public function setExternalReqKey($externalReqKey = null)
    {
        $this->externalReqKey = $externalReqKey;
        return $this;
    }
    /**
     * Get internalReqKey value
     * @return int|null
     */
    public function getInternalReqKey()
    {
        return $this->internalReqKey;
    }
    /**
     * Set internalReqKey value
     * @param int $internalReqKey
     * @return \StructType\IPReqAppResponseType
     */
    public function setInternalReqKey($internalReqKey = null)
    {
        $this->internalReqKey = $internalReqKey;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\IPReqAppResponseType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\IPReqAppResponseType
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IPReqAppResponseType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPReqAppResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
