<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPExt StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных IPExt «Исполнительное производство (расширенное)»
 * @subpackage Structs
 */
class IPExt extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DebtorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должника
     * @var string
     */
    public $DebtorType;
    /**
     * The DebtorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО полностью/наименование должника | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DebtorName;
    /**
     * The DebtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения ФЛ | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorBirthDate;
    /**
     * The DebtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения ФЛ | Год (выпуска, рождения и т. п.)
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $DebtorBirthYear;
    /**
     * The DebtorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН ЮЛ/ИП | ИНН
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $DebtorINN;
    /**
     * The DebtorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП | КПП
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $DebtorKPP;
    /**
     * The DebtorSnils
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС ФЛ | СНИЛС
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $DebtorSnils;
    /**
     * The DebtorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorAdr;
    /**
     * The DebtorTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Телефоный номер | Строка длиной от 1 до 16 символов
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $DebtorTelephone;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ИД
     * @var string
     */
    public $IDType;
    /**
     * The IDSubj
     * Meta informations extracted from the WSDL
     * - documentation: Код предмета исполнения | Код предмета исполнения | NSI_IDoc_Subj_Exec
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $IDSubj;
    /**
     * The IDOrgName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование органа, выдавшего ИД | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDOrgName;
    /**
     * The CaseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата дела | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $CaseDate;
    /**
     * The IPNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNum;
    /**
     * The IPDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждения ИП | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IPDate;
    /**
     * The IPNumComp
     * Meta informations extracted from the WSDL
     * - documentation: Номер сводного ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNumComp;
    /**
     * The IDSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма долга по ИД | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IDSum;
    /**
     * The IPDebtRestTotal
     * Meta informations extracted from the WSDL
     * - documentation: Остаток долга всего | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestTotal;
    /**
     * The IPDebtRestIp
     * Meta informations extracted from the WSDL
     * - documentation: Остаток основного долга по ИП | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestIp;
    /**
     * The IPDebtRestFine
     * Meta informations extracted from the WSDL
     * - documentation: Остаток основного долга по штрафу СПИ | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestFine;
    /**
     * The IPDebtRestDuty
     * Meta informations extracted from the WSDL
     * - documentation: Остаток задолженности по исполнительскому сбору | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestDuty;
    /**
     * The IPDebtRestBudg
     * Meta informations extracted from the WSDL
     * - documentation: Остаток задолженности по расходам по исполнительским действиям в бюджет | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestBudg;
    /**
     * The IPDebtRestOther
     * Meta informations extracted from the WSDL
     * - documentation: Остаток задолженности по расходам по исполнительским действиям третьим лицам | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestOther;
    /**
     * The IPPaymentDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата последнего поступления средств на депозитный счет по производству | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IPPaymentDate;
    /**
     * The IPPaymentAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма зачисленных, но не распределенных средств | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPPaymentAmount;
    /**
     * The OSPCode
     * Meta informations extracted from the WSDL
     * - documentation: ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OSPCode;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ краткое | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPITelephone
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Строка длиной от 1 до 18 символов
     * - maxLength: 18
     * - minLength: 1
     * @var string
     */
    public $SPITelephone;
    /**
     * Constructor method for IPExt
     * @uses IPExt::setInternalKey()
     * @uses IPExt::setDebtorType()
     * @uses IPExt::setDebtorName()
     * @uses IPExt::setDebtorBirthDate()
     * @uses IPExt::setDebtorBirthYear()
     * @uses IPExt::setDebtorINN()
     * @uses IPExt::setDebtorKPP()
     * @uses IPExt::setDebtorSnils()
     * @uses IPExt::setDebtorAdr()
     * @uses IPExt::setDebtorTelephone()
     * @uses IPExt::setIdExternalKey()
     * @uses IPExt::setIDDate()
     * @uses IPExt::setIDType()
     * @uses IPExt::setIDSubj()
     * @uses IPExt::setIDOrgName()
     * @uses IPExt::setCaseDate()
     * @uses IPExt::setIPNum()
     * @uses IPExt::setIPDate()
     * @uses IPExt::setIPNumComp()
     * @uses IPExt::setIDSum()
     * @uses IPExt::setIPDebtRestTotal()
     * @uses IPExt::setIPDebtRestIp()
     * @uses IPExt::setIPDebtRestFine()
     * @uses IPExt::setIPDebtRestDuty()
     * @uses IPExt::setIPDebtRestBudg()
     * @uses IPExt::setIPDebtRestOther()
     * @uses IPExt::setIPPaymentDate()
     * @uses IPExt::setIPPaymentAmount()
     * @uses IPExt::setOSPCode()
     * @uses IPExt::setSPIFio()
     * @uses IPExt::setSPITelephone()
     * @param int $internalKey
     * @param string $debtorType
     * @param string $debtorName
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorINN
     * @param string $debtorKPP
     * @param string $debtorSnils
     * @param string $debtorAdr
     * @param string $debtorTelephone
     * @param string $idExternalKey
     * @param string $iDDate
     * @param string $iDType
     * @param string $iDSubj
     * @param string $iDOrgName
     * @param string $caseDate
     * @param string $iPNum
     * @param string $iPDate
     * @param string $iPNumComp
     * @param float $iDSum
     * @param float $iPDebtRestTotal
     * @param float $iPDebtRestIp
     * @param float $iPDebtRestFine
     * @param float $iPDebtRestDuty
     * @param float $iPDebtRestBudg
     * @param float $iPDebtRestOther
     * @param string $iPPaymentDate
     * @param float $iPPaymentAmount
     * @param string $oSPCode
     * @param string $sPIFio
     * @param string $sPITelephone
     */
    public function __construct($internalKey = null, $debtorType = null, $debtorName = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorINN = null, $debtorKPP = null, $debtorSnils = null, $debtorAdr = null, $debtorTelephone = null, $idExternalKey = null, $iDDate = null, $iDType = null, $iDSubj = null, $iDOrgName = null, $caseDate = null, $iPNum = null, $iPDate = null, $iPNumComp = null, $iDSum = null, $iPDebtRestTotal = null, $iPDebtRestIp = null, $iPDebtRestFine = null, $iPDebtRestDuty = null, $iPDebtRestBudg = null, $iPDebtRestOther = null, $iPPaymentDate = null, $iPPaymentAmount = null, $oSPCode = null, $sPIFio = null, $sPITelephone = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setDebtorType($debtorType)
            ->setDebtorName($debtorName)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorINN($debtorINN)
            ->setDebtorKPP($debtorKPP)
            ->setDebtorSnils($debtorSnils)
            ->setDebtorAdr($debtorAdr)
            ->setDebtorTelephone($debtorTelephone)
            ->setIdExternalKey($idExternalKey)
            ->setIDDate($iDDate)
            ->setIDType($iDType)
            ->setIDSubj($iDSubj)
            ->setIDOrgName($iDOrgName)
            ->setCaseDate($caseDate)
            ->setIPNum($iPNum)
            ->setIPDate($iPDate)
            ->setIPNumComp($iPNumComp)
            ->setIDSum($iDSum)
            ->setIPDebtRestTotal($iPDebtRestTotal)
            ->setIPDebtRestIp($iPDebtRestIp)
            ->setIPDebtRestFine($iPDebtRestFine)
            ->setIPDebtRestDuty($iPDebtRestDuty)
            ->setIPDebtRestBudg($iPDebtRestBudg)
            ->setIPDebtRestOther($iPDebtRestOther)
            ->setIPPaymentDate($iPPaymentDate)
            ->setIPPaymentAmount($iPPaymentAmount)
            ->setOSPCode($oSPCode)
            ->setSPIFio($sPIFio)
            ->setSPITelephone($sPITelephone);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\IPExt
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DebtorType value
     * @return string|null
     */
    public function getDebtorType()
    {
        return $this->DebtorType;
    }
    /**
     * Set DebtorType value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorType
     * @return \StructType\IPExt
     */
    public function setDebtorType($debtorType = null)
    {
        $this->DebtorType = $debtorType;
        return $this;
    }
    /**
     * Get DebtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->DebtorName;
    }
    /**
     * Set DebtorName value
     * @param string $debtorName
     * @return \StructType\IPExt
     */
    public function setDebtorName($debtorName = null)
    {
        $this->DebtorName = $debtorName;
        return $this;
    }
    /**
     * Get DebtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->DebtorBirthDate;
    }
    /**
     * Set DebtorBirthDate value
     * @param string $debtorBirthDate
     * @return \StructType\IPExt
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        $this->DebtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get DebtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->DebtorBirthYear;
    }
    /**
     * Set DebtorBirthYear value
     * @param string $debtorBirthYear
     * @return \StructType\IPExt
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        $this->DebtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get DebtorINN value
     * @return string|null
     */
    public function getDebtorINN()
    {
        return $this->DebtorINN;
    }
    /**
     * Set DebtorINN value
     * @param string $debtorINN
     * @return \StructType\IPExt
     */
    public function setDebtorINN($debtorINN = null)
    {
        $this->DebtorINN = $debtorINN;
        return $this;
    }
    /**
     * Get DebtorKPP value
     * @return string|null
     */
    public function getDebtorKPP()
    {
        return $this->DebtorKPP;
    }
    /**
     * Set DebtorKPP value
     * @param string $debtorKPP
     * @return \StructType\IPExt
     */
    public function setDebtorKPP($debtorKPP = null)
    {
        $this->DebtorKPP = $debtorKPP;
        return $this;
    }
    /**
     * Get DebtorSnils value
     * @return string|null
     */
    public function getDebtorSnils()
    {
        return $this->DebtorSnils;
    }
    /**
     * Set DebtorSnils value
     * @param string $debtorSnils
     * @return \StructType\IPExt
     */
    public function setDebtorSnils($debtorSnils = null)
    {
        $this->DebtorSnils = $debtorSnils;
        return $this;
    }
    /**
     * Get DebtorAdr value
     * @return string|null
     */
    public function getDebtorAdr()
    {
        return $this->DebtorAdr;
    }
    /**
     * Set DebtorAdr value
     * @param string $debtorAdr
     * @return \StructType\IPExt
     */
    public function setDebtorAdr($debtorAdr = null)
    {
        $this->DebtorAdr = $debtorAdr;
        return $this;
    }
    /**
     * Get DebtorTelephone value
     * @return string|null
     */
    public function getDebtorTelephone()
    {
        return $this->DebtorTelephone;
    }
    /**
     * Set DebtorTelephone value
     * @param string $debtorTelephone
     * @return \StructType\IPExt
     */
    public function setDebtorTelephone($debtorTelephone = null)
    {
        $this->DebtorTelephone = $debtorTelephone;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \StructType\IPExt
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \StructType\IPExt
     */
    public function setIDDate($iDDate = null)
    {
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \EnumType\IdType::valueIsValid()
     * @uses \EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \StructType\IPExt
     */
    public function setIDType($iDType = null)
    {
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get IDSubj value
     * @return string|null
     */
    public function getIDSubj()
    {
        return $this->IDSubj;
    }
    /**
     * Set IDSubj value
     * @param string $iDSubj
     * @return \StructType\IPExt
     */
    public function setIDSubj($iDSubj = null)
    {
        $this->IDSubj = $iDSubj;
        return $this;
    }
    /**
     * Get IDOrgName value
     * @return string|null
     */
    public function getIDOrgName()
    {
        return $this->IDOrgName;
    }
    /**
     * Set IDOrgName value
     * @param string $iDOrgName
     * @return \StructType\IPExt
     */
    public function setIDOrgName($iDOrgName = null)
    {
        $this->IDOrgName = $iDOrgName;
        return $this;
    }
    /**
     * Get CaseDate value
     * @return string|null
     */
    public function getCaseDate()
    {
        return $this->CaseDate;
    }
    /**
     * Set CaseDate value
     * @param string $caseDate
     * @return \StructType\IPExt
     */
    public function setCaseDate($caseDate = null)
    {
        $this->CaseDate = $caseDate;
        return $this;
    }
    /**
     * Get IPNum value
     * @return string|null
     */
    public function getIPNum()
    {
        return $this->IPNum;
    }
    /**
     * Set IPNum value
     * @param string $iPNum
     * @return \StructType\IPExt
     */
    public function setIPNum($iPNum = null)
    {
        $this->IPNum = $iPNum;
        return $this;
    }
    /**
     * Get IPDate value
     * @return string|null
     */
    public function getIPDate()
    {
        return $this->IPDate;
    }
    /**
     * Set IPDate value
     * @param string $iPDate
     * @return \StructType\IPExt
     */
    public function setIPDate($iPDate = null)
    {
        $this->IPDate = $iPDate;
        return $this;
    }
    /**
     * Get IPNumComp value
     * @return string|null
     */
    public function getIPNumComp()
    {
        return $this->IPNumComp;
    }
    /**
     * Set IPNumComp value
     * @param string $iPNumComp
     * @return \StructType\IPExt
     */
    public function setIPNumComp($iPNumComp = null)
    {
        $this->IPNumComp = $iPNumComp;
        return $this;
    }
    /**
     * Get IDSum value
     * @return float|null
     */
    public function getIDSum()
    {
        return $this->IDSum;
    }
    /**
     * Set IDSum value
     * @param float $iDSum
     * @return \StructType\IPExt
     */
    public function setIDSum($iDSum = null)
    {
        $this->IDSum = $iDSum;
        return $this;
    }
    /**
     * Get IPDebtRestTotal value
     * @return float|null
     */
    public function getIPDebtRestTotal()
    {
        return $this->IPDebtRestTotal;
    }
    /**
     * Set IPDebtRestTotal value
     * @param float $iPDebtRestTotal
     * @return \StructType\IPExt
     */
    public function setIPDebtRestTotal($iPDebtRestTotal = null)
    {
        $this->IPDebtRestTotal = $iPDebtRestTotal;
        return $this;
    }
    /**
     * Get IPDebtRestIp value
     * @return float|null
     */
    public function getIPDebtRestIp()
    {
        return $this->IPDebtRestIp;
    }
    /**
     * Set IPDebtRestIp value
     * @param float $iPDebtRestIp
     * @return \StructType\IPExt
     */
    public function setIPDebtRestIp($iPDebtRestIp = null)
    {
        $this->IPDebtRestIp = $iPDebtRestIp;
        return $this;
    }
    /**
     * Get IPDebtRestFine value
     * @return float|null
     */
    public function getIPDebtRestFine()
    {
        return $this->IPDebtRestFine;
    }
    /**
     * Set IPDebtRestFine value
     * @param float $iPDebtRestFine
     * @return \StructType\IPExt
     */
    public function setIPDebtRestFine($iPDebtRestFine = null)
    {
        $this->IPDebtRestFine = $iPDebtRestFine;
        return $this;
    }
    /**
     * Get IPDebtRestDuty value
     * @return float|null
     */
    public function getIPDebtRestDuty()
    {
        return $this->IPDebtRestDuty;
    }
    /**
     * Set IPDebtRestDuty value
     * @param float $iPDebtRestDuty
     * @return \StructType\IPExt
     */
    public function setIPDebtRestDuty($iPDebtRestDuty = null)
    {
        $this->IPDebtRestDuty = $iPDebtRestDuty;
        return $this;
    }
    /**
     * Get IPDebtRestBudg value
     * @return float|null
     */
    public function getIPDebtRestBudg()
    {
        return $this->IPDebtRestBudg;
    }
    /**
     * Set IPDebtRestBudg value
     * @param float $iPDebtRestBudg
     * @return \StructType\IPExt
     */
    public function setIPDebtRestBudg($iPDebtRestBudg = null)
    {
        $this->IPDebtRestBudg = $iPDebtRestBudg;
        return $this;
    }
    /**
     * Get IPDebtRestOther value
     * @return float|null
     */
    public function getIPDebtRestOther()
    {
        return $this->IPDebtRestOther;
    }
    /**
     * Set IPDebtRestOther value
     * @param float $iPDebtRestOther
     * @return \StructType\IPExt
     */
    public function setIPDebtRestOther($iPDebtRestOther = null)
    {
        $this->IPDebtRestOther = $iPDebtRestOther;
        return $this;
    }
    /**
     * Get IPPaymentDate value
     * @return string|null
     */
    public function getIPPaymentDate()
    {
        return $this->IPPaymentDate;
    }
    /**
     * Set IPPaymentDate value
     * @param string $iPPaymentDate
     * @return \StructType\IPExt
     */
    public function setIPPaymentDate($iPPaymentDate = null)
    {
        $this->IPPaymentDate = $iPPaymentDate;
        return $this;
    }
    /**
     * Get IPPaymentAmount value
     * @return float|null
     */
    public function getIPPaymentAmount()
    {
        return $this->IPPaymentAmount;
    }
    /**
     * Set IPPaymentAmount value
     * @param float $iPPaymentAmount
     * @return \StructType\IPExt
     */
    public function setIPPaymentAmount($iPPaymentAmount = null)
    {
        $this->IPPaymentAmount = $iPPaymentAmount;
        return $this;
    }
    /**
     * Get OSPCode value
     * @return string|null
     */
    public function getOSPCode()
    {
        return $this->OSPCode;
    }
    /**
     * Set OSPCode value
     * @param string $oSPCode
     * @return \StructType\IPExt
     */
    public function setOSPCode($oSPCode = null)
    {
        $this->OSPCode = $oSPCode;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \StructType\IPExt
     */
    public function setSPIFio($sPIFio = null)
    {
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPITelephone value
     * @return string|null
     */
    public function getSPITelephone()
    {
        return $this->SPITelephone;
    }
    /**
     * Set SPITelephone value
     * @param string $sPITelephone
     * @return \StructType\IPExt
     */
    public function setSPITelephone($sPITelephone = null)
    {
        $this->SPITelephone = $sPITelephone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPExt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
