<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPDataInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Информация об исполнительных производствах | ЭП
 * - type: tns:IPDataInfo
 * @subpackage Structs
 */
class IPDataInfo extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The ip
     * Meta informations extracted from the WSDL
     * - documentation: ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IP[]
     */
    public $ip;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $data;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPDataInfo
     * @uses IPDataInfo::setInternalKey()
     * @uses IPDataInfo::setRequestKey()
     * @uses IPDataInfo::setIp()
     * @uses IPDataInfo::setData()
     * @uses IPDataInfo::setSignature()
     * @uses IPDataInfo::setId()
     * @param int $internalKey
     * @param string $requestKey
     * @param \StructType\IP[] $ip
     * @param \StructType\Data[] $data
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $requestKey = null, array $ip = array(), array $data = array(), array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestKey($requestKey)
            ->setIp($ip)
            ->setData($data)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \StructType\IPDataInfo
     */
    public function setInternalKey($internalKey = null)
    {
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \StructType\IPDataInfo
     */
    public function setRequestKey($requestKey = null)
    {
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get ip value
     * @return \StructType\IP[]|null
     */
    public function getIp()
    {
        return $this->ip;
    }
    /**
     * Set ip value
     * @throws \InvalidArgumentException
     * @param \StructType\IP[] $ip
     * @return \StructType\IPDataInfo
     */
    public function setIp(array $ip = array())
    {
        $this->ip = $ip;
        return $this;
    }
    /**
     * Add item to ip value
     * @throws \InvalidArgumentException
     * @param \StructType\IP $item
     * @return \StructType\IPDataInfo
     */
    public function addToIp(\StructType\IP $item)
    {
        $this->ip[] = $item;
        return $this;
    }
    /**
     * Get data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\IPDataInfo
     */
    public function setData(array $data = array())
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Add item to data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\IPDataInfo
     */
    public function addToData(\StructType\Data $item)
    {
        $this->data[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\IPDataInfo
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\IPDataInfo
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IPDataInfo
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPDataInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
