<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPBriefInfoRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявление о наличии ИП в банке данных (по номеру ИП) | Используется для получения сведений об ИП по номеру ИП. | ЭП
 * @subpackage Structs
 */
class IPBriefInfoRequestType extends AbstractStructBase
{
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса ЕПГУ или АИС внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС,
     * ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с
     * конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The IPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | В текущей версии сервиса возможен запрос по одному номеру ИП | Номер документа
     * - maxOccurs: unbounded
     * - maxLength: 25
     * - minLength: 1
     * @var string[]
     */
    public $IPNumber;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPBriefInfoRequestType
     * @uses IPBriefInfoRequestType::setRequestKey()
     * @uses IPBriefInfoRequestType::setIPNumber()
     * @uses IPBriefInfoRequestType::setSignature()
     * @uses IPBriefInfoRequestType::setId()
     * @param string $requestKey
     * @param string[] $iPNumber
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($requestKey = null, array $iPNumber = array(), array $signature = array(), $id = null)
    {
        $this
            ->setRequestKey($requestKey)
            ->setIPNumber($iPNumber)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \StructType\IPBriefInfoRequestType
     */
    public function setRequestKey($requestKey = null)
    {
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get IPNumber value
     * @return string[]|null
     */
    public function getIPNumber()
    {
        return $this->IPNumber;
    }
    /**
     * Set IPNumber value
     * @throws \InvalidArgumentException
     * @param string[] $iPNumber
     * @return \StructType\IPBriefInfoRequestType
     */
    public function setIPNumber(array $iPNumber = array())
    {
        $this->IPNumber = $iPNumber;
        return $this;
    }
    /**
     * Add item to IPNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\IPBriefInfoRequestType
     */
    public function addToIPNumber($item)
    {
        $this->IPNumber[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\IPBriefInfoRequestType
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\IPBriefInfoRequestType
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IPBriefInfoRequestType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IPBriefInfoRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
