<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о товаре
 * @subpackage Structs
 */
class GoodsDatumType extends InformationType
{
    /**
     * The GoodsType
     * Meta informations extracted from the WSDL
     * - documentation: Тип сведений о товаре
     * @var string
     */
    public $GoodsType;
    /**
     * The GoodsName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование товара | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $GoodsName;
    /**
     * The GoodsCost
     * Meta informations extracted from the WSDL
     * - documentation: Стоимость товара | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $GoodsCost;
    /**
     * The MoveDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата товара | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $MoveDate;
    /**
     * The SourceCountry
     * Meta informations extracted from the WSDL
     * - documentation: Место | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $SourceCountry;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - documentation: Направление | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Direction;
    /**
     * The Grounds
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительная информация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Grounds;
    /**
     * Constructor method for GoodsDatumType
     * @uses GoodsDatumType::setGoodsType()
     * @uses GoodsDatumType::setGoodsName()
     * @uses GoodsDatumType::setGoodsCost()
     * @uses GoodsDatumType::setMoveDate()
     * @uses GoodsDatumType::setSourceCountry()
     * @uses GoodsDatumType::setDirection()
     * @uses GoodsDatumType::setGrounds()
     * @param string $goodsType
     * @param string $goodsName
     * @param float $goodsCost
     * @param string $moveDate
     * @param string $sourceCountry
     * @param string $direction
     * @param string $grounds
     */
    public function __construct($goodsType = null, $goodsName = null, $goodsCost = null, $moveDate = null, $sourceCountry = null, $direction = null, $grounds = null)
    {
        $this
            ->setGoodsType($goodsType)
            ->setGoodsName($goodsName)
            ->setGoodsCost($goodsCost)
            ->setMoveDate($moveDate)
            ->setSourceCountry($sourceCountry)
            ->setDirection($direction)
            ->setGrounds($grounds);
    }
    /**
     * Get GoodsType value
     * @return string|null
     */
    public function getGoodsType()
    {
        return $this->GoodsType;
    }
    /**
     * Set GoodsType value
     * @uses \EnumType\GoodsType::valueIsValid()
     * @uses \EnumType\GoodsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $goodsType
     * @return \StructType\GoodsDatumType
     */
    public function setGoodsType($goodsType = null)
    {
        $this->GoodsType = $goodsType;
        return $this;
    }
    /**
     * Get GoodsName value
     * @return string|null
     */
    public function getGoodsName()
    {
        return $this->GoodsName;
    }
    /**
     * Set GoodsName value
     * @param string $goodsName
     * @return \StructType\GoodsDatumType
     */
    public function setGoodsName($goodsName = null)
    {
        $this->GoodsName = $goodsName;
        return $this;
    }
    /**
     * Get GoodsCost value
     * @return float|null
     */
    public function getGoodsCost()
    {
        return $this->GoodsCost;
    }
    /**
     * Set GoodsCost value
     * @param float $goodsCost
     * @return \StructType\GoodsDatumType
     */
    public function setGoodsCost($goodsCost = null)
    {
        $this->GoodsCost = $goodsCost;
        return $this;
    }
    /**
     * Get MoveDate value
     * @return string|null
     */
    public function getMoveDate()
    {
        return $this->MoveDate;
    }
    /**
     * Set MoveDate value
     * @param string $moveDate
     * @return \StructType\GoodsDatumType
     */
    public function setMoveDate($moveDate = null)
    {
        $this->MoveDate = $moveDate;
        return $this;
    }
    /**
     * Get SourceCountry value
     * @return string|null
     */
    public function getSourceCountry()
    {
        return $this->SourceCountry;
    }
    /**
     * Set SourceCountry value
     * @param string $sourceCountry
     * @return \StructType\GoodsDatumType
     */
    public function setSourceCountry($sourceCountry = null)
    {
        $this->SourceCountry = $sourceCountry;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \StructType\GoodsDatumType
     */
    public function setDirection($direction = null)
    {
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Grounds value
     * @return string|null
     */
    public function getGrounds()
    {
        return $this->Grounds;
    }
    /**
     * Set Grounds value
     * @param string $grounds
     * @return \StructType\GoodsDatumType
     */
    public function setGrounds($grounds = null)
    {
        $this->Grounds = $grounds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GoodsDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
