<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMessagesRq StructType
 * Meta informations extracted from the WSDL
 * - documentation: Параметры запрашиваемых сообщений
 * @subpackage Structs
 */
class GetMessagesRq extends Request
{
    /**
     * The maxCount
     * Meta informations extracted from the WSDL
     * - documentation: Максимальное число сообщений с пакетами документов в ответе
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $maxCount;
    /**
     * The clientGeneration
     * Meta informations extracted from the WSDL
     * - documentation: Номер последнего имеющегося у клиента веб-сервиса поколения пакета данных
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $clientGeneration;
    /**
     * Constructor method for GetMessagesRq
     * @uses GetMessagesRq::setMaxCount()
     * @uses GetMessagesRq::setClientGeneration()
     * @param int $maxCount
     * @param int $clientGeneration
     */
    public function __construct($maxCount = null, $clientGeneration = null)
    {
        $this
            ->setMaxCount($maxCount)
            ->setClientGeneration($clientGeneration);
    }
    /**
     * Get maxCount value
     * @return int|null
     */
    public function getMaxCount()
    {
        return $this->maxCount;
    }
    /**
     * Set maxCount value
     * @param int $maxCount
     * @return \StructType\GetMessagesRq
     */
    public function setMaxCount($maxCount = null)
    {
        $this->maxCount = $maxCount;
        return $this;
    }
    /**
     * Get clientGeneration value
     * @return int|null
     */
    public function getClientGeneration()
    {
        return $this->clientGeneration;
    }
    /**
     * Set clientGeneration value
     * @param int $clientGeneration
     * @return \StructType\GetMessagesRq
     */
    public function setClientGeneration($clientGeneration = null)
    {
        $this->clientGeneration = $clientGeneration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMessagesRq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
