<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForgnFndrCompanyDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об иностранном учредителе — юридическом лице
 * @subpackage Structs
 */
class ForgnFndrCompanyDatumType extends CompanyDatumType
{
    /**
     * The capitalAmount
     * Meta informations extracted from the WSDL
     * - documentation: Размер вклада в уставной капитал учредителя (в рублях) | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $capitalAmount;
    /**
     * The countryId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор страны | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $countryId;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: Код страны | Код страны буквенный | Трехзначный (альфа-3) буквенный код страны мира по классификатору ОКСМ
     * - minOccurs: 0
     * - length: 3
     * @var string
     */
    public $countryCode;
    /**
     * The countryName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование страны | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $countryName;
    /**
     * Constructor method for ForgnFndrCompanyDatumType
     * @uses ForgnFndrCompanyDatumType::setCapitalAmount()
     * @uses ForgnFndrCompanyDatumType::setCountryId()
     * @uses ForgnFndrCompanyDatumType::setCountryCode()
     * @uses ForgnFndrCompanyDatumType::setCountryName()
     * @param float $capitalAmount
     * @param int $countryId
     * @param string $countryCode
     * @param string $countryName
     */
    public function __construct($capitalAmount = null, $countryId = null, $countryCode = null, $countryName = null)
    {
        $this
            ->setCapitalAmount($capitalAmount)
            ->setCountryId($countryId)
            ->setCountryCode($countryCode)
            ->setCountryName($countryName);
    }
    /**
     * Get capitalAmount value
     * @return float|null
     */
    public function getCapitalAmount()
    {
        return $this->capitalAmount;
    }
    /**
     * Set capitalAmount value
     * @param float $capitalAmount
     * @return \StructType\ForgnFndrCompanyDatumType
     */
    public function setCapitalAmount($capitalAmount = null)
    {
        $this->capitalAmount = $capitalAmount;
        return $this;
    }
    /**
     * Get countryId value
     * @return int|null
     */
    public function getCountryId()
    {
        return $this->countryId;
    }
    /**
     * Set countryId value
     * @param int $countryId
     * @return \StructType\ForgnFndrCompanyDatumType
     */
    public function setCountryId($countryId = null)
    {
        $this->countryId = $countryId;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\ForgnFndrCompanyDatumType
     */
    public function setCountryCode($countryCode = null)
    {
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get countryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->countryName;
    }
    /**
     * Set countryName value
     * @param string $countryName
     * @return \StructType\ForgnFndrCompanyDatumType
     */
    public function setCountryName($countryName = null)
    {
        $this->countryName = $countryName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ForgnFndrCompanyDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
