<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForcedExecDocumentRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос на получение документа по внутренней прямой ссылке | используется для получения электронного документа стороной
 * исполнительного производства по его реквизитам
 * - type: tns:ForcedExecDocumentRequest
 * @subpackage Structs
 */
class ForcedExecDocumentRequest extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса | Идентификатор запроса, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа (бар-код) | Штрих-код в формате code39
     * - maxLength: 44
     * - minLength: 1
     * - pattern: [0-9A-Z\-\.\+$/%]+
     * @var string
     */
    public $Barcode;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The IpSideFio
     * Meta informations extracted from the WSDL
     * - documentation: Сторона исполнительного производства
     * @var \StructType\FioType
     */
    public $IpSideFio;
    /**
     * The PrincipalSNILS
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС обратившегося лица | СНИЛС
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $PrincipalSNILS;
    /**
     * The PrincipalFio
     * Meta informations extracted from the WSDL
     * - documentation: Владелец сертификата
     * @var \StructType\FioType
     */
    public $PrincipalFio;
    /**
     * Constructor method for ForcedExecDocumentRequest
     * @uses ForcedExecDocumentRequest::setExternalKey()
     * @uses ForcedExecDocumentRequest::setBarcode()
     * @uses ForcedExecDocumentRequest::setDocNumber()
     * @uses ForcedExecDocumentRequest::setDocDate()
     * @uses ForcedExecDocumentRequest::setIpSideFio()
     * @uses ForcedExecDocumentRequest::setPrincipalSNILS()
     * @uses ForcedExecDocumentRequest::setPrincipalFio()
     * @param string $externalKey
     * @param string $barcode
     * @param string $docNumber
     * @param string $docDate
     * @param \StructType\FioType $ipSideFio
     * @param string $principalSNILS
     * @param \StructType\FioType $principalFio
     */
    public function __construct($externalKey = null, $barcode = null, $docNumber = null, $docDate = null, \StructType\FioType $ipSideFio = null, $principalSNILS = null, \StructType\FioType $principalFio = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setBarcode($barcode)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setIpSideFio($ipSideFio)
            ->setPrincipalSNILS($principalSNILS)
            ->setPrincipalFio($principalFio);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\ForcedExecDocumentRequest
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\ForcedExecDocumentRequest
     */
    public function setBarcode($barcode = null)
    {
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\ForcedExecDocumentRequest
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\ForcedExecDocumentRequest
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get IpSideFio value
     * @return \StructType\FioType|null
     */
    public function getIpSideFio()
    {
        return $this->IpSideFio;
    }
    /**
     * Set IpSideFio value
     * @param \StructType\FioType $ipSideFio
     * @return \StructType\ForcedExecDocumentRequest
     */
    public function setIpSideFio(\StructType\FioType $ipSideFio = null)
    {
        $this->IpSideFio = $ipSideFio;
        return $this;
    }
    /**
     * Get PrincipalSNILS value
     * @return string|null
     */
    public function getPrincipalSNILS()
    {
        return $this->PrincipalSNILS;
    }
    /**
     * Set PrincipalSNILS value
     * @param string $principalSNILS
     * @return \StructType\ForcedExecDocumentRequest
     */
    public function setPrincipalSNILS($principalSNILS = null)
    {
        $this->PrincipalSNILS = $principalSNILS;
        return $this;
    }
    /**
     * Get PrincipalFio value
     * @return \StructType\FioType|null
     */
    public function getPrincipalFio()
    {
        return $this->PrincipalFio;
    }
    /**
     * Set PrincipalFio value
     * @param \StructType\FioType $principalFio
     * @return \StructType\ForcedExecDocumentRequest
     */
    public function setPrincipalFio(\StructType\FioType $principalFio = null)
    {
        $this->PrincipalFio = $principalFio;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ForcedExecDocumentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
