<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FishDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о биоресурсах
 * @subpackage Structs
 */
abstract class FishDatumType extends InformationType
{
    /**
     * The organName
     * Meta informations extracted from the WSDL
     * - documentation: Орган исполнительной власти | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $organName;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The resourceCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида водного биоресурса | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $resourceCode;
    /**
     * The resourceName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида водного биоресурса | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $resourceName;
    /**
     * The areaCode
     * Meta informations extracted from the WSDL
     * - documentation: Код района добычи | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $areaCode;
    /**
     * The areaName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование района добычи | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $areaName;
    /**
     * Constructor method for FishDatumType
     * @uses FishDatumType::setOrganName()
     * @uses FishDatumType::setDocDate()
     * @uses FishDatumType::setDocNumber()
     * @uses FishDatumType::setResourceCode()
     * @uses FishDatumType::setResourceName()
     * @uses FishDatumType::setAreaCode()
     * @uses FishDatumType::setAreaName()
     * @param string $organName
     * @param string $docDate
     * @param string $docNumber
     * @param string $resourceCode
     * @param string $resourceName
     * @param string $areaCode
     * @param string $areaName
     */
    public function __construct($organName = null, $docDate = null, $docNumber = null, $resourceCode = null, $resourceName = null, $areaCode = null, $areaName = null)
    {
        $this
            ->setOrganName($organName)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setResourceCode($resourceCode)
            ->setResourceName($resourceName)
            ->setAreaCode($areaCode)
            ->setAreaName($areaName);
    }
    /**
     * Get organName value
     * @return string|null
     */
    public function getOrganName()
    {
        return $this->organName;
    }
    /**
     * Set organName value
     * @param string $organName
     * @return \StructType\FishDatumType
     */
    public function setOrganName($organName = null)
    {
        $this->organName = $organName;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \StructType\FishDatumType
     */
    public function setDocDate($docDate = null)
    {
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \StructType\FishDatumType
     */
    public function setDocNumber($docNumber = null)
    {
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get resourceCode value
     * @return string|null
     */
    public function getResourceCode()
    {
        return $this->resourceCode;
    }
    /**
     * Set resourceCode value
     * @param string $resourceCode
     * @return \StructType\FishDatumType
     */
    public function setResourceCode($resourceCode = null)
    {
        $this->resourceCode = $resourceCode;
        return $this;
    }
    /**
     * Get resourceName value
     * @return string|null
     */
    public function getResourceName()
    {
        return $this->resourceName;
    }
    /**
     * Set resourceName value
     * @param string $resourceName
     * @return \StructType\FishDatumType
     */
    public function setResourceName($resourceName = null)
    {
        $this->resourceName = $resourceName;
        return $this;
    }
    /**
     * Get areaCode value
     * @return string|null
     */
    public function getAreaCode()
    {
        return $this->areaCode;
    }
    /**
     * Set areaCode value
     * @param string $areaCode
     * @return \StructType\FishDatumType
     */
    public function setAreaCode($areaCode = null)
    {
        $this->areaCode = $areaCode;
        return $this;
    }
    /**
     * Get areaName value
     * @return string|null
     */
    public function getAreaName()
    {
        return $this->areaName;
    }
    /**
     * Set areaName value
     * @param string $areaName
     * @return \StructType\FishDatumType
     */
    public function setAreaName($areaName = null)
    {
        $this->areaName = $areaName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FishDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
