<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FioType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Фамилия, имя, отчество
 * @subpackage Structs
 */
class FioType extends AbstractStructBase
{
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - documentation: Фамилия | Строка длиной от 1 до 60 символов
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Surname;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - documentation: Имя | Строка длиной от 1 до 60 символов
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $FirstName;
    /**
     * The Patronymic
     * Meta informations extracted from the WSDL
     * - documentation: Отчество | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Patronymic;
    /**
     * Constructor method for FioType
     * @uses FioType::setSurname()
     * @uses FioType::setFirstName()
     * @uses FioType::setPatronymic()
     * @param string $surname
     * @param string $firstName
     * @param string $patronymic
     */
    public function __construct($surname = null, $firstName = null, $patronymic = null)
    {
        $this
            ->setSurname($surname)
            ->setFirstName($firstName)
            ->setPatronymic($patronymic);
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\FioType
     */
    public function setSurname($surname = null)
    {
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\FioType
     */
    public function setFirstName($firstName = null)
    {
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Patronymic value
     * @return string|null
     */
    public function getPatronymic()
    {
        return $this->Patronymic;
    }
    /**
     * Set Patronymic value
     * @param string $patronymic
     * @return \StructType\FioType
     */
    public function setPatronymic($patronymic = null)
    {
        $this->Patronymic = $patronymic;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FioType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
