<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileBlockInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Информация о фрагменте файла
 * @subpackage Structs
 */
class FileBlockInfo extends AbstractStructBase
{
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - documentation: Смещение от начала файла, байт | Смещение от начала файла
     * - minInclusive: 0
     * @var int
     */
    public $offset;
    /**
     * The length
     * Meta informations extracted from the WSDL
     * - documentation: Длина фрагмента файла в байтах | Размер файла
     * - minInclusive: 0
     * @var int
     */
    public $length;
    /**
     * The receiver_pack_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор пакета | Заполняется для пакетного режима передачи данных | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $receiver_pack_id;
    /**
     * The receiver_env_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор конверта | Заполняется для пакетного режима передачи данных | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $receiver_env_id;
    /**
     * The receiver_doc_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа | Заполняется для типа файла DOCUMENT, ALL_ATTACHMENTS, SINGLE_ATTACHMENT | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $receiver_doc_id;
    /**
     * The encoding
     * Meta informations extracted from the WSDL
     * - documentation: Код таблицы символов в формате "IANA CHARACTER SETS"
     * - maxLength: 40
     * - minLength: 1
     * @var string
     */
    public $encoding;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - documentation: Размер файла
     * - minInclusive: 0
     * @var int
     */
    public $size;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The digest
     * Meta informations extracted from the WSDL
     * - length: 32
     * @var string
     */
    public $digest;
    /**
     * The signature_digest
     * Meta informations extracted from the WSDL
     * - length: 32
     * @var string
     */
    public $signature_digest;
    /**
     * The pack_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $pack_id;
    /**
     * The env_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $env_id;
    /**
     * The doc_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $doc_id;
    /**
     * The attachmentTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип вложения
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $attachmentTypeCode;
    /**
     * The systemCode1
     * Meta informations extracted from the WSDL
     * - documentation: Системный код 1
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $systemCode1;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The content_type
     * Meta informations extracted from the WSDL
     * - documentation: MIME-тип данных | MIME-тип данных
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $content_type;
    /**
     * The attachment_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $attachment_id;
    /**
     * Constructor method for FileBlockInfo
     * @uses FileBlockInfo::setOffset()
     * @uses FileBlockInfo::setLength()
     * @uses FileBlockInfo::setReceiver_pack_id()
     * @uses FileBlockInfo::setReceiver_env_id()
     * @uses FileBlockInfo::setReceiver_doc_id()
     * @uses FileBlockInfo::setEncoding()
     * @uses FileBlockInfo::setSize()
     * @uses FileBlockInfo::setType()
     * @uses FileBlockInfo::setDigest()
     * @uses FileBlockInfo::setSignature_digest()
     * @uses FileBlockInfo::setPack_id()
     * @uses FileBlockInfo::setEnv_id()
     * @uses FileBlockInfo::setDoc_id()
     * @uses FileBlockInfo::setAttachmentTypeCode()
     * @uses FileBlockInfo::setSystemCode1()
     * @uses FileBlockInfo::setName()
     * @uses FileBlockInfo::setContent_type()
     * @uses FileBlockInfo::setAttachment_id()
     * @param int $offset
     * @param int $length
     * @param string $receiver_pack_id
     * @param string $receiver_env_id
     * @param string $receiver_doc_id
     * @param string $encoding
     * @param int $size
     * @param string $type
     * @param string $digest
     * @param string $signature_digest
     * @param string $pack_id
     * @param string $env_id
     * @param string $doc_id
     * @param string $attachmentTypeCode
     * @param string $systemCode1
     * @param string $name
     * @param string $content_type
     * @param string $attachment_id
     */
    public function __construct($offset = null, $length = null, $receiver_pack_id = null, $receiver_env_id = null, $receiver_doc_id = null, $encoding = null, $size = null, $type = null, $digest = null, $signature_digest = null, $pack_id = null, $env_id = null, $doc_id = null, $attachmentTypeCode = null, $systemCode1 = null, $name = null, $content_type = null, $attachment_id = null)
    {
        $this
            ->setOffset($offset)
            ->setLength($length)
            ->setReceiver_pack_id($receiver_pack_id)
            ->setReceiver_env_id($receiver_env_id)
            ->setReceiver_doc_id($receiver_doc_id)
            ->setEncoding($encoding)
            ->setSize($size)
            ->setType($type)
            ->setDigest($digest)
            ->setSignature_digest($signature_digest)
            ->setPack_id($pack_id)
            ->setEnv_id($env_id)
            ->setDoc_id($doc_id)
            ->setAttachmentTypeCode($attachmentTypeCode)
            ->setSystemCode1($systemCode1)
            ->setName($name)
            ->setContent_type($content_type)
            ->setAttachment_id($attachment_id);
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\FileBlockInfo
     */
    public function setOffset($offset = null)
    {
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param int $length
     * @return \StructType\FileBlockInfo
     */
    public function setLength($length = null)
    {
        $this->length = $length;
        return $this;
    }
    /**
     * Get receiver_pack_id value
     * @return string|null
     */
    public function getReceiver_pack_id()
    {
        return $this->receiver_pack_id;
    }
    /**
     * Set receiver_pack_id value
     * @param string $receiver_pack_id
     * @return \StructType\FileBlockInfo
     */
    public function setReceiver_pack_id($receiver_pack_id = null)
    {
        $this->receiver_pack_id = $receiver_pack_id;
        return $this;
    }
    /**
     * Get receiver_env_id value
     * @return string|null
     */
    public function getReceiver_env_id()
    {
        return $this->receiver_env_id;
    }
    /**
     * Set receiver_env_id value
     * @param string $receiver_env_id
     * @return \StructType\FileBlockInfo
     */
    public function setReceiver_env_id($receiver_env_id = null)
    {
        $this->receiver_env_id = $receiver_env_id;
        return $this;
    }
    /**
     * Get receiver_doc_id value
     * @return string|null
     */
    public function getReceiver_doc_id()
    {
        return $this->receiver_doc_id;
    }
    /**
     * Set receiver_doc_id value
     * @param string $receiver_doc_id
     * @return \StructType\FileBlockInfo
     */
    public function setReceiver_doc_id($receiver_doc_id = null)
    {
        $this->receiver_doc_id = $receiver_doc_id;
        return $this;
    }
    /**
     * Get encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->encoding;
    }
    /**
     * Set encoding value
     * @param string $encoding
     * @return \StructType\FileBlockInfo
     */
    public function setEncoding($encoding = null)
    {
        $this->encoding = $encoding;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\FileBlockInfo
     */
    public function setSize($size = null)
    {
        $this->size = $size;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\FileType::valueIsValid()
     * @uses \EnumType\FileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\FileBlockInfo
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get digest value
     * @return string|null
     */
    public function getDigest()
    {
        return $this->digest;
    }
    /**
     * Set digest value
     * @param string $digest
     * @return \StructType\FileBlockInfo
     */
    public function setDigest($digest = null)
    {
        $this->digest = $digest;
        return $this;
    }
    /**
     * Get signature_digest value
     * @return string|null
     */
    public function getSignature_digest()
    {
        return $this->signature_digest;
    }
    /**
     * Set signature_digest value
     * @param string $signature_digest
     * @return \StructType\FileBlockInfo
     */
    public function setSignature_digest($signature_digest = null)
    {
        $this->signature_digest = $signature_digest;
        return $this;
    }
    /**
     * Get pack_id value
     * @return string|null
     */
    public function getPack_id()
    {
        return $this->pack_id;
    }
    /**
     * Set pack_id value
     * @param string $pack_id
     * @return \StructType\FileBlockInfo
     */
    public function setPack_id($pack_id = null)
    {
        $this->pack_id = $pack_id;
        return $this;
    }
    /**
     * Get env_id value
     * @return string|null
     */
    public function getEnv_id()
    {
        return $this->env_id;
    }
    /**
     * Set env_id value
     * @param string $env_id
     * @return \StructType\FileBlockInfo
     */
    public function setEnv_id($env_id = null)
    {
        $this->env_id = $env_id;
        return $this;
    }
    /**
     * Get doc_id value
     * @return string|null
     */
    public function getDoc_id()
    {
        return $this->doc_id;
    }
    /**
     * Set doc_id value
     * @param string $doc_id
     * @return \StructType\FileBlockInfo
     */
    public function setDoc_id($doc_id = null)
    {
        $this->doc_id = $doc_id;
        return $this;
    }
    /**
     * Get attachmentTypeCode value
     * @return string|null
     */
    public function getAttachmentTypeCode()
    {
        return $this->attachmentTypeCode;
    }
    /**
     * Set attachmentTypeCode value
     * @param string $attachmentTypeCode
     * @return \StructType\FileBlockInfo
     */
    public function setAttachmentTypeCode($attachmentTypeCode = null)
    {
        $this->attachmentTypeCode = $attachmentTypeCode;
        return $this;
    }
    /**
     * Get systemCode1 value
     * @return string|null
     */
    public function getSystemCode1()
    {
        return $this->systemCode1;
    }
    /**
     * Set systemCode1 value
     * @param string $systemCode1
     * @return \StructType\FileBlockInfo
     */
    public function setSystemCode1($systemCode1 = null)
    {
        $this->systemCode1 = $systemCode1;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\FileBlockInfo
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get content_type value
     * @return string|null
     */
    public function getContent_type()
    {
        return $this->content_type;
    }
    /**
     * Set content_type value
     * @param string $content_type
     * @return \StructType\FileBlockInfo
     */
    public function setContent_type($content_type = null)
    {
        $this->content_type = $content_type;
        return $this;
    }
    /**
     * Get attachment_id value
     * @return string|null
     */
    public function getAttachment_id()
    {
        return $this->attachment_id;
    }
    /**
     * Set attachment_id value
     * @param string $attachment_id
     * @return \StructType\FileBlockInfo
     */
    public function setAttachment_id($attachment_id = null)
    {
        $this->attachment_id = $attachment_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FileBlockInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
