<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for File StructType
 * Meta informations extracted from the WSDL
 * - documentation: Режим работы файлового обмена
 * @subpackage Structs
 */
class File extends AbstractStructBase
{
    /**
     * The MaxFileSize
     * Meta informations extracted from the WSDL
     * - documentation: Максимальный суммарный размер принимаемых отправителем сообщения фрагментов файлов | Размер файла
     * - minOccurs: 0
     * - minInclusive: 0
     * @var int
     */
    public $MaxFileSize;
    /**
     * The HttpEnabled
     * Meta informations extracted from the WSDL
     * - documentation: Отправитель сообщения поддерживает передачу файлов по протоколу HTTP | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $HttpEnabled;
    /**
     * The SingleFileEnabled
     * Meta informations extracted from the WSDL
     * - documentation: Поддержка передачи одиночного файла вложения | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $SingleFileEnabled;
    /**
     * Constructor method for File
     * @uses File::setMaxFileSize()
     * @uses File::setHttpEnabled()
     * @uses File::setSingleFileEnabled()
     * @param int $maxFileSize
     * @param bool $httpEnabled
     * @param bool $singleFileEnabled
     */
    public function __construct($maxFileSize = null, $httpEnabled = null, $singleFileEnabled = null)
    {
        $this
            ->setMaxFileSize($maxFileSize)
            ->setHttpEnabled($httpEnabled)
            ->setSingleFileEnabled($singleFileEnabled);
    }
    /**
     * Get MaxFileSize value
     * @return int|null
     */
    public function getMaxFileSize()
    {
        return $this->MaxFileSize;
    }
    /**
     * Set MaxFileSize value
     * @param int $maxFileSize
     * @return \StructType\File
     */
    public function setMaxFileSize($maxFileSize = null)
    {
        $this->MaxFileSize = $maxFileSize;
        return $this;
    }
    /**
     * Get HttpEnabled value
     * @return bool|null
     */
    public function getHttpEnabled()
    {
        return $this->HttpEnabled;
    }
    /**
     * Set HttpEnabled value
     * @param bool $httpEnabled
     * @return \StructType\File
     */
    public function setHttpEnabled($httpEnabled = null)
    {
        $this->HttpEnabled = $httpEnabled;
        return $this;
    }
    /**
     * Get SingleFileEnabled value
     * @return bool|null
     */
    public function getSingleFileEnabled()
    {
        return $this->SingleFileEnabled;
    }
    /**
     * Set SingleFileEnabled value
     * @param bool $singleFileEnabled
     * @return \StructType\File
     */
    public function setSingleFileEnabled($singleFileEnabled = null)
    {
        $this->SingleFileEnabled = $singleFileEnabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\File
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
