<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtPayments StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ExtPayments «Оплата долга» | Содержит сведения об уплаченных на депозитный счет через системы платежей денежных средствах
 * | ЭП
 * - type: tns:ExtPayments
 * @subpackage Structs
 */
class ExtPayments extends AbstractStructBase
{
    /**
     * The ExtPayment
     * Meta informations extracted from the WSDL
     * - documentation: Платежи
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ExtPayment[]
     */
    public $ExtPayment;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор реестра оплаты, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DebtInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ реестра ФССП России | Устарело. Следует использовать поле chargeDocKey в контейнере ExtPayment | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $DebtInternalKey;
    /**
     * The IPInfoInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сведений ИП | Устарело. Следует использовать поле chargeDocKey в контейнере ExtPayment | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IPInfoInternalKey;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The ReeCreated
     * Meta informations extracted from the WSDL
     * - documentation: Дата реестра | Дата формирования реестра | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ReeCreated;
    /**
     * The PayCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество платежей | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $PayCount;
    /**
     * The ReeSum
     * Meta informations extracted from the WSDL
     * - documentation: Общая сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $ReeSum;
    /**
     * The PDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата платежного документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PDDate;
    /**
     * The PDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер платежного документа | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $PDNum;
    /**
     * The Payer
     * Meta informations extracted from the WSDL
     * - documentation: Плательщик
     * @var \StructType\PayProperties
     */
    public $Payer;
    /**
     * The Payee
     * Meta informations extracted from the WSDL
     * - documentation: Получатель
     * @var \StructType\PayProperties
     */
    public $Payee;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ExtPayments
     * @uses ExtPayments::setExtPayment()
     * @uses ExtPayments::setExternalKey()
     * @uses ExtPayments::setDebtInternalKey()
     * @uses ExtPayments::setIPInfoInternalKey()
     * @uses ExtPayments::setOspCode()
     * @uses ExtPayments::setReeCreated()
     * @uses ExtPayments::setPayCount()
     * @uses ExtPayments::setReeSum()
     * @uses ExtPayments::setPDDate()
     * @uses ExtPayments::setPDNum()
     * @uses ExtPayments::setPayer()
     * @uses ExtPayments::setPayee()
     * @uses ExtPayments::setAttachments()
     * @uses ExtPayments::setSignDateTime()
     * @uses ExtPayments::setSignature()
     * @uses ExtPayments::setId()
     * @param \StructType\ExtPayment[] $extPayment
     * @param string $externalKey
     * @param int $debtInternalKey
     * @param int $iPInfoInternalKey
     * @param string $ospCode
     * @param string $reeCreated
     * @param int $payCount
     * @param float $reeSum
     * @param string $pDDate
     * @param string $pDNum
     * @param \StructType\PayProperties $payer
     * @param \StructType\PayProperties $payee
     * @param \StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct(array $extPayment = array(), $externalKey = null, $debtInternalKey = null, $iPInfoInternalKey = null, $ospCode = null, $reeCreated = null, $payCount = null, $reeSum = null, $pDDate = null, $pDNum = null, \StructType\PayProperties $payer = null, \StructType\PayProperties $payee = null, array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExtPayment($extPayment)
            ->setExternalKey($externalKey)
            ->setDebtInternalKey($debtInternalKey)
            ->setIPInfoInternalKey($iPInfoInternalKey)
            ->setOspCode($ospCode)
            ->setReeCreated($reeCreated)
            ->setPayCount($payCount)
            ->setReeSum($reeSum)
            ->setPDDate($pDDate)
            ->setPDNum($pDNum)
            ->setPayer($payer)
            ->setPayee($payee)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExtPayment value
     * @return \StructType\ExtPayment[]
     */
    public function getExtPayment()
    {
        return $this->ExtPayment;
    }
    /**
     * Set ExtPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtPayment[] $extPayment
     * @return \StructType\ExtPayments
     */
    public function setExtPayment(array $extPayment = array())
    {
        $this->ExtPayment = $extPayment;
        return $this;
    }
    /**
     * Add item to ExtPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtPayment $item
     * @return \StructType\ExtPayments
     */
    public function addToExtPayment(\StructType\ExtPayment $item)
    {
        $this->ExtPayment[] = $item;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\ExtPayments
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DebtInternalKey value
     * @return int|null
     */
    public function getDebtInternalKey()
    {
        return $this->DebtInternalKey;
    }
    /**
     * Set DebtInternalKey value
     * @param int $debtInternalKey
     * @return \StructType\ExtPayments
     */
    public function setDebtInternalKey($debtInternalKey = null)
    {
        $this->DebtInternalKey = $debtInternalKey;
        return $this;
    }
    /**
     * Get IPInfoInternalKey value
     * @return int|null
     */
    public function getIPInfoInternalKey()
    {
        return $this->IPInfoInternalKey;
    }
    /**
     * Set IPInfoInternalKey value
     * @param int $iPInfoInternalKey
     * @return \StructType\ExtPayments
     */
    public function setIPInfoInternalKey($iPInfoInternalKey = null)
    {
        $this->IPInfoInternalKey = $iPInfoInternalKey;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \StructType\ExtPayments
     */
    public function setOspCode($ospCode = null)
    {
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get ReeCreated value
     * @return string|null
     */
    public function getReeCreated()
    {
        return $this->ReeCreated;
    }
    /**
     * Set ReeCreated value
     * @param string $reeCreated
     * @return \StructType\ExtPayments
     */
    public function setReeCreated($reeCreated = null)
    {
        $this->ReeCreated = $reeCreated;
        return $this;
    }
    /**
     * Get PayCount value
     * @return int|null
     */
    public function getPayCount()
    {
        return $this->PayCount;
    }
    /**
     * Set PayCount value
     * @param int $payCount
     * @return \StructType\ExtPayments
     */
    public function setPayCount($payCount = null)
    {
        $this->PayCount = $payCount;
        return $this;
    }
    /**
     * Get ReeSum value
     * @return float|null
     */
    public function getReeSum()
    {
        return $this->ReeSum;
    }
    /**
     * Set ReeSum value
     * @param float $reeSum
     * @return \StructType\ExtPayments
     */
    public function setReeSum($reeSum = null)
    {
        $this->ReeSum = $reeSum;
        return $this;
    }
    /**
     * Get PDDate value
     * @return string|null
     */
    public function getPDDate()
    {
        return $this->PDDate;
    }
    /**
     * Set PDDate value
     * @param string $pDDate
     * @return \StructType\ExtPayments
     */
    public function setPDDate($pDDate = null)
    {
        $this->PDDate = $pDDate;
        return $this;
    }
    /**
     * Get PDNum value
     * @return string|null
     */
    public function getPDNum()
    {
        return $this->PDNum;
    }
    /**
     * Set PDNum value
     * @param string $pDNum
     * @return \StructType\ExtPayments
     */
    public function setPDNum($pDNum = null)
    {
        $this->PDNum = $pDNum;
        return $this;
    }
    /**
     * Get Payer value
     * @return \StructType\PayProperties|null
     */
    public function getPayer()
    {
        return $this->Payer;
    }
    /**
     * Set Payer value
     * @param \StructType\PayProperties $payer
     * @return \StructType\ExtPayments
     */
    public function setPayer(\StructType\PayProperties $payer = null)
    {
        $this->Payer = $payer;
        return $this;
    }
    /**
     * Get Payee value
     * @return \StructType\PayProperties|null
     */
    public function getPayee()
    {
        return $this->Payee;
    }
    /**
     * Set Payee value
     * @param \StructType\PayProperties $payee
     * @return \StructType\ExtPayments
     */
    public function setPayee(\StructType\PayProperties $payee = null)
    {
        $this->Payee = $payee;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\ExtPayments
     */
    public function setAttachments(array $attachments = array())
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\ExtPayments
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\ExtPayments
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\ExtPayments
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\ExtPayments
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ExtPayments
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtPayments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
