<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtPayment StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер Платеж
 * - type: tns:ExtPayment
 * @subpackage Structs
 */
class ExtPayment extends AbstractStructBase
{
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Уникальный идентификатор исполнительного производства, присвоенный АИС ФССП России | Ключ объекта,
     * присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The ChargeDocKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ документа, предоставляющего сведения об ИП | Идентификатор документа, по которому произведено начисление суммы долга по
     * ИП.Может быть идентификатором реестра долга или идентификатором сведений ИП.Обязательно использование значения этого элемента, в том
     * случае, если не используются элементы DebtInternalKey или IPInfoInternalKey в документе ExtPayments | Ключ объекта, присвоенний информационной системой ФССП
     * РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $ChargeDocKey;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The IpNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IpNumber;
    /**
     * The IpRiseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждения ИП | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IpRiseDate;
    /**
     * The PayID
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор платежа | Строка длиной от 1 до 36 символов
     * - maxLength: 36
     * - minLength: 1
     * @var string
     */
    public $PayID;
    /**
     * The Terminal
     * Meta informations extracted from the WSDL
     * - documentation: Терминал | Код терминала, банкомата, окна и др., откуда поступил платеж | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Terminal;
    /**
     * The ChargeStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус платежа | Статус, отображающий изменение данных платежа, полученный от ГИС ГМП
     * - minOccurs: 0
     * @var string
     */
    public $ChargeStatus;
    /**
     * The UNIFOCode
     * Meta informations extracted from the WSDL
     * - documentation: Код начисления УНИФО | Код начисления УНИФО
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $UNIFOCode;
    /**
     * The BudgetCode
     * Meta informations extracted from the WSDL
     * - documentation: Код бюджетной классификации | Код бюджетной классификации
     * - minOccurs: 0
     * - length: 20
     * @var string
     */
    public $BudgetCode;
    /**
     * The PayDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время платежа | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $PayDateTime;
    /**
     * The PaySum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма платежа | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $PaySum;
    /**
     * The Narrative
     * Meta informations extracted from the WSDL
     * - documentation: Назначение платежа | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $Narrative;
    /**
     * The PayerIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный идентификатор плательщика | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PayerIdentifier;
    /**
     * Constructor method for ExtPayment
     * @uses ExtPayment::setIpInternalKey()
     * @uses ExtPayment::setChargeDocKey()
     * @uses ExtPayment::setOspCode()
     * @uses ExtPayment::setIpNumber()
     * @uses ExtPayment::setIpRiseDate()
     * @uses ExtPayment::setPayID()
     * @uses ExtPayment::setTerminal()
     * @uses ExtPayment::setChargeStatus()
     * @uses ExtPayment::setUNIFOCode()
     * @uses ExtPayment::setBudgetCode()
     * @uses ExtPayment::setPayDateTime()
     * @uses ExtPayment::setPaySum()
     * @uses ExtPayment::setNarrative()
     * @uses ExtPayment::setPayerIdentifier()
     * @param int $ipInternalKey
     * @param int $chargeDocKey
     * @param string $ospCode
     * @param string $ipNumber
     * @param string $ipRiseDate
     * @param string $payID
     * @param string $terminal
     * @param string $chargeStatus
     * @param string $uNIFOCode
     * @param string $budgetCode
     * @param string $payDateTime
     * @param float $paySum
     * @param string $narrative
     * @param string $payerIdentifier
     */
    public function __construct($ipInternalKey = null, $chargeDocKey = null, $ospCode = null, $ipNumber = null, $ipRiseDate = null, $payID = null, $terminal = null, $chargeStatus = null, $uNIFOCode = null, $budgetCode = null, $payDateTime = null, $paySum = null, $narrative = null, $payerIdentifier = null)
    {
        $this
            ->setIpInternalKey($ipInternalKey)
            ->setChargeDocKey($chargeDocKey)
            ->setOspCode($ospCode)
            ->setIpNumber($ipNumber)
            ->setIpRiseDate($ipRiseDate)
            ->setPayID($payID)
            ->setTerminal($terminal)
            ->setChargeStatus($chargeStatus)
            ->setUNIFOCode($uNIFOCode)
            ->setBudgetCode($budgetCode)
            ->setPayDateTime($payDateTime)
            ->setPaySum($paySum)
            ->setNarrative($narrative)
            ->setPayerIdentifier($payerIdentifier);
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \StructType\ExtPayment
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get ChargeDocKey value
     * @return int|null
     */
    public function getChargeDocKey()
    {
        return $this->ChargeDocKey;
    }
    /**
     * Set ChargeDocKey value
     * @param int $chargeDocKey
     * @return \StructType\ExtPayment
     */
    public function setChargeDocKey($chargeDocKey = null)
    {
        $this->ChargeDocKey = $chargeDocKey;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \StructType\ExtPayment
     */
    public function setOspCode($ospCode = null)
    {
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get IpNumber value
     * @return string|null
     */
    public function getIpNumber()
    {
        return $this->IpNumber;
    }
    /**
     * Set IpNumber value
     * @param string $ipNumber
     * @return \StructType\ExtPayment
     */
    public function setIpNumber($ipNumber = null)
    {
        $this->IpNumber = $ipNumber;
        return $this;
    }
    /**
     * Get IpRiseDate value
     * @return string|null
     */
    public function getIpRiseDate()
    {
        return $this->IpRiseDate;
    }
    /**
     * Set IpRiseDate value
     * @param string $ipRiseDate
     * @return \StructType\ExtPayment
     */
    public function setIpRiseDate($ipRiseDate = null)
    {
        $this->IpRiseDate = $ipRiseDate;
        return $this;
    }
    /**
     * Get PayID value
     * @return string|null
     */
    public function getPayID()
    {
        return $this->PayID;
    }
    /**
     * Set PayID value
     * @param string $payID
     * @return \StructType\ExtPayment
     */
    public function setPayID($payID = null)
    {
        $this->PayID = $payID;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \StructType\ExtPayment
     */
    public function setTerminal($terminal = null)
    {
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Get ChargeStatus value
     * @return string|null
     */
    public function getChargeStatus()
    {
        return $this->ChargeStatus;
    }
    /**
     * Set ChargeStatus value
     * @uses \EnumType\ChargeStatusType::valueIsValid()
     * @uses \EnumType\ChargeStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chargeStatus
     * @return \StructType\ExtPayment
     */
    public function setChargeStatus($chargeStatus = null)
    {
        $this->ChargeStatus = $chargeStatus;
        return $this;
    }
    /**
     * Get UNIFOCode value
     * @return string|null
     */
    public function getUNIFOCode()
    {
        return $this->UNIFOCode;
    }
    /**
     * Set UNIFOCode value
     * @param string $uNIFOCode
     * @return \StructType\ExtPayment
     */
    public function setUNIFOCode($uNIFOCode = null)
    {
        $this->UNIFOCode = $uNIFOCode;
        return $this;
    }
    /**
     * Get BudgetCode value
     * @return string|null
     */
    public function getBudgetCode()
    {
        return $this->BudgetCode;
    }
    /**
     * Set BudgetCode value
     * @param string $budgetCode
     * @return \StructType\ExtPayment
     */
    public function setBudgetCode($budgetCode = null)
    {
        $this->BudgetCode = $budgetCode;
        return $this;
    }
    /**
     * Get PayDateTime value
     * @return string|null
     */
    public function getPayDateTime()
    {
        return $this->PayDateTime;
    }
    /**
     * Set PayDateTime value
     * @param string $payDateTime
     * @return \StructType\ExtPayment
     */
    public function setPayDateTime($payDateTime = null)
    {
        $this->PayDateTime = $payDateTime;
        return $this;
    }
    /**
     * Get PaySum value
     * @return float|null
     */
    public function getPaySum()
    {
        return $this->PaySum;
    }
    /**
     * Set PaySum value
     * @param float $paySum
     * @return \StructType\ExtPayment
     */
    public function setPaySum($paySum = null)
    {
        $this->PaySum = $paySum;
        return $this;
    }
    /**
     * Get Narrative value
     * @return string|null
     */
    public function getNarrative()
    {
        return $this->Narrative;
    }
    /**
     * Set Narrative value
     * @param string $narrative
     * @return \StructType\ExtPayment
     */
    public function setNarrative($narrative = null)
    {
        $this->Narrative = $narrative;
        return $this;
    }
    /**
     * Get PayerIdentifier value
     * @return string|null
     */
    public function getPayerIdentifier()
    {
        return $this->PayerIdentifier;
    }
    /**
     * Set PayerIdentifier value
     * @param string $payerIdentifier
     * @return \StructType\ExtPayment
     */
    public function setPayerIdentifier($payerIdentifier = null)
    {
        $this->PayerIdentifier = $payerIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
