<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtDoc StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ExtDoc «Исполнительный документ» | ЭП
 * - type: tns:ExtDoc
 * @subpackage Structs
 */
class ExtDoc extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Указывается идентификатор исполнительного документа, присвоенный АИС внешнего контрагента. Уникален в
     * рамках типа документа и конкретного внешнего контрагента. Для ФНС номер исполнительного документа системный (уникальный в пределах
     * данного типа документа) составной в формате СНД, где С- код налоговой по классификатору СОНО, Н – номер постановления - 20 цифровых
     * позиций, Д – дата в формате ДД.ММ.ГГГГ | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Указывается исходящая дата исполнительного документа (Дата постановления) | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The BarCode
     * Meta informations extracted from the WSDL
     * - documentation: Штрих код | Указывается штрих-код органа, выдавшего ИД | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $BarCode;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Код вида ИД | Указывается код типа ИД. Поле обязательное для заполнения. Заполняется из справочника «Типы ИД». Справочник
     * заполняется в соответствие с ч. 1 ст. 12 ФЗ-229
     * @var string
     */
    public $IDType;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИД | Указывается номер ИД. Поле обязательное для заполнения. Указывается номер исполнительного документа, присвоенный в
     * органе, выдавшем ИД. В случае отсутствия нумерации ИД указывается значение "б/н" | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи ИД | Указывается дата выдачи ИД. Поле обязательное для заполнения в соответствие со статьей 13 ФЗ-229 | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The IDCopy
     * Meta informations extracted from the WSDL
     * - documentation: Экземпляр ИД | Указывается номер экземпляра ИД. Поле обязательное для заполнения для ИД, выданных на основании решения или
     * приговора суда о взыскании денежных сумм с солидарных ответчиков ст. 429 ГПК РФ | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $IDCopy;
    /**
     * The DeloNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер дела или материалов | Указывается номер дела или материалов, на основании которых выдан ИД. Поле обязательное для
     * заполнения в соответствие со статьей 13 ФЗ-229. В случае отсутствия нумерации указывается значение "б/н". Для ПФР: Номер в соответствии с
     * Требованием об уплате недоимки по страховым взносам, пеней и штрафов (форма № 5-ПФР, утвержденная Приказом МЗСР РФ от 07.12.2009 № 957н) | Строка
     * длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $DeloNum;
    /**
     * The DeloDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата принятия решения по делу | Указывается дата принятия судебного акта, акта другого органа или должностного лица. Поле
     * обязательное для заполнения в соответствие со ст. 13 ФЗ-229. Для ПФР: Дата в соответствии с Требованием об уплате недоимки по страховым
     * взносам, пеней и штрафов (форма № 5-ПФР, утвержденная Приказом МЗСР РФ от 07.12.2009 № 957н) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DeloDate;
    /**
     * The OrganCode
     * Meta informations extracted from the WSDL
     * - documentation: Код органа, выдавшего ИД | Указывается код органа по ведомственному справочнику ФССП России. Для ФНС: По справочнику СОНО. Для
     * ПФР: По справочнику ТО ПФР. | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $OrganCode;
    /**
     * The Organ
     * Meta informations extracted from the WSDL
     * - documentation: Орган, выдавший ИД | Указывается наименование суда или подразделения уполномоченного органа, выдавшего ИД. Поле обязательное
     * для заполнения в соответствие со статьей 13 ФЗ-229. Для ФНС России орган, выдавший ИД заполняется в соответствии с наименованием по
     * справочнику СОНО | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Organ;
    /**
     * The OrganAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес органа, выдавшего ИД | Указывается адрес, суда или подразделения уполномоченного органа, выдавшего ИД. Поле обязательное
     * для заполнения в соответствие со статьей 13 ФЗ-229. Адрес органа, выдавшего ИД в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых
     * по КЛАДР» или (в случае отсутствия кода страны) в произвольном формате. | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $OrganAdr;
    /**
     * The OrganSignPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность лица вынесшего ИД | Указывается наименование должности лица, вынесшего ИД, по Общероссийскому классификатору
     * профессий рабочих, должностей служащих и тарифных разрядов. Поле обязательное для заполнения. Для ПФР: Руководителя либо заместителя
     * руководителя ТО ПФР | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $OrganSignPost;
    /**
     * The OrganSignFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица вынесшего ИД | Указывается ФИО должностного лица, выдавшего ИД. Поле обязательное для заполнения в
     * соответствие со статьей 13 ФЗ-229. Для ПФР: Руководителя либо заместителя руководителя ТО ПФР | Полное имя физического лица (фамилия, имя,
     * отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OrganSignFIO;
    /**
     * The AktDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата вступления решения в законную силу | Указывается дата вступления в законную силу судебного акта, акта другого органа или
     * должностного лица. Поле обязательное для заполнения в соответствие со ст.13 ФЗ-229 | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AktDate;
    /**
     * The DebtorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должника | Указывается тип должника по справочнику типов должников/взыскателей ФССП России
     * @var string
     */
    public $DebtorType;
    /**
     * The DebtorName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование должника | Указывается наименование или ФИО должника. Поле обязательное для заполнения в соответствие со статьей
     * 13 ФЗ-229 | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DebtorName;
    /**
     * The DebtorFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должника | Указывается ФИО должника в виде сложного элемента. Поле обязательное для заполнения в соответствие со статьей 13
     * ФЗ-229
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $DebtorFIO;
    /**
     * The DebtorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника | Указывается адрес должника (места жительства или пребывания). Поле обязательное для заполнения в соответствие
     * со статьей 13 ФЗ-229. Адрес должника в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых по КЛАДР» или (в случае отсутствия кода
     * страны) в произвольном формате | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorAdr;
    /**
     * The DebtorWorkPl
     * Meta informations extracted from the WSDL
     * - documentation: Место работы | Указывается место работы должника если оно известно | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DebtorWorkPl;
    /**
     * The DebtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Указывается дата рождения должника за исключением постановления судебного пристава-исполнителя, судебного
     * приказа, исполнительной надписи нотариуса и нотариально удостоверенного соглашения об уплате алиментов. Поле является
     * условно-обязательным для заполнения, если значение поля «Тип должника» входит в группу «Физические лица» | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorBirthDate;
    /**
     * The DebtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения ФЛ | Указывается год рождения должника. Поле обязательное для заполнения в соответствие со статьей 13 ФЗ-229, если
     * значение поля «Тип должника» входит в группу «Физические лица» | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $DebtorBirthYear;
    /**
     * The DebtorBirthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения | Указывается место рождения должника. Поле обязательное для заполнения в соответствие со статьей 13 ФЗ-229, если
     * значение поля «Тип должника» входит в группу «Физические лица» или равно «Индивидуальный предприниматель» Поле не подлежит
     * обязательному заполнению в судебном приказе (за исключением судебного приказа о взыскании алиментов), исполнительной надписи
     * нотариуса и нотариально удостоверенном соглашении об уплате алиментов. | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorBirthPlace;
    /**
     * The DebtorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН должника | Указывается ИНН должника. Поле обязательное для заполнения в соответствие со ст.13 ФЗ-229, если значение поля «Тип
     * должника» входит в группу «Юридические лица» или равно «ИП» | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $DebtorINN;
    /**
     * The DebtorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП | Указывается КПП должника. Поле заполняется, если значение поля «Тип должника» входит в группу «Юридические лица». | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $DebtorKPP;
    /**
     * The DebtorRegDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации должника ЮЛ | Указывается дата регистрации должника. Поле обязательное для заполнения в соответствие со ст.13
     * ФЗ-229, если значение поля «Тип должника» входит в группу «Юридические лица» или равно «ИП» | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorRegDate;
    /**
     * The DebtorOGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН/ОГРНИП | Указывается ОГРН/ОГРНИП должника. Поле заполняется, если значение поля «Тип должника» входит в группу
     * «Юридические лица». Может заполняться ОГРН/ОГРНИП ЮЛ/ИП. | Основной государственный регистрационный номер (ОГРН)/Основной
     * государственный регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $DebtorOGRN;
    /**
     * The ClaimerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип взыскателя | Указывается тип взыскателя по справочнику типов должников/взыскателей ФССП России
     * @var string
     */
    public $ClaimerType;
    /**
     * The ClaimerName
     * Meta informations extracted from the WSDL
     * - documentation: Взыскатель | Указывается наименование или ФИО взыскателя. Поле обязательное для заполнения в соответствие со статьей 13 ФЗ-229 |
     * Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ClaimerName;
    /**
     * The ClaimerAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес взыскателя | Указывается адрес взыскателя. Поле обязательное для заполнения в соответствие со статьей 13 ФЗ-229. Адрес
     * взыскателя в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых по КЛАДР» или (в случае отсутствия кода страны) в произвольном
     * формате | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $ClaimerAdr;
    /**
     * The IDSubj
     * Meta informations extracted from the WSDL
     * - documentation: Тип предмета | Указывается наименование типа предмета исполнения по справочнику «Типы предметов исполнения» в соответствии
     * со справочником НСИ ФССП России. Поле обязательное для исполнения | Код предмета исполнения | NSI_IDoc_Subj_Exec
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $IDSubj;
    /**
     * The IDSubjName
     * Meta informations extracted from the WSDL
     * - documentation: Предмет | Указывается краткая резолютивная часть судебного акта, акта другого органа или должностного лица, на основании
     * которого выдан ИД. Поле обязательное для заполнения в соответствие со ст.13 ФЗ-229. Пример формулировки ТО ПФР: «Произвести взыскание
     * страховых взносов, пеней и штрафов за счет имущества». Пример формулировки ГИБДД: Назначить собственнику (владельцу) транспортного
     * средства административное наказание в виде административного штрафа в размере 1000 рублей | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDSubjName;
    /**
     * The IDSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма долга или начисления долга | Указывается общая сумма требований, подлежащих взысканию по ИД. Поле необязательное для
     * заполнения. Для ПФР: Расчетный показатель. Равен общей сумме задолженности по всем контейнерам «Реквизиты для перечисления» по одному
     * Постановлению (в руб.) | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IDSum;
    /**
     * The DebtorEstate
     * Meta informations extracted from the WSDL
     * - documentation: Установочная часть решения | Указывается установочная часть решения, на основании которого был выдан ИД. Поле обязательное для
     * заполнения по ИД, выданных на основании судебного акта, а также для протоколов об административных правонарушениях | Массив
     * произвольных данных (бинарный)
     * - minOccurs: 0
     * @var string
     */
    public $DebtorEstate;
    /**
     * The Period
     * Meta informations extracted from the WSDL
     * - documentation: Периодически | Указывается тип периодического начисления задолженности по ИД по справочнику «Типы периодического
     * начисления». Поле обязательное для заполнения, если значение поля «Сущность исполнения» содержит значение «Алименты» или
     * «Периодические платежи» | Тип периодического начисления долга | NSI_IDoc_Periodic
     * - minOccurs: 0
     * - length: 1
     * @var string
     */
    public $Period;
    /**
     * The PeriodSum
     * Meta informations extracted from the WSDL
     * - documentation: Периодический долг | Указывается сумма или доля начисления задолженности по ИД. Поле обязательное для заполнения, если
     * значение поля «Сущность исполнения» содержит значение «Алименты» или «Периодические платежи» | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $PeriodSum;
    /**
     * The Repeat
     * Meta informations extracted from the WSDL
     * - documentation: Признак повторности | Указывается поступил документ первично или повторно | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $Repeat;
    /**
     * The DebtorNo
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер должника | Указывается регистрационный номер должника, присвоенный органом, выдавшим ИД. Для ПФР:
     * Обязателен | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $DebtorNo;
    /**
     * The SrokDobrPFR
     * Meta informations extracted from the WSDL
     * - documentation: Срок добровольного исполнения требования | Указывается срок для добровольного исполнения ИД. Поле обязательное для
     * заполнения. Заполняется в соответствие со ст. 30 ФЗ-229. В соответствии с Требованием об уплате недоимки по страховым взносам, пеней и
     * штрафов (форма № 5-ПФР, утвержденная Приказом МЗСР РФ от 07.12.2009 № 957н) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $SrokDobrPFR;
    /**
     * The KoAPArticle
     * Meta informations extracted from the WSDL
     * - documentation: Статья КоАП | Указывается статья КОАП или закона субъекта РФ, предусматривающая административную ответственность за
     * совершение административного правонарушения. Поле обязательное для заполнения, если значение поля входит в группу "Штрафы по КОАП" в
     * соответствие со ч.1 ст.29.10 КОАП РФ | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $KoAPArticle;
    /**
     * The KoAPPart
     * Meta informations extracted from the WSDL
     * - documentation: Часть КоАП | Указывается часть статьи КОАП или закона субъекта РФ | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $KoAPPart;
    /**
     * The KoAPPoint
     * Meta informations extracted from the WSDL
     * - documentation: Пункт статьи КоАП | Указывается пункт статьи КОАП или закона субъекта РФ | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $KoAPPoint;
    /**
     * The NoAccount
     * Meta informations extracted from the WSDL
     * - documentation: Признак отсутствия счетов | Указывается факт отсутствия счетов у должника. Поле заполняется, если значение поля «Код типа ИД»
     * равно «5» (Акт органа, осуществляющего контрольные функции) Признак отсутствия информации о счетах должника в ТО ПФР. В случае наличия
     * счетов у плательщика (true), Постановление, направляемое ТО ПФР, сопровождается файлом скана (образа) Справки об отсутствии средств на
     * счетах должника, представляемой банком | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $NoAccount;
    /**
     * The IsDuplicate
     * Meta informations extracted from the WSDL
     * - documentation: Дубликат | Указывается является ли ИД дубликатом. Поле заполняется, если ИД является дубликатом, выданным при утрате
     * подлинника. Если ИД является подлинником, то поле не заполняется (часть 2 ст. 12 ФЗ-229) | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $IsDuplicate;
    /**
     * The IDBase
     * Meta informations extracted from the WSDL
     * - documentation: Исполнительный документ | Оригинал исполнительного документа, вынесенного в соответствии с Постановлением Правительства РФ
     * от 20.10.2015 N 1121 "Об утверждении требований к форматам исполнительных документов, вынесенных и (или) направляемых для исполнения в форме
     * электронного документа" в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $IDBase;
    /**
     * The SignatureBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП исполнительного документа | ЭП исполнительного документа вынесенного в электронном виде, элемента «IDBase» в формате pkcs#7
     * - minOccurs: 0
     * @var string
     */
    public $SignatureBase;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Уточняющие данные исполнительного документа
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The PaymentProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты для перечисления | Реквизиты для перечисления взысканных сумм взыскателю (для налоговых платежей может быть указано
     * больше одного набора реквизитов)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentProperties[]
     */
    public $PaymentProperties;
    /**
     * The Sequestration
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об аресте имущества и имеющихся ограничениях | Используется для передачи сведений об аресте имущества и имеющихся
     * ограничениях (постановлении о наложении ареста на имущество должника). Для ФНС России при вынесении постановления по статье 77 НК РФ:
     * Обязателен.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SequestrationType[]
     */
    public $Sequestration;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ExtDoc
     * @uses ExtDoc::setExternalKey()
     * @uses ExtDoc::setDocDate()
     * @uses ExtDoc::setBarCode()
     * @uses ExtDoc::setIDType()
     * @uses ExtDoc::setIDNum()
     * @uses ExtDoc::setIDDate()
     * @uses ExtDoc::setIDCopy()
     * @uses ExtDoc::setDeloNum()
     * @uses ExtDoc::setDeloDate()
     * @uses ExtDoc::setOrganCode()
     * @uses ExtDoc::setOrgan()
     * @uses ExtDoc::setOrganAdr()
     * @uses ExtDoc::setOrganSignPost()
     * @uses ExtDoc::setOrganSignFIO()
     * @uses ExtDoc::setAktDate()
     * @uses ExtDoc::setDebtorType()
     * @uses ExtDoc::setDebtorName()
     * @uses ExtDoc::setDebtorFIO()
     * @uses ExtDoc::setDebtorAdr()
     * @uses ExtDoc::setDebtorWorkPl()
     * @uses ExtDoc::setDebtorBirthDate()
     * @uses ExtDoc::setDebtorBirthYear()
     * @uses ExtDoc::setDebtorBirthPlace()
     * @uses ExtDoc::setDebtorINN()
     * @uses ExtDoc::setDebtorKPP()
     * @uses ExtDoc::setDebtorRegDate()
     * @uses ExtDoc::setDebtorOGRN()
     * @uses ExtDoc::setClaimerType()
     * @uses ExtDoc::setClaimerName()
     * @uses ExtDoc::setClaimerAdr()
     * @uses ExtDoc::setIDSubj()
     * @uses ExtDoc::setIDSubjName()
     * @uses ExtDoc::setIDSum()
     * @uses ExtDoc::setDebtorEstate()
     * @uses ExtDoc::setPeriod()
     * @uses ExtDoc::setPeriodSum()
     * @uses ExtDoc::setRepeat()
     * @uses ExtDoc::setDebtorNo()
     * @uses ExtDoc::setSrokDobrPFR()
     * @uses ExtDoc::setKoAPArticle()
     * @uses ExtDoc::setKoAPPart()
     * @uses ExtDoc::setKoAPPoint()
     * @uses ExtDoc::setNoAccount()
     * @uses ExtDoc::setIsDuplicate()
     * @uses ExtDoc::setIDBase()
     * @uses ExtDoc::setSignatureBase()
     * @uses ExtDoc::setData()
     * @uses ExtDoc::setPaymentProperties()
     * @uses ExtDoc::setSequestration()
     * @uses ExtDoc::setAttachments()
     * @uses ExtDoc::setSignDateTime()
     * @uses ExtDoc::setSignature()
     * @uses ExtDoc::setId()
     * @param string $externalKey
     * @param string $docDate
     * @param string $barCode
     * @param string $iDType
     * @param string $iDNum
     * @param string $iDDate
     * @param int $iDCopy
     * @param string $deloNum
     * @param string $deloDate
     * @param string $organCode
     * @param string $organ
     * @param string $organAdr
     * @param string $organSignPost
     * @param string $organSignFIO
     * @param string $aktDate
     * @param string $debtorType
     * @param string $debtorName
     * @param \StructType\FioType $debtorFIO
     * @param string $debtorAdr
     * @param string $debtorWorkPl
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorBirthPlace
     * @param string $debtorINN
     * @param string $debtorKPP
     * @param string $debtorRegDate
     * @param string $debtorOGRN
     * @param string $claimerType
     * @param string $claimerName
     * @param string $claimerAdr
     * @param string $iDSubj
     * @param string $iDSubjName
     * @param float $iDSum
     * @param string $debtorEstate
     * @param string $period
     * @param string $periodSum
     * @param bool $repeat
     * @param string $debtorNo
     * @param string $srokDobrPFR
     * @param string $koAPArticle
     * @param string $koAPPart
     * @param string $koAPPoint
     * @param bool $noAccount
     * @param bool $isDuplicate
     * @param string $iDBase
     * @param string $signatureBase
     * @param \StructType\Data[] $data
     * @param \StructType\PaymentProperties[] $paymentProperties
     * @param \StructType\SequestrationType[] $sequestration
     * @param \StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $docDate = null, $barCode = null, $iDType = null, $iDNum = null, $iDDate = null, $iDCopy = null, $deloNum = null, $deloDate = null, $organCode = null, $organ = null, $organAdr = null, $organSignPost = null, $organSignFIO = null, $aktDate = null, $debtorType = null, $debtorName = null, \StructType\FioType $debtorFIO = null, $debtorAdr = null, $debtorWorkPl = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorBirthPlace = null, $debtorINN = null, $debtorKPP = null, $debtorRegDate = null, $debtorOGRN = null, $claimerType = null, $claimerName = null, $claimerAdr = null, $iDSubj = null, $iDSubjName = null, $iDSum = null, $debtorEstate = null, $period = null, $periodSum = null, $repeat = null, $debtorNo = null, $srokDobrPFR = null, $koAPArticle = null, $koAPPart = null, $koAPPoint = null, $noAccount = null, $isDuplicate = null, $iDBase = null, $signatureBase = null, array $data = array(), array $paymentProperties = array(), array $sequestration = array(), array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setDocDate($docDate)
            ->setBarCode($barCode)
            ->setIDType($iDType)
            ->setIDNum($iDNum)
            ->setIDDate($iDDate)
            ->setIDCopy($iDCopy)
            ->setDeloNum($deloNum)
            ->setDeloDate($deloDate)
            ->setOrganCode($organCode)
            ->setOrgan($organ)
            ->setOrganAdr($organAdr)
            ->setOrganSignPost($organSignPost)
            ->setOrganSignFIO($organSignFIO)
            ->setAktDate($aktDate)
            ->setDebtorType($debtorType)
            ->setDebtorName($debtorName)
            ->setDebtorFIO($debtorFIO)
            ->setDebtorAdr($debtorAdr)
            ->setDebtorWorkPl($debtorWorkPl)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorBirthPlace($debtorBirthPlace)
            ->setDebtorINN($debtorINN)
            ->setDebtorKPP($debtorKPP)
            ->setDebtorRegDate($debtorRegDate)
            ->setDebtorOGRN($debtorOGRN)
            ->setClaimerType($claimerType)
            ->setClaimerName($claimerName)
            ->setClaimerAdr($claimerAdr)
            ->setIDSubj($iDSubj)
            ->setIDSubjName($iDSubjName)
            ->setIDSum($iDSum)
            ->setDebtorEstate($debtorEstate)
            ->setPeriod($period)
            ->setPeriodSum($periodSum)
            ->setRepeat($repeat)
            ->setDebtorNo($debtorNo)
            ->setSrokDobrPFR($srokDobrPFR)
            ->setKoAPArticle($koAPArticle)
            ->setKoAPPart($koAPPart)
            ->setKoAPPoint($koAPPoint)
            ->setNoAccount($noAccount)
            ->setIsDuplicate($isDuplicate)
            ->setIDBase($iDBase)
            ->setSignatureBase($signatureBase)
            ->setData($data)
            ->setPaymentProperties($paymentProperties)
            ->setSequestration($sequestration)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\ExtDoc
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\ExtDoc
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get BarCode value
     * @return string|null
     */
    public function getBarCode()
    {
        return $this->BarCode;
    }
    /**
     * Set BarCode value
     * @param string $barCode
     * @return \StructType\ExtDoc
     */
    public function setBarCode($barCode = null)
    {
        $this->BarCode = $barCode;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \EnumType\IdType::valueIsValid()
     * @uses \EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \StructType\ExtDoc
     */
    public function setIDType($iDType = null)
    {
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string|null
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \StructType\ExtDoc
     */
    public function setIDNum($iDNum = null)
    {
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \StructType\ExtDoc
     */
    public function setIDDate($iDDate = null)
    {
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get IDCopy value
     * @return int|null
     */
    public function getIDCopy()
    {
        return $this->IDCopy;
    }
    /**
     * Set IDCopy value
     * @param int $iDCopy
     * @return \StructType\ExtDoc
     */
    public function setIDCopy($iDCopy = null)
    {
        $this->IDCopy = $iDCopy;
        return $this;
    }
    /**
     * Get DeloNum value
     * @return string|null
     */
    public function getDeloNum()
    {
        return $this->DeloNum;
    }
    /**
     * Set DeloNum value
     * @param string $deloNum
     * @return \StructType\ExtDoc
     */
    public function setDeloNum($deloNum = null)
    {
        $this->DeloNum = $deloNum;
        return $this;
    }
    /**
     * Get DeloDate value
     * @return string|null
     */
    public function getDeloDate()
    {
        return $this->DeloDate;
    }
    /**
     * Set DeloDate value
     * @param string $deloDate
     * @return \StructType\ExtDoc
     */
    public function setDeloDate($deloDate = null)
    {
        $this->DeloDate = $deloDate;
        return $this;
    }
    /**
     * Get OrganCode value
     * @return string|null
     */
    public function getOrganCode()
    {
        return $this->OrganCode;
    }
    /**
     * Set OrganCode value
     * @param string $organCode
     * @return \StructType\ExtDoc
     */
    public function setOrganCode($organCode = null)
    {
        $this->OrganCode = $organCode;
        return $this;
    }
    /**
     * Get Organ value
     * @return string|null
     */
    public function getOrgan()
    {
        return $this->Organ;
    }
    /**
     * Set Organ value
     * @param string $organ
     * @return \StructType\ExtDoc
     */
    public function setOrgan($organ = null)
    {
        $this->Organ = $organ;
        return $this;
    }
    /**
     * Get OrganAdr value
     * @return string|null
     */
    public function getOrganAdr()
    {
        return $this->OrganAdr;
    }
    /**
     * Set OrganAdr value
     * @param string $organAdr
     * @return \StructType\ExtDoc
     */
    public function setOrganAdr($organAdr = null)
    {
        $this->OrganAdr = $organAdr;
        return $this;
    }
    /**
     * Get OrganSignPost value
     * @return string|null
     */
    public function getOrganSignPost()
    {
        return $this->OrganSignPost;
    }
    /**
     * Set OrganSignPost value
     * @param string $organSignPost
     * @return \StructType\ExtDoc
     */
    public function setOrganSignPost($organSignPost = null)
    {
        $this->OrganSignPost = $organSignPost;
        return $this;
    }
    /**
     * Get OrganSignFIO value
     * @return string|null
     */
    public function getOrganSignFIO()
    {
        return $this->OrganSignFIO;
    }
    /**
     * Set OrganSignFIO value
     * @param string $organSignFIO
     * @return \StructType\ExtDoc
     */
    public function setOrganSignFIO($organSignFIO = null)
    {
        $this->OrganSignFIO = $organSignFIO;
        return $this;
    }
    /**
     * Get AktDate value
     * @return string|null
     */
    public function getAktDate()
    {
        return $this->AktDate;
    }
    /**
     * Set AktDate value
     * @param string $aktDate
     * @return \StructType\ExtDoc
     */
    public function setAktDate($aktDate = null)
    {
        $this->AktDate = $aktDate;
        return $this;
    }
    /**
     * Get DebtorType value
     * @return string|null
     */
    public function getDebtorType()
    {
        return $this->DebtorType;
    }
    /**
     * Set DebtorType value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorType
     * @return \StructType\ExtDoc
     */
    public function setDebtorType($debtorType = null)
    {
        $this->DebtorType = $debtorType;
        return $this;
    }
    /**
     * Get DebtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->DebtorName;
    }
    /**
     * Set DebtorName value
     * @param string $debtorName
     * @return \StructType\ExtDoc
     */
    public function setDebtorName($debtorName = null)
    {
        $this->DebtorName = $debtorName;
        return $this;
    }
    /**
     * Get DebtorFIO value
     * @return \StructType\FioType|null
     */
    public function getDebtorFIO()
    {
        return $this->DebtorFIO;
    }
    /**
     * Set DebtorFIO value
     * @param \StructType\FioType $debtorFIO
     * @return \StructType\ExtDoc
     */
    public function setDebtorFIO(\StructType\FioType $debtorFIO = null)
    {
        $this->DebtorFIO = $debtorFIO;
        return $this;
    }
    /**
     * Get DebtorAdr value
     * @return string|null
     */
    public function getDebtorAdr()
    {
        return $this->DebtorAdr;
    }
    /**
     * Set DebtorAdr value
     * @param string $debtorAdr
     * @return \StructType\ExtDoc
     */
    public function setDebtorAdr($debtorAdr = null)
    {
        $this->DebtorAdr = $debtorAdr;
        return $this;
    }
    /**
     * Get DebtorWorkPl value
     * @return string|null
     */
    public function getDebtorWorkPl()
    {
        return $this->DebtorWorkPl;
    }
    /**
     * Set DebtorWorkPl value
     * @param string $debtorWorkPl
     * @return \StructType\ExtDoc
     */
    public function setDebtorWorkPl($debtorWorkPl = null)
    {
        $this->DebtorWorkPl = $debtorWorkPl;
        return $this;
    }
    /**
     * Get DebtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->DebtorBirthDate;
    }
    /**
     * Set DebtorBirthDate value
     * @param string $debtorBirthDate
     * @return \StructType\ExtDoc
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        $this->DebtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get DebtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->DebtorBirthYear;
    }
    /**
     * Set DebtorBirthYear value
     * @param string $debtorBirthYear
     * @return \StructType\ExtDoc
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        $this->DebtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get DebtorBirthPlace value
     * @return string|null
     */
    public function getDebtorBirthPlace()
    {
        return $this->DebtorBirthPlace;
    }
    /**
     * Set DebtorBirthPlace value
     * @param string $debtorBirthPlace
     * @return \StructType\ExtDoc
     */
    public function setDebtorBirthPlace($debtorBirthPlace = null)
    {
        $this->DebtorBirthPlace = $debtorBirthPlace;
        return $this;
    }
    /**
     * Get DebtorINN value
     * @return string|null
     */
    public function getDebtorINN()
    {
        return $this->DebtorINN;
    }
    /**
     * Set DebtorINN value
     * @param string $debtorINN
     * @return \StructType\ExtDoc
     */
    public function setDebtorINN($debtorINN = null)
    {
        $this->DebtorINN = $debtorINN;
        return $this;
    }
    /**
     * Get DebtorKPP value
     * @return string|null
     */
    public function getDebtorKPP()
    {
        return $this->DebtorKPP;
    }
    /**
     * Set DebtorKPP value
     * @param string $debtorKPP
     * @return \StructType\ExtDoc
     */
    public function setDebtorKPP($debtorKPP = null)
    {
        $this->DebtorKPP = $debtorKPP;
        return $this;
    }
    /**
     * Get DebtorRegDate value
     * @return string|null
     */
    public function getDebtorRegDate()
    {
        return $this->DebtorRegDate;
    }
    /**
     * Set DebtorRegDate value
     * @param string $debtorRegDate
     * @return \StructType\ExtDoc
     */
    public function setDebtorRegDate($debtorRegDate = null)
    {
        $this->DebtorRegDate = $debtorRegDate;
        return $this;
    }
    /**
     * Get DebtorOGRN value
     * @return string|null
     */
    public function getDebtorOGRN()
    {
        return $this->DebtorOGRN;
    }
    /**
     * Set DebtorOGRN value
     * @param string $debtorOGRN
     * @return \StructType\ExtDoc
     */
    public function setDebtorOGRN($debtorOGRN = null)
    {
        $this->DebtorOGRN = $debtorOGRN;
        return $this;
    }
    /**
     * Get ClaimerType value
     * @return string|null
     */
    public function getClaimerType()
    {
        return $this->ClaimerType;
    }
    /**
     * Set ClaimerType value
     * @uses \EnumType\ContragentType::valueIsValid()
     * @uses \EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claimerType
     * @return \StructType\ExtDoc
     */
    public function setClaimerType($claimerType = null)
    {
        $this->ClaimerType = $claimerType;
        return $this;
    }
    /**
     * Get ClaimerName value
     * @return string|null
     */
    public function getClaimerName()
    {
        return $this->ClaimerName;
    }
    /**
     * Set ClaimerName value
     * @param string $claimerName
     * @return \StructType\ExtDoc
     */
    public function setClaimerName($claimerName = null)
    {
        $this->ClaimerName = $claimerName;
        return $this;
    }
    /**
     * Get ClaimerAdr value
     * @return string|null
     */
    public function getClaimerAdr()
    {
        return $this->ClaimerAdr;
    }
    /**
     * Set ClaimerAdr value
     * @param string $claimerAdr
     * @return \StructType\ExtDoc
     */
    public function setClaimerAdr($claimerAdr = null)
    {
        $this->ClaimerAdr = $claimerAdr;
        return $this;
    }
    /**
     * Get IDSubj value
     * @return string|null
     */
    public function getIDSubj()
    {
        return $this->IDSubj;
    }
    /**
     * Set IDSubj value
     * @param string $iDSubj
     * @return \StructType\ExtDoc
     */
    public function setIDSubj($iDSubj = null)
    {
        $this->IDSubj = $iDSubj;
        return $this;
    }
    /**
     * Get IDSubjName value
     * @return string|null
     */
    public function getIDSubjName()
    {
        return $this->IDSubjName;
    }
    /**
     * Set IDSubjName value
     * @param string $iDSubjName
     * @return \StructType\ExtDoc
     */
    public function setIDSubjName($iDSubjName = null)
    {
        $this->IDSubjName = $iDSubjName;
        return $this;
    }
    /**
     * Get IDSum value
     * @return float|null
     */
    public function getIDSum()
    {
        return $this->IDSum;
    }
    /**
     * Set IDSum value
     * @param float $iDSum
     * @return \StructType\ExtDoc
     */
    public function setIDSum($iDSum = null)
    {
        $this->IDSum = $iDSum;
        return $this;
    }
    /**
     * Get DebtorEstate value
     * @return string|null
     */
    public function getDebtorEstate()
    {
        return $this->DebtorEstate;
    }
    /**
     * Set DebtorEstate value
     * @param string $debtorEstate
     * @return \StructType\ExtDoc
     */
    public function setDebtorEstate($debtorEstate = null)
    {
        $this->DebtorEstate = $debtorEstate;
        return $this;
    }
    /**
     * Get Period value
     * @return string|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param string $period
     * @return \StructType\ExtDoc
     */
    public function setPeriod($period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Get PeriodSum value
     * @return string|null
     */
    public function getPeriodSum()
    {
        return $this->PeriodSum;
    }
    /**
     * Set PeriodSum value
     * @param string $periodSum
     * @return \StructType\ExtDoc
     */
    public function setPeriodSum($periodSum = null)
    {
        $this->PeriodSum = $periodSum;
        return $this;
    }
    /**
     * Get Repeat value
     * @return bool|null
     */
    public function getRepeat()
    {
        return $this->Repeat;
    }
    /**
     * Set Repeat value
     * @param bool $repeat
     * @return \StructType\ExtDoc
     */
    public function setRepeat($repeat = null)
    {
        $this->Repeat = $repeat;
        return $this;
    }
    /**
     * Get DebtorNo value
     * @return string|null
     */
    public function getDebtorNo()
    {
        return $this->DebtorNo;
    }
    /**
     * Set DebtorNo value
     * @param string $debtorNo
     * @return \StructType\ExtDoc
     */
    public function setDebtorNo($debtorNo = null)
    {
        $this->DebtorNo = $debtorNo;
        return $this;
    }
    /**
     * Get SrokDobrPFR value
     * @return string|null
     */
    public function getSrokDobrPFR()
    {
        return $this->SrokDobrPFR;
    }
    /**
     * Set SrokDobrPFR value
     * @param string $srokDobrPFR
     * @return \StructType\ExtDoc
     */
    public function setSrokDobrPFR($srokDobrPFR = null)
    {
        $this->SrokDobrPFR = $srokDobrPFR;
        return $this;
    }
    /**
     * Get KoAPArticle value
     * @return string|null
     */
    public function getKoAPArticle()
    {
        return $this->KoAPArticle;
    }
    /**
     * Set KoAPArticle value
     * @param string $koAPArticle
     * @return \StructType\ExtDoc
     */
    public function setKoAPArticle($koAPArticle = null)
    {
        $this->KoAPArticle = $koAPArticle;
        return $this;
    }
    /**
     * Get KoAPPart value
     * @return string|null
     */
    public function getKoAPPart()
    {
        return $this->KoAPPart;
    }
    /**
     * Set KoAPPart value
     * @param string $koAPPart
     * @return \StructType\ExtDoc
     */
    public function setKoAPPart($koAPPart = null)
    {
        $this->KoAPPart = $koAPPart;
        return $this;
    }
    /**
     * Get KoAPPoint value
     * @return string|null
     */
    public function getKoAPPoint()
    {
        return $this->KoAPPoint;
    }
    /**
     * Set KoAPPoint value
     * @param string $koAPPoint
     * @return \StructType\ExtDoc
     */
    public function setKoAPPoint($koAPPoint = null)
    {
        $this->KoAPPoint = $koAPPoint;
        return $this;
    }
    /**
     * Get NoAccount value
     * @return bool|null
     */
    public function getNoAccount()
    {
        return $this->NoAccount;
    }
    /**
     * Set NoAccount value
     * @param bool $noAccount
     * @return \StructType\ExtDoc
     */
    public function setNoAccount($noAccount = null)
    {
        $this->NoAccount = $noAccount;
        return $this;
    }
    /**
     * Get IsDuplicate value
     * @return bool|null
     */
    public function getIsDuplicate()
    {
        return $this->IsDuplicate;
    }
    /**
     * Set IsDuplicate value
     * @param bool $isDuplicate
     * @return \StructType\ExtDoc
     */
    public function setIsDuplicate($isDuplicate = null)
    {
        $this->IsDuplicate = $isDuplicate;
        return $this;
    }
    /**
     * Get IDBase value
     * @return string|null
     */
    public function getIDBase()
    {
        return $this->IDBase;
    }
    /**
     * Set IDBase value
     * @param string $iDBase
     * @return \StructType\ExtDoc
     */
    public function setIDBase($iDBase = null)
    {
        $this->IDBase = $iDBase;
        return $this;
    }
    /**
     * Get SignatureBase value
     * @return string|null
     */
    public function getSignatureBase()
    {
        return $this->SignatureBase;
    }
    /**
     * Set SignatureBase value
     * @param string $signatureBase
     * @return \StructType\ExtDoc
     */
    public function setSignatureBase($signatureBase = null)
    {
        $this->SignatureBase = $signatureBase;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\ExtDoc
     */
    public function setData(array $data = array())
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\ExtDoc
     */
    public function addToData(\StructType\Data $item)
    {
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get PaymentProperties value
     * @return \StructType\PaymentProperties[]|null
     */
    public function getPaymentProperties()
    {
        return $this->PaymentProperties;
    }
    /**
     * Set PaymentProperties value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProperties[] $paymentProperties
     * @return \StructType\ExtDoc
     */
    public function setPaymentProperties(array $paymentProperties = array())
    {
        $this->PaymentProperties = $paymentProperties;
        return $this;
    }
    /**
     * Add item to PaymentProperties value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProperties $item
     * @return \StructType\ExtDoc
     */
    public function addToPaymentProperties(\StructType\PaymentProperties $item)
    {
        $this->PaymentProperties[] = $item;
        return $this;
    }
    /**
     * Get Sequestration value
     * @return \StructType\SequestrationType[]|null
     */
    public function getSequestration()
    {
        return $this->Sequestration;
    }
    /**
     * Set Sequestration value
     * @throws \InvalidArgumentException
     * @param \StructType\SequestrationType[] $sequestration
     * @return \StructType\ExtDoc
     */
    public function setSequestration(array $sequestration = array())
    {
        $this->Sequestration = $sequestration;
        return $this;
    }
    /**
     * Add item to Sequestration value
     * @throws \InvalidArgumentException
     * @param \StructType\SequestrationType $item
     * @return \StructType\ExtDoc
     */
    public function addToSequestration(\StructType\SequestrationType $item)
    {
        $this->Sequestration[] = $item;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\ExtDoc
     */
    public function setAttachments(array $attachments = array())
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\ExtDoc
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\ExtDoc
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\ExtDoc
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\ExtDoc
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ExtDoc
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtDoc
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
