<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сообщение о системной ошибке | В данных полях хранятся данные об ошибке. Это могут быть как сообщение и код ошибки подсистемы
 * МВВ, так и сообщение и код ошибки операционной системы или иного программного обеспечения, используемого в обмене данными
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - documentation: Сообщений об ошибке
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: Код ошибки
     * @var int
     */
    public $code;
    /**
     * Constructor method for Error
     * @uses Error::setMessage()
     * @uses Error::setCode()
     * @param string $message
     * @param int $code
     */
    public function __construct($message = null, $code = null)
    {
        $this
            ->setMessage($message)
            ->setCode($code);
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Error
     */
    public function setMessage($message = null)
    {
        $this->message = $message;
        return $this;
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \StructType\Error
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Error
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
