<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Envelope StructType
 * Meta informations extracted from the WSDL
 * - documentation: Конверт | Дополнительные атрибуты документов
 * @subpackage Structs
 */
class Envelope extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор конверта | Идентификатор объекта | Атрибут документа
     * - use: required
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - documentation: Адреса отправителя и получателя документа | Обязательно, если адреса не соответствуют адресу пакета. Поле не заполняется при
     * пакетном обмене.
     * - minOccurs: 0
     * @var \StructType\Direction
     */
    public $Direction;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocBarCode
     * Meta informations extracted from the WSDL
     * - documentation: Штрих-код документа | Штрих-код документа
     * - minOccurs: 0
     * - maxLength: 44
     * - minLength: 1
     * @var string
     */
    public $DocBarCode;
    /**
     * The DocumentAttrs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:DocumentAttrs
     * @var \StructType\DocumentAttrs
     */
    public $DocumentAttrs;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - documentation: Данные документа
     * - minOccurs: 0
     * @var \StructType\DocumentContainer
     */
    public $Document;
    /**
     * The AttachmentsFileInfo
     * Meta informations extracted from the WSDL
     * - documentation: Информация о вложении в виде файла
     * @var \StructType\EnvelopeFileInfo
     */
    public $AttachmentsFileInfo;
    /**
     * The attachmentTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип вложения
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $attachmentTypeCode;
    /**
     * The doc_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа отправителя документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $doc_id;
    /**
     * The doc_type
     * Meta informations extracted from the WSDL
     * - documentation: Код типа документа отправителя документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного
     * документооборота | NSI_Document | Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $doc_type;
    /**
     * The event
     * Meta informations extracted from the WSDL
     * - documentation: Наименование события в документообороте | Наименование события документооборота
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $event;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The content_type
     * Meta informations extracted from the WSDL
     * - documentation: MIME-тип данных | MIME-тип данных
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $content_type;
    /**
     * The attachment_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $attachment_id;
    /**
     * Constructor method for Envelope
     * @uses Envelope::setId()
     * @uses Envelope::setDirection()
     * @uses Envelope::setDocNumber()
     * @uses Envelope::setDocDate()
     * @uses Envelope::setDocBarCode()
     * @uses Envelope::setDocumentAttrs()
     * @uses Envelope::setDocument()
     * @uses Envelope::setAttachmentsFileInfo()
     * @uses Envelope::setAttachmentTypeCode()
     * @uses Envelope::setDoc_id()
     * @uses Envelope::setDoc_type()
     * @uses Envelope::setEvent()
     * @uses Envelope::setName()
     * @uses Envelope::setContent_type()
     * @uses Envelope::setAttachment_id()
     * @param string $id
     * @param \StructType\Direction $direction
     * @param string $docNumber
     * @param string $docDate
     * @param string $docBarCode
     * @param \StructType\DocumentAttrs $documentAttrs
     * @param \StructType\DocumentContainer $document
     * @param \StructType\EnvelopeFileInfo $attachmentsFileInfo
     * @param string $attachmentTypeCode
     * @param string $doc_id
     * @param string $doc_type
     * @param string $event
     * @param string $name
     * @param string $content_type
     * @param string $attachment_id
     */
    public function __construct($id = null, \StructType\Direction $direction = null, $docNumber = null, $docDate = null, $docBarCode = null, \StructType\DocumentAttrs $documentAttrs = null, \StructType\DocumentContainer $document = null, \StructType\EnvelopeFileInfo $attachmentsFileInfo = null, $attachmentTypeCode = null, $doc_id = null, $doc_type = null, $event = null, $name = null, $content_type = null, $attachment_id = null)
    {
        $this
            ->setId($id)
            ->setDirection($direction)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setDocBarCode($docBarCode)
            ->setDocumentAttrs($documentAttrs)
            ->setDocument($document)
            ->setAttachmentsFileInfo($attachmentsFileInfo)
            ->setAttachmentTypeCode($attachmentTypeCode)
            ->setDoc_id($doc_id)
            ->setDoc_type($doc_type)
            ->setEvent($event)
            ->setName($name)
            ->setContent_type($content_type)
            ->setAttachment_id($attachment_id);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Envelope
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get Direction value
     * @return \StructType\Direction|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param \StructType\Direction $direction
     * @return \StructType\Envelope
     */
    public function setDirection(\StructType\Direction $direction = null)
    {
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\Envelope
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\Envelope
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocBarCode value
     * @return string|null
     */
    public function getDocBarCode()
    {
        return $this->DocBarCode;
    }
    /**
     * Set DocBarCode value
     * @param string $docBarCode
     * @return \StructType\Envelope
     */
    public function setDocBarCode($docBarCode = null)
    {
        $this->DocBarCode = $docBarCode;
        return $this;
    }
    /**
     * Get DocumentAttrs value
     * @return \StructType\DocumentAttrs|null
     */
    public function getDocumentAttrs()
    {
        return $this->DocumentAttrs;
    }
    /**
     * Set DocumentAttrs value
     * @param \StructType\DocumentAttrs $documentAttrs
     * @return \StructType\Envelope
     */
    public function setDocumentAttrs(\StructType\DocumentAttrs $documentAttrs = null)
    {
        $this->DocumentAttrs = $documentAttrs;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\DocumentContainer|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \StructType\DocumentContainer $document
     * @return \StructType\Envelope
     */
    public function setDocument(\StructType\DocumentContainer $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Get AttachmentsFileInfo value
     * @return \StructType\EnvelopeFileInfo|null
     */
    public function getAttachmentsFileInfo()
    {
        return $this->AttachmentsFileInfo;
    }
    /**
     * Set AttachmentsFileInfo value
     * @param \StructType\EnvelopeFileInfo $attachmentsFileInfo
     * @return \StructType\Envelope
     */
    public function setAttachmentsFileInfo(\StructType\EnvelopeFileInfo $attachmentsFileInfo = null)
    {
        $this->AttachmentsFileInfo = $attachmentsFileInfo;
        return $this;
    }
    /**
     * Get attachmentTypeCode value
     * @return string|null
     */
    public function getAttachmentTypeCode()
    {
        return $this->attachmentTypeCode;
    }
    /**
     * Set attachmentTypeCode value
     * @param string $attachmentTypeCode
     * @return \StructType\Envelope
     */
    public function setAttachmentTypeCode($attachmentTypeCode = null)
    {
        $this->attachmentTypeCode = $attachmentTypeCode;
        return $this;
    }
    /**
     * Get doc_id value
     * @return string|null
     */
    public function getDoc_id()
    {
        return $this->doc_id;
    }
    /**
     * Set doc_id value
     * @param string $doc_id
     * @return \StructType\Envelope
     */
    public function setDoc_id($doc_id = null)
    {
        $this->doc_id = $doc_id;
        return $this;
    }
    /**
     * Get doc_type value
     * @return string|null
     */
    public function getDoc_type()
    {
        return $this->doc_type;
    }
    /**
     * Set doc_type value
     * @param string $doc_type
     * @return \StructType\Envelope
     */
    public function setDoc_type($doc_type = null)
    {
        $this->doc_type = $doc_type;
        return $this;
    }
    /**
     * Get event value
     * @return string|null
     */
    public function getEvent()
    {
        return $this->event;
    }
    /**
     * Set event value
     * @param string $event
     * @return \StructType\Envelope
     */
    public function setEvent($event = null)
    {
        $this->event = $event;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Envelope
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get content_type value
     * @return string|null
     */
    public function getContent_type()
    {
        return $this->content_type;
    }
    /**
     * Set content_type value
     * @param string $content_type
     * @return \StructType\Envelope
     */
    public function setContent_type($content_type = null)
    {
        $this->content_type = $content_type;
        return $this;
    }
    /**
     * Get attachment_id value
     * @return string|null
     */
    public function getAttachment_id()
    {
        return $this->attachment_id;
    }
    /**
     * Set attachment_id value
     * @param string $attachment_id
     * @return \StructType\Envelope
     */
    public function setAttachment_id($attachment_id = null)
    {
        $this->attachment_id = $attachment_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Envelope
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
