<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EQSyncRegistryResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ со справочником или реестром для сервиса личного приёма
 * - type: tns:EQSyncRegistryResponse
 * @subpackage Structs
 */
class EQSyncRegistryResponse extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время актуальности реестра | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The TypeDoc
     * Meta informations extracted from the WSDL
     * - documentation: Тип справочника
     * - minOccurs: 0
     * @var string
     */
    public $TypeDoc;
    /**
     * The FileData
     * Meta informations extracted from the WSDL
     * - documentation: Файл со справочником или реестром
     * - minOccurs: 0
     * @var string
     */
    public $FileData;
    /**
     * Constructor method for EQSyncRegistryResponse
     * @uses EQSyncRegistryResponse::setInternalKey()
     * @uses EQSyncRegistryResponse::setRequestExternalKey()
     * @uses EQSyncRegistryResponse::setUnloadDate()
     * @uses EQSyncRegistryResponse::setTypeDoc()
     * @uses EQSyncRegistryResponse::setFileData()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param string $unloadDate
     * @param string $typeDoc
     * @param string $fileData
     */
    public function __construct($internalKey = null, $requestExternalKey = null, $unloadDate = null, $typeDoc = null, $fileData = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setUnloadDate($unloadDate)
            ->setTypeDoc($typeDoc)
            ->setFileData($fileData);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\EQSyncRegistryResponse
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \StructType\EQSyncRegistryResponse
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \StructType\EQSyncRegistryResponse
     */
    public function setUnloadDate($unloadDate = null)
    {
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @uses \EnumType\RegistryDocType::valueIsValid()
     * @uses \EnumType\RegistryDocType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeDoc
     * @return \StructType\EQSyncRegistryResponse
     */
    public function setTypeDoc($typeDoc = null)
    {
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Get FileData value
     * @return string|null
     */
    public function getFileData()
    {
        return $this->FileData;
    }
    /**
     * Set FileData value
     * @param string $fileData
     * @return \StructType\EQSyncRegistryResponse
     */
    public function setFileData($fileData = null)
    {
        $this->FileData = $fileData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EQSyncRegistryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
