<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EQAppointmentDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ-заявка записи на приём
 * - type: tns:EQAppointmentDocument
 * @subpackage Structs
 */
class EQAppointmentDocument extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The Applicant
     * Meta informations extracted from the WSDL
     * - documentation: Заявитель
     * @var \StructType\EQApplicant
     */
    public $Applicant;
    /**
     * The IsCA
     * Meta informations extracted from the WSDL
     * - documentation: Cотрудник ЦА или аппарата управления ТО | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsCA;
    /**
     * The Official
     * Meta informations extracted from the WSDL
     * - documentation: Код сотрудника | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $Official;
    /**
     * The Post
     * Meta informations extracted from the WSDL
     * - documentation: Код должности | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $Post;
    /**
     * The Theme
     * Meta informations extracted from the WSDL
     * - documentation: Код внешней темы обращения | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $Theme;
    /**
     * The Vksp
     * Meta informations extracted from the WSDL
     * - documentation: Код ВКСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $Vksp;
    /**
     * The TimeSlot
     * Meta informations extracted from the WSDL
     * - documentation: Код промежутка времени приёма | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $TimeSlot;
    /**
     * The UseFirstAvailableTime
     * Meta informations extracted from the WSDL
     * - documentation: Использовать первое свободное время | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $UseFirstAvailableTime;
    /**
     * The ReceptionDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата приёма | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ReceptionDate;
    /**
     * The IpNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IpNumber;
    /**
     * The PreviousId
     * Meta informations extracted from the WSDL
     * - documentation: Код предыдущего обращения | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $PreviousId;
    /**
     * The PreviousPost
     * Meta informations extracted from the WSDL
     * - documentation: Код должности из предыдущего обращения | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $PreviousPost;
    /**
     * The PreviousDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата предыдущего приёма | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PreviousDate;
    /**
     * The PreviousVksp
     * Meta informations extracted from the WSDL
     * - documentation: ВКСП предыдущего приема | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $PreviousVksp;
    /**
     * The AppText
     * Meta informations extracted from the WSDL
     * - documentation: Текст обращения | Массив произвольных данных (текстовый)
     * - minOccurs: 0
     * @var string
     */
    public $AppText;
    /**
     * Constructor method for EQAppointmentDocument
     * @uses EQAppointmentDocument::setExternalKey()
     * @uses EQAppointmentDocument::setDocDate()
     * @uses EQAppointmentDocument::setDocNumber()
     * @uses EQAppointmentDocument::setApplicant()
     * @uses EQAppointmentDocument::setIsCA()
     * @uses EQAppointmentDocument::setOfficial()
     * @uses EQAppointmentDocument::setPost()
     * @uses EQAppointmentDocument::setTheme()
     * @uses EQAppointmentDocument::setVksp()
     * @uses EQAppointmentDocument::setTimeSlot()
     * @uses EQAppointmentDocument::setUseFirstAvailableTime()
     * @uses EQAppointmentDocument::setReceptionDate()
     * @uses EQAppointmentDocument::setIpNumber()
     * @uses EQAppointmentDocument::setPreviousId()
     * @uses EQAppointmentDocument::setPreviousPost()
     * @uses EQAppointmentDocument::setPreviousDate()
     * @uses EQAppointmentDocument::setPreviousVksp()
     * @uses EQAppointmentDocument::setAppText()
     * @param string $externalKey
     * @param string $docDate
     * @param string $docNumber
     * @param \StructType\EQApplicant $applicant
     * @param bool $isCA
     * @param int $official
     * @param int $post
     * @param int $theme
     * @param string $vksp
     * @param int $timeSlot
     * @param bool $useFirstAvailableTime
     * @param string $receptionDate
     * @param string $ipNumber
     * @param int $previousId
     * @param int $previousPost
     * @param string $previousDate
     * @param string $previousVksp
     * @param string $appText
     */
    public function __construct($externalKey = null, $docDate = null, $docNumber = null, \StructType\EQApplicant $applicant = null, $isCA = null, $official = null, $post = null, $theme = null, $vksp = null, $timeSlot = null, $useFirstAvailableTime = null, $receptionDate = null, $ipNumber = null, $previousId = null, $previousPost = null, $previousDate = null, $previousVksp = null, $appText = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setApplicant($applicant)
            ->setIsCA($isCA)
            ->setOfficial($official)
            ->setPost($post)
            ->setTheme($theme)
            ->setVksp($vksp)
            ->setTimeSlot($timeSlot)
            ->setUseFirstAvailableTime($useFirstAvailableTime)
            ->setReceptionDate($receptionDate)
            ->setIpNumber($ipNumber)
            ->setPreviousId($previousId)
            ->setPreviousPost($previousPost)
            ->setPreviousDate($previousDate)
            ->setPreviousVksp($previousVksp)
            ->setAppText($appText);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\EQAppointmentDocument
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\EQAppointmentDocument
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\EQAppointmentDocument
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get Applicant value
     * @return \StructType\EQApplicant|null
     */
    public function getApplicant()
    {
        return $this->Applicant;
    }
    /**
     * Set Applicant value
     * @param \StructType\EQApplicant $applicant
     * @return \StructType\EQAppointmentDocument
     */
    public function setApplicant(\StructType\EQApplicant $applicant = null)
    {
        $this->Applicant = $applicant;
        return $this;
    }
    /**
     * Get IsCA value
     * @return bool|null
     */
    public function getIsCA()
    {
        return $this->IsCA;
    }
    /**
     * Set IsCA value
     * @param bool $isCA
     * @return \StructType\EQAppointmentDocument
     */
    public function setIsCA($isCA = null)
    {
        $this->IsCA = $isCA;
        return $this;
    }
    /**
     * Get Official value
     * @return int|null
     */
    public function getOfficial()
    {
        return $this->Official;
    }
    /**
     * Set Official value
     * @param int $official
     * @return \StructType\EQAppointmentDocument
     */
    public function setOfficial($official = null)
    {
        $this->Official = $official;
        return $this;
    }
    /**
     * Get Post value
     * @return int|null
     */
    public function getPost()
    {
        return $this->Post;
    }
    /**
     * Set Post value
     * @param int $post
     * @return \StructType\EQAppointmentDocument
     */
    public function setPost($post = null)
    {
        $this->Post = $post;
        return $this;
    }
    /**
     * Get Theme value
     * @return int|null
     */
    public function getTheme()
    {
        return $this->Theme;
    }
    /**
     * Set Theme value
     * @param int $theme
     * @return \StructType\EQAppointmentDocument
     */
    public function setTheme($theme = null)
    {
        $this->Theme = $theme;
        return $this;
    }
    /**
     * Get Vksp value
     * @return string|null
     */
    public function getVksp()
    {
        return $this->Vksp;
    }
    /**
     * Set Vksp value
     * @param string $vksp
     * @return \StructType\EQAppointmentDocument
     */
    public function setVksp($vksp = null)
    {
        $this->Vksp = $vksp;
        return $this;
    }
    /**
     * Get TimeSlot value
     * @return int|null
     */
    public function getTimeSlot()
    {
        return $this->TimeSlot;
    }
    /**
     * Set TimeSlot value
     * @param int $timeSlot
     * @return \StructType\EQAppointmentDocument
     */
    public function setTimeSlot($timeSlot = null)
    {
        $this->TimeSlot = $timeSlot;
        return $this;
    }
    /**
     * Get UseFirstAvailableTime value
     * @return bool|null
     */
    public function getUseFirstAvailableTime()
    {
        return $this->UseFirstAvailableTime;
    }
    /**
     * Set UseFirstAvailableTime value
     * @param bool $useFirstAvailableTime
     * @return \StructType\EQAppointmentDocument
     */
    public function setUseFirstAvailableTime($useFirstAvailableTime = null)
    {
        $this->UseFirstAvailableTime = $useFirstAvailableTime;
        return $this;
    }
    /**
     * Get ReceptionDate value
     * @return string|null
     */
    public function getReceptionDate()
    {
        return $this->ReceptionDate;
    }
    /**
     * Set ReceptionDate value
     * @param string $receptionDate
     * @return \StructType\EQAppointmentDocument
     */
    public function setReceptionDate($receptionDate = null)
    {
        $this->ReceptionDate = $receptionDate;
        return $this;
    }
    /**
     * Get IpNumber value
     * @return string|null
     */
    public function getIpNumber()
    {
        return $this->IpNumber;
    }
    /**
     * Set IpNumber value
     * @param string $ipNumber
     * @return \StructType\EQAppointmentDocument
     */
    public function setIpNumber($ipNumber = null)
    {
        $this->IpNumber = $ipNumber;
        return $this;
    }
    /**
     * Get PreviousId value
     * @return int|null
     */
    public function getPreviousId()
    {
        return $this->PreviousId;
    }
    /**
     * Set PreviousId value
     * @param int $previousId
     * @return \StructType\EQAppointmentDocument
     */
    public function setPreviousId($previousId = null)
    {
        $this->PreviousId = $previousId;
        return $this;
    }
    /**
     * Get PreviousPost value
     * @return int|null
     */
    public function getPreviousPost()
    {
        return $this->PreviousPost;
    }
    /**
     * Set PreviousPost value
     * @param int $previousPost
     * @return \StructType\EQAppointmentDocument
     */
    public function setPreviousPost($previousPost = null)
    {
        $this->PreviousPost = $previousPost;
        return $this;
    }
    /**
     * Get PreviousDate value
     * @return string|null
     */
    public function getPreviousDate()
    {
        return $this->PreviousDate;
    }
    /**
     * Set PreviousDate value
     * @param string $previousDate
     * @return \StructType\EQAppointmentDocument
     */
    public function setPreviousDate($previousDate = null)
    {
        $this->PreviousDate = $previousDate;
        return $this;
    }
    /**
     * Get PreviousVksp value
     * @return string|null
     */
    public function getPreviousVksp()
    {
        return $this->PreviousVksp;
    }
    /**
     * Set PreviousVksp value
     * @param string $previousVksp
     * @return \StructType\EQAppointmentDocument
     */
    public function setPreviousVksp($previousVksp = null)
    {
        $this->PreviousVksp = $previousVksp;
        return $this;
    }
    /**
     * Get AppText value
     * @return string|null
     */
    public function getAppText()
    {
        return $this->AppText;
    }
    /**
     * Set AppText value
     * @param string $appText
     * @return \StructType\EQAppointmentDocument
     */
    public function setAppText($appText = null)
    {
        $this->AppText = $appText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EQAppointmentDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
