<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EQApplicant StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявитель на личный приём
 * @subpackage Structs
 */
class EQApplicant extends AbstractStructBase
{
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - documentation: Фамилия | Строка длиной от 1 до 60 символов
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Surname;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Имя | Строка длиной от 1 до 60 символов
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Name;
    /**
     * The Patronymic
     * Meta informations extracted from the WSDL
     * - documentation: Отчество | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Patronymic;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BirthDate;
    /**
     * The Snils
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС | СНИЛС
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $Snils;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - documentation: Телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $Phone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - documentation: Адрес электронной почты | Адрес электронной почты
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $Email;
    /**
     * The AddressReg
     * Meta informations extracted from the WSDL
     * - documentation: Адрес места регистрации | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $AddressReg;
    /**
     * The AddressFact
     * Meta informations extracted from the WSDL
     * - documentation: Адрес фактического проживания | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $AddressFact;
    /**
     * Constructor method for EQApplicant
     * @uses EQApplicant::setSurname()
     * @uses EQApplicant::setName()
     * @uses EQApplicant::setPatronymic()
     * @uses EQApplicant::setBirthDate()
     * @uses EQApplicant::setSnils()
     * @uses EQApplicant::setPhone()
     * @uses EQApplicant::setEmail()
     * @uses EQApplicant::setAddressReg()
     * @uses EQApplicant::setAddressFact()
     * @param string $surname
     * @param string $name
     * @param string $patronymic
     * @param string $birthDate
     * @param string $snils
     * @param string $phone
     * @param string $email
     * @param string $addressReg
     * @param string $addressFact
     */
    public function __construct($surname = null, $name = null, $patronymic = null, $birthDate = null, $snils = null, $phone = null, $email = null, $addressReg = null, $addressFact = null)
    {
        $this
            ->setSurname($surname)
            ->setName($name)
            ->setPatronymic($patronymic)
            ->setBirthDate($birthDate)
            ->setSnils($snils)
            ->setPhone($phone)
            ->setEmail($email)
            ->setAddressReg($addressReg)
            ->setAddressFact($addressFact);
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\EQApplicant
     */
    public function setSurname($surname = null)
    {
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\EQApplicant
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Patronymic value
     * @return string|null
     */
    public function getPatronymic()
    {
        return $this->Patronymic;
    }
    /**
     * Set Patronymic value
     * @param string $patronymic
     * @return \StructType\EQApplicant
     */
    public function setPatronymic($patronymic = null)
    {
        $this->Patronymic = $patronymic;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\EQApplicant
     */
    public function setBirthDate($birthDate = null)
    {
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Snils value
     * @return string|null
     */
    public function getSnils()
    {
        return $this->Snils;
    }
    /**
     * Set Snils value
     * @param string $snils
     * @return \StructType\EQApplicant
     */
    public function setSnils($snils = null)
    {
        $this->Snils = $snils;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\EQApplicant
     */
    public function setPhone($phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\EQApplicant
     */
    public function setEmail($email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get AddressReg value
     * @return string|null
     */
    public function getAddressReg()
    {
        return $this->AddressReg;
    }
    /**
     * Set AddressReg value
     * @param string $addressReg
     * @return \StructType\EQApplicant
     */
    public function setAddressReg($addressReg = null)
    {
        $this->AddressReg = $addressReg;
        return $this;
    }
    /**
     * Get AddressFact value
     * @return string|null
     */
    public function getAddressFact()
    {
        return $this->AddressFact;
    }
    /**
     * Set AddressFact value
     * @param string $addressFact
     * @return \StructType\EQApplicant
     */
    public function setAddressFact($addressFact = null)
    {
        $this->AddressFact = $addressFact;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EQApplicant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
