<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMailAttachmentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Прикрепленный файл сообщения электронной почты
 * @subpackage Structs
 */
class EMailAttachmentType extends AttachmentType
{
    /**
     * The AttachmentId
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла | Идентификатор сообщения электронной почты
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $AttachmentId;
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - documentation: MIME-Заголовки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EMailHeaderType[]
     */
    public $Header;
    /**
     * Constructor method for EMailAttachmentType
     * @uses EMailAttachmentType::setAttachmentId()
     * @uses EMailAttachmentType::setHeader()
     * @param string $attachmentId
     * @param \StructType\EMailHeaderType[] $header
     */
    public function __construct($attachmentId = null, array $header = array())
    {
        $this
            ->setAttachmentId($attachmentId)
            ->setHeader($header);
    }
    /**
     * Get AttachmentId value
     * @return string|null
     */
    public function getAttachmentId()
    {
        return $this->AttachmentId;
    }
    /**
     * Set AttachmentId value
     * @param string $attachmentId
     * @return \StructType\EMailAttachmentType
     */
    public function setAttachmentId($attachmentId = null)
    {
        $this->AttachmentId = $attachmentId;
        return $this;
    }
    /**
     * Get Header value
     * @return \StructType\EMailHeaderType[]|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @throws \InvalidArgumentException
     * @param \StructType\EMailHeaderType[] $header
     * @return \StructType\EMailAttachmentType
     */
    public function setHeader(array $header = array())
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Add item to Header value
     * @throws \InvalidArgumentException
     * @param \StructType\EMailHeaderType $item
     * @return \StructType\EMailAttachmentType
     */
    public function addToHeader(\StructType\EMailHeaderType $item)
    {
        $this->Header[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EMailAttachmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
