<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DxMessageType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сообщение
 * @subpackage Structs
 */
class DxMessageType extends ObjectType
{
    /**
     * The MessageType
     * Meta informations extracted from the WSDL
     * - documentation: Код сообщения
     * - minOccurs: 1
     * @var string
     */
    public $MessageType;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата
     * - minOccurs: 0
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер
     * - minOccurs: 0
     * - maxLength: 40
     * @var string
     */
    public $DocNumber;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Текст сообщения
     * - minOccurs: 0
     * - maxLength: 1000
     * @var string
     */
    public $Text;
    /**
     * The SenderDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ документа отправителя
     * - minOccurs: 0
     * - maxLength: 60
     * @var string
     */
    public $SenderDocId;
    /**
     * The ReceiverDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ документа получателя
     * - minOccurs: 0
     * - maxLength: 60
     * @var string
     */
    public $ReceiverDocId;
    /**
     * The PackId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор пакета
     * - minOccurs: 0
     * - fractionDigits: 0
     * @var float
     */
    public $PackId;
    /**
     * The Caption
     * Meta informations extracted from the WSDL
     * - documentation: Заголовок
     * - minOccurs: 0
     * - maxLength: 80
     * @var string
     */
    public $Caption;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ошибки
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * - minInclusive: -2147483648
     * @var int
     */
    public $ErrorCode;
    /**
     * Constructor method for DxMessageType
     * @uses DxMessageType::setMessageType()
     * @uses DxMessageType::setDocDate()
     * @uses DxMessageType::setDocNumber()
     * @uses DxMessageType::setText()
     * @uses DxMessageType::setSenderDocId()
     * @uses DxMessageType::setReceiverDocId()
     * @uses DxMessageType::setPackId()
     * @uses DxMessageType::setCaption()
     * @uses DxMessageType::setErrorCode()
     * @param string $messageType
     * @param string $docDate
     * @param string $docNumber
     * @param string $text
     * @param string $senderDocId
     * @param string $receiverDocId
     * @param float $packId
     * @param string $caption
     * @param int $errorCode
     */
    public function __construct($messageType = null, $docDate = null, $docNumber = null, $text = null, $senderDocId = null, $receiverDocId = null, $packId = null, $caption = null, $errorCode = null)
    {
        $this
            ->setMessageType($messageType)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setText($text)
            ->setSenderDocId($senderDocId)
            ->setReceiverDocId($receiverDocId)
            ->setPackId($packId)
            ->setCaption($caption)
            ->setErrorCode($errorCode);
    }
    /**
     * Get MessageType value
     * @return string
     */
    public function getMessageType()
    {
        return $this->MessageType;
    }
    /**
     * Set MessageType value
     * @uses \EnumType\DDxMessageTypeType::valueIsValid()
     * @uses \EnumType\DDxMessageTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageType
     * @return \StructType\DxMessageType
     */
    public function setMessageType($messageType = null)
    {
        $this->MessageType = $messageType;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\DxMessageType
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\DxMessageType
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\DxMessageType
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get SenderDocId value
     * @return string|null
     */
    public function getSenderDocId()
    {
        return $this->SenderDocId;
    }
    /**
     * Set SenderDocId value
     * @param string $senderDocId
     * @return \StructType\DxMessageType
     */
    public function setSenderDocId($senderDocId = null)
    {
        $this->SenderDocId = $senderDocId;
        return $this;
    }
    /**
     * Get ReceiverDocId value
     * @return string|null
     */
    public function getReceiverDocId()
    {
        return $this->ReceiverDocId;
    }
    /**
     * Set ReceiverDocId value
     * @param string $receiverDocId
     * @return \StructType\DxMessageType
     */
    public function setReceiverDocId($receiverDocId = null)
    {
        $this->ReceiverDocId = $receiverDocId;
        return $this;
    }
    /**
     * Get PackId value
     * @return float|null
     */
    public function getPackId()
    {
        return $this->PackId;
    }
    /**
     * Set PackId value
     * @param float $packId
     * @return \StructType\DxMessageType
     */
    public function setPackId($packId = null)
    {
        $this->PackId = $packId;
        return $this;
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \StructType\DxMessageType
     */
    public function setCaption($caption = null)
    {
        $this->Caption = $caption;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\DxMessageType
     */
    public function setErrorCode($errorCode = null)
    {
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DxMessageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
