<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о документе
 * @subpackage Structs
 */
class DocumentDatumType extends InformationType
{
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $number;
    /**
     * The documentDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $documentDate;
    /**
     * The issuerName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование органа, выдавшего документ | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $issuerName;
    /**
     * The documentFinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $documentFinDate;
    /**
     * The documentTypeId
     * Meta informations extracted from the WSDL
     * - documentation: Код вида документа | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $documentTypeId;
    /**
     * The documentTypeName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида документа | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $documentTypeName;
    /**
     * The groundId
     * Meta informations extracted from the WSDL
     * - documentation: Код основания приобретения дееспособности | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $groundId;
    /**
     * The groundName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование основания приобретения дееспособности | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $groundName;
    /**
     * Constructor method for DocumentDatumType
     * @uses DocumentDatumType::setNumber()
     * @uses DocumentDatumType::setDocumentDate()
     * @uses DocumentDatumType::setIssuerName()
     * @uses DocumentDatumType::setDocumentFinDate()
     * @uses DocumentDatumType::setDocumentTypeId()
     * @uses DocumentDatumType::setDocumentTypeName()
     * @uses DocumentDatumType::setGroundId()
     * @uses DocumentDatumType::setGroundName()
     * @param string $number
     * @param string $documentDate
     * @param string $issuerName
     * @param string $documentFinDate
     * @param int $documentTypeId
     * @param string $documentTypeName
     * @param int $groundId
     * @param string $groundName
     */
    public function __construct($number = null, $documentDate = null, $issuerName = null, $documentFinDate = null, $documentTypeId = null, $documentTypeName = null, $groundId = null, $groundName = null)
    {
        $this
            ->setNumber($number)
            ->setDocumentDate($documentDate)
            ->setIssuerName($issuerName)
            ->setDocumentFinDate($documentFinDate)
            ->setDocumentTypeId($documentTypeId)
            ->setDocumentTypeName($documentTypeName)
            ->setGroundId($groundId)
            ->setGroundName($groundName);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\DocumentDatumType
     */
    public function setNumber($number = null)
    {
        $this->number = $number;
        return $this;
    }
    /**
     * Get documentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->documentDate;
    }
    /**
     * Set documentDate value
     * @param string $documentDate
     * @return \StructType\DocumentDatumType
     */
    public function setDocumentDate($documentDate = null)
    {
        $this->documentDate = $documentDate;
        return $this;
    }
    /**
     * Get issuerName value
     * @return string|null
     */
    public function getIssuerName()
    {
        return $this->issuerName;
    }
    /**
     * Set issuerName value
     * @param string $issuerName
     * @return \StructType\DocumentDatumType
     */
    public function setIssuerName($issuerName = null)
    {
        $this->issuerName = $issuerName;
        return $this;
    }
    /**
     * Get documentFinDate value
     * @return string|null
     */
    public function getDocumentFinDate()
    {
        return $this->documentFinDate;
    }
    /**
     * Set documentFinDate value
     * @param string $documentFinDate
     * @return \StructType\DocumentDatumType
     */
    public function setDocumentFinDate($documentFinDate = null)
    {
        $this->documentFinDate = $documentFinDate;
        return $this;
    }
    /**
     * Get documentTypeId value
     * @return int|null
     */
    public function getDocumentTypeId()
    {
        return $this->documentTypeId;
    }
    /**
     * Set documentTypeId value
     * @param int $documentTypeId
     * @return \StructType\DocumentDatumType
     */
    public function setDocumentTypeId($documentTypeId = null)
    {
        $this->documentTypeId = $documentTypeId;
        return $this;
    }
    /**
     * Get documentTypeName value
     * @return string|null
     */
    public function getDocumentTypeName()
    {
        return $this->documentTypeName;
    }
    /**
     * Set documentTypeName value
     * @param string $documentTypeName
     * @return \StructType\DocumentDatumType
     */
    public function setDocumentTypeName($documentTypeName = null)
    {
        $this->documentTypeName = $documentTypeName;
        return $this;
    }
    /**
     * Get groundId value
     * @return int|null
     */
    public function getGroundId()
    {
        return $this->groundId;
    }
    /**
     * Set groundId value
     * @param int $groundId
     * @return \StructType\DocumentDatumType
     */
    public function setGroundId($groundId = null)
    {
        $this->groundId = $groundId;
        return $this;
    }
    /**
     * Get groundName value
     * @return string|null
     */
    public function getGroundName()
    {
        return $this->groundName;
    }
    /**
     * Set groundName value
     * @param string $groundName
     * @return \StructType\DocumentDatumType
     */
    public function setGroundName($groundName = null)
    {
        $this->groundName = $groundName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
