<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocNote StructType
 * Meta informations extracted from the WSDL
 * - documentation: Квитанция на документ пакета
 * @subpackage Structs
 */
class DocNote extends AbstractStructBase
{
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Текст и код сообщения
     * @var \StructType\MessageEx
     */
    public $Message;
    /**
     * The DocRef
     * Meta informations extracted from the WSDL
     * - documentation: Информация о документе
     * - minOccurs: 0
     * @var \StructType\DocumentRef
     */
    public $DocRef;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус приема документа.
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The FileNote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AttachmentFileNote
     */
    public $FileNote;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - documentation: Дата формирования сообщения | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $timestamp;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор сообщения | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * Constructor method for DocNote
     * @uses DocNote::setMessage()
     * @uses DocNote::setDocRef()
     * @uses DocNote::setStatus()
     * @uses DocNote::setFileNote()
     * @uses DocNote::setTimestamp()
     * @uses DocNote::setId()
     * @param \StructType\MessageEx $message
     * @param \StructType\DocumentRef $docRef
     * @param string $status
     * @param \StructType\AttachmentFileNote $fileNote
     * @param string $timestamp
     * @param string $id
     */
    public function __construct(\StructType\MessageEx $message = null, \StructType\DocumentRef $docRef = null, $status = null, \StructType\AttachmentFileNote $fileNote = null, $timestamp = null, $id = null)
    {
        $this
            ->setMessage($message)
            ->setDocRef($docRef)
            ->setStatus($status)
            ->setFileNote($fileNote)
            ->setTimestamp($timestamp)
            ->setId($id);
    }
    /**
     * Get Message value
     * @return \StructType\MessageEx|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \StructType\MessageEx $message
     * @return \StructType\DocNote
     */
    public function setMessage(\StructType\MessageEx $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get DocRef value
     * @return \StructType\DocumentRef|null
     */
    public function getDocRef()
    {
        return $this->DocRef;
    }
    /**
     * Set DocRef value
     * @param \StructType\DocumentRef $docRef
     * @return \StructType\DocNote
     */
    public function setDocRef(\StructType\DocumentRef $docRef = null)
    {
        $this->DocRef = $docRef;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ProcessResult::valueIsValid()
     * @uses \EnumType\ProcessResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\DocNote
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get FileNote value
     * @return \StructType\AttachmentFileNote|null
     */
    public function getFileNote()
    {
        return $this->FileNote;
    }
    /**
     * Set FileNote value
     * @param \StructType\AttachmentFileNote $fileNote
     * @return \StructType\DocNote
     */
    public function setFileNote(\StructType\AttachmentFileNote $fileNote = null)
    {
        $this->FileNote = $fileNote;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\DocNote
     */
    public function setTimestamp($timestamp = null)
    {
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\DocNote
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
