<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositBoxDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о наличии банковских ячеек
 * @subpackage Structs
 */
class DepositBoxDatumType extends InformationType
{
    /**
     * The contractNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер договора | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $contractNumber;
    /**
     * The contractDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата заключения договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $contractDate;
    /**
     * Constructor method for DepositBoxDatumType
     * @uses DepositBoxDatumType::setContractNumber()
     * @uses DepositBoxDatumType::setContractDate()
     * @param string $contractNumber
     * @param string $contractDate
     */
    public function __construct($contractNumber = null, $contractDate = null)
    {
        $this
            ->setContractNumber($contractNumber)
            ->setContractDate($contractDate);
    }
    /**
     * Get contractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->contractNumber;
    }
    /**
     * Set contractNumber value
     * @param string $contractNumber
     * @return \StructType\DepositBoxDatumType
     */
    public function setContractNumber($contractNumber = null)
    {
        $this->contractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get contractDate value
     * @return string|null
     */
    public function getContractDate()
    {
        return $this->contractDate;
    }
    /**
     * Set contractDate value
     * @param string $contractDate
     * @return \StructType\DepositBoxDatumType
     */
    public function setContractDate($contractDate = null)
    {
        $this->contractDate = $contractDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DepositBoxDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
