<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtorPropertyChange StructType
 * Meta informations extracted from the WSDL
 * - documentation: Уведомление об изменении реквизитов | ЭП
 * - type: tns:DebtorPropertyChange
 * @subpackage Structs
 */
class DebtorPropertyChange extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор заявления, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор исполнительного документа, полученного ранее от АИС внешнего контрагента. Заполняется
     * в том случае, если ИД был получен ранее от АИС того же внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего
     * контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве
     * обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер заявления | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата заявления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The OldDebtorName
     * Meta informations extracted from the WSDL
     * - documentation: Старое наименование должника | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $OldDebtorName;
    /**
     * The OldDebtorFio
     * Meta informations extracted from the WSDL
     * - documentation: Старое ФИО должника
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $OldDebtorFio;
    /**
     * The OldDebtorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Старый адрес регистрации должника
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $OldDebtorAddress;
    /**
     * The NewDepartmentCode
     * Meta informations extracted from the WSDL
     * - documentation: Код налогового органа нового места постановки на учет | Код подразделения организации | NSI_MVV_Department
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $NewDepartmentCode;
    /**
     * The NewDebtorName
     * Meta informations extracted from the WSDL
     * - documentation: Новое наименование должника | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $NewDebtorName;
    /**
     * The NewDebtorFio
     * Meta informations extracted from the WSDL
     * - documentation: Новое ФИО должника
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $NewDebtorFio;
    /**
     * The NewDebtorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Новый адрес регистрации должника
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $NewDebtorAddress;
    /**
     * The NewTaxOrganName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование налогового органа нового места постановки на учет | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $NewTaxOrganName;
    /**
     * The NewTaxOrganAddress
     * Meta informations extracted from the WSDL
     * - documentation: Адрес налогового органа нового места постановки на учет | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $NewTaxOrganAddress;
    /**
     * The TaxOrganChangeReason
     * Meta informations extracted from the WSDL
     * - documentation: Причина смены налогового органа места постановки на учет
     * - minOccurs: 0
     * @var string
     */
    public $TaxOrganChangeReason;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for DebtorPropertyChange
     * @uses DebtorPropertyChange::setExternalKey()
     * @uses DebtorPropertyChange::setIdExternalKey()
     * @uses DebtorPropertyChange::setDocNumber()
     * @uses DebtorPropertyChange::setDocDate()
     * @uses DebtorPropertyChange::setOldDebtorName()
     * @uses DebtorPropertyChange::setOldDebtorFio()
     * @uses DebtorPropertyChange::setOldDebtorAddress()
     * @uses DebtorPropertyChange::setNewDepartmentCode()
     * @uses DebtorPropertyChange::setNewDebtorName()
     * @uses DebtorPropertyChange::setNewDebtorFio()
     * @uses DebtorPropertyChange::setNewDebtorAddress()
     * @uses DebtorPropertyChange::setNewTaxOrganName()
     * @uses DebtorPropertyChange::setNewTaxOrganAddress()
     * @uses DebtorPropertyChange::setTaxOrganChangeReason()
     * @uses DebtorPropertyChange::setSignature()
     * @uses DebtorPropertyChange::setId()
     * @param string $externalKey
     * @param string $idExternalKey
     * @param string $docNumber
     * @param string $docDate
     * @param string $oldDebtorName
     * @param \StructType\FioType $oldDebtorFio
     * @param \StructType\AddressType $oldDebtorAddress
     * @param string $newDepartmentCode
     * @param string $newDebtorName
     * @param \StructType\FioType $newDebtorFio
     * @param \StructType\AddressType $newDebtorAddress
     * @param string $newTaxOrganName
     * @param string $newTaxOrganAddress
     * @param string $taxOrganChangeReason
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $idExternalKey = null, $docNumber = null, $docDate = null, $oldDebtorName = null, \StructType\FioType $oldDebtorFio = null, \StructType\AddressType $oldDebtorAddress = null, $newDepartmentCode = null, $newDebtorName = null, \StructType\FioType $newDebtorFio = null, \StructType\AddressType $newDebtorAddress = null, $newTaxOrganName = null, $newTaxOrganAddress = null, $taxOrganChangeReason = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setIdExternalKey($idExternalKey)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setOldDebtorName($oldDebtorName)
            ->setOldDebtorFio($oldDebtorFio)
            ->setOldDebtorAddress($oldDebtorAddress)
            ->setNewDepartmentCode($newDepartmentCode)
            ->setNewDebtorName($newDebtorName)
            ->setNewDebtorFio($newDebtorFio)
            ->setNewDebtorAddress($newDebtorAddress)
            ->setNewTaxOrganName($newTaxOrganName)
            ->setNewTaxOrganAddress($newTaxOrganAddress)
            ->setTaxOrganChangeReason($taxOrganChangeReason)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\DebtorPropertyChange
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \StructType\DebtorPropertyChange
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\DebtorPropertyChange
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\DebtorPropertyChange
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get OldDebtorName value
     * @return string|null
     */
    public function getOldDebtorName()
    {
        return $this->OldDebtorName;
    }
    /**
     * Set OldDebtorName value
     * @param string $oldDebtorName
     * @return \StructType\DebtorPropertyChange
     */
    public function setOldDebtorName($oldDebtorName = null)
    {
        $this->OldDebtorName = $oldDebtorName;
        return $this;
    }
    /**
     * Get OldDebtorFio value
     * @return \StructType\FioType|null
     */
    public function getOldDebtorFio()
    {
        return $this->OldDebtorFio;
    }
    /**
     * Set OldDebtorFio value
     * @param \StructType\FioType $oldDebtorFio
     * @return \StructType\DebtorPropertyChange
     */
    public function setOldDebtorFio(\StructType\FioType $oldDebtorFio = null)
    {
        $this->OldDebtorFio = $oldDebtorFio;
        return $this;
    }
    /**
     * Get OldDebtorAddress value
     * @return \StructType\AddressType|null
     */
    public function getOldDebtorAddress()
    {
        return $this->OldDebtorAddress;
    }
    /**
     * Set OldDebtorAddress value
     * @param \StructType\AddressType $oldDebtorAddress
     * @return \StructType\DebtorPropertyChange
     */
    public function setOldDebtorAddress(\StructType\AddressType $oldDebtorAddress = null)
    {
        $this->OldDebtorAddress = $oldDebtorAddress;
        return $this;
    }
    /**
     * Get NewDepartmentCode value
     * @return string|null
     */
    public function getNewDepartmentCode()
    {
        return $this->NewDepartmentCode;
    }
    /**
     * Set NewDepartmentCode value
     * @param string $newDepartmentCode
     * @return \StructType\DebtorPropertyChange
     */
    public function setNewDepartmentCode($newDepartmentCode = null)
    {
        $this->NewDepartmentCode = $newDepartmentCode;
        return $this;
    }
    /**
     * Get NewDebtorName value
     * @return string|null
     */
    public function getNewDebtorName()
    {
        return $this->NewDebtorName;
    }
    /**
     * Set NewDebtorName value
     * @param string $newDebtorName
     * @return \StructType\DebtorPropertyChange
     */
    public function setNewDebtorName($newDebtorName = null)
    {
        $this->NewDebtorName = $newDebtorName;
        return $this;
    }
    /**
     * Get NewDebtorFio value
     * @return \StructType\FioType|null
     */
    public function getNewDebtorFio()
    {
        return $this->NewDebtorFio;
    }
    /**
     * Set NewDebtorFio value
     * @param \StructType\FioType $newDebtorFio
     * @return \StructType\DebtorPropertyChange
     */
    public function setNewDebtorFio(\StructType\FioType $newDebtorFio = null)
    {
        $this->NewDebtorFio = $newDebtorFio;
        return $this;
    }
    /**
     * Get NewDebtorAddress value
     * @return \StructType\AddressType|null
     */
    public function getNewDebtorAddress()
    {
        return $this->NewDebtorAddress;
    }
    /**
     * Set NewDebtorAddress value
     * @param \StructType\AddressType $newDebtorAddress
     * @return \StructType\DebtorPropertyChange
     */
    public function setNewDebtorAddress(\StructType\AddressType $newDebtorAddress = null)
    {
        $this->NewDebtorAddress = $newDebtorAddress;
        return $this;
    }
    /**
     * Get NewTaxOrganName value
     * @return string|null
     */
    public function getNewTaxOrganName()
    {
        return $this->NewTaxOrganName;
    }
    /**
     * Set NewTaxOrganName value
     * @param string $newTaxOrganName
     * @return \StructType\DebtorPropertyChange
     */
    public function setNewTaxOrganName($newTaxOrganName = null)
    {
        $this->NewTaxOrganName = $newTaxOrganName;
        return $this;
    }
    /**
     * Get NewTaxOrganAddress value
     * @return string|null
     */
    public function getNewTaxOrganAddress()
    {
        return $this->NewTaxOrganAddress;
    }
    /**
     * Set NewTaxOrganAddress value
     * @param string $newTaxOrganAddress
     * @return \StructType\DebtorPropertyChange
     */
    public function setNewTaxOrganAddress($newTaxOrganAddress = null)
    {
        $this->NewTaxOrganAddress = $newTaxOrganAddress;
        return $this;
    }
    /**
     * Get TaxOrganChangeReason value
     * @return string|null
     */
    public function getTaxOrganChangeReason()
    {
        return $this->TaxOrganChangeReason;
    }
    /**
     * Set TaxOrganChangeReason value
     * @uses \EnumType\TaxOrganChangeReasonCodeType::valueIsValid()
     * @uses \EnumType\TaxOrganChangeReasonCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxOrganChangeReason
     * @return \StructType\DebtorPropertyChange
     */
    public function setTaxOrganChangeReason($taxOrganChangeReason = null)
    {
        $this->TaxOrganChangeReason = $taxOrganChangeReason;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\DebtorPropertyChange
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\DebtorPropertyChange
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\DebtorPropertyChange
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DebtorPropertyChange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
