<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtorNewAccountNotice StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об открытии должниками по ИП новых счетов в кредитных организациях | ЭП
 * - type: tns:DebtorNewAccountNotice
 * @subpackage Structs
 */
class DebtorNewAccountNotice extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The RestrictnInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ постановления ФССП России | Уникальный идентификатор Постановления об ограничении, присвоенный АИС ФССП России и
     * переданный ранее внешнему контрагенту в составе документа «Постановление об ограничении» | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $RestrictnInternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Уникальный идентификатор исполнительного производства, присвоенный АИС ФССП Росии и переданный ранее
     * внешнему контрагенту в составе документа «Постановление об ограничении» | Ключ объекта, присвоенний информационной системой ФССП РФ
     * при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The IpNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IpNumber;
    /**
     * The RestrictnDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления | Номер документа «Постановление об ограничении» | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $RestrictnDocNumber;
    /**
     * The RestrictnDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления | Дата документа «Постановление об ограничении» | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RestrictnDocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The AuthorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица | ФИО должностного лица, от имени которого направляется документ | Полное имя физического лица (фамилия,
     * имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $AuthorName;
    /**
     * The AuthorPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность | Наименование должности | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $AuthorPost;
    /**
     * The AuthorEmail
     * Meta informations extracted from the WSDL
     * - documentation: Электронная почта | Адрес электронной почты должностного лица | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $AuthorEmail;
    /**
     * The AuthorTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Контактный телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $AuthorTelephone;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о должнике
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for DebtorNewAccountNotice
     * @uses DebtorNewAccountNotice::setExternalKey()
     * @uses DebtorNewAccountNotice::setRestrictnInternalKey()
     * @uses DebtorNewAccountNotice::setIpInternalKey()
     * @uses DebtorNewAccountNotice::setIpNumber()
     * @uses DebtorNewAccountNotice::setRestrictnDocNumber()
     * @uses DebtorNewAccountNotice::setRestrictnDocDate()
     * @uses DebtorNewAccountNotice::setDocNumber()
     * @uses DebtorNewAccountNotice::setDocDate()
     * @uses DebtorNewAccountNotice::setAuthorName()
     * @uses DebtorNewAccountNotice::setAuthorPost()
     * @uses DebtorNewAccountNotice::setAuthorEmail()
     * @uses DebtorNewAccountNotice::setAuthorTelephone()
     * @uses DebtorNewAccountNotice::setData()
     * @uses DebtorNewAccountNotice::setSignature()
     * @uses DebtorNewAccountNotice::setId()
     * @param string $externalKey
     * @param int $restrictnInternalKey
     * @param int $ipInternalKey
     * @param string $ipNumber
     * @param string $restrictnDocNumber
     * @param string $restrictnDocDate
     * @param string $docNumber
     * @param string $docDate
     * @param string $authorName
     * @param string $authorPost
     * @param string $authorEmail
     * @param string $authorTelephone
     * @param \StructType\Data[] $data
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $restrictnInternalKey = null, $ipInternalKey = null, $ipNumber = null, $restrictnDocNumber = null, $restrictnDocDate = null, $docNumber = null, $docDate = null, $authorName = null, $authorPost = null, $authorEmail = null, $authorTelephone = null, array $data = array(), array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setRestrictnInternalKey($restrictnInternalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setIpNumber($ipNumber)
            ->setRestrictnDocNumber($restrictnDocNumber)
            ->setRestrictnDocDate($restrictnDocDate)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setAuthorName($authorName)
            ->setAuthorPost($authorPost)
            ->setAuthorEmail($authorEmail)
            ->setAuthorTelephone($authorTelephone)
            ->setData($data)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get RestrictnInternalKey value
     * @return int|null
     */
    public function getRestrictnInternalKey()
    {
        return $this->RestrictnInternalKey;
    }
    /**
     * Set RestrictnInternalKey value
     * @param int $restrictnInternalKey
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setRestrictnInternalKey($restrictnInternalKey = null)
    {
        $this->RestrictnInternalKey = $restrictnInternalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get IpNumber value
     * @return string|null
     */
    public function getIpNumber()
    {
        return $this->IpNumber;
    }
    /**
     * Set IpNumber value
     * @param string $ipNumber
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setIpNumber($ipNumber = null)
    {
        $this->IpNumber = $ipNumber;
        return $this;
    }
    /**
     * Get RestrictnDocNumber value
     * @return string|null
     */
    public function getRestrictnDocNumber()
    {
        return $this->RestrictnDocNumber;
    }
    /**
     * Set RestrictnDocNumber value
     * @param string $restrictnDocNumber
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setRestrictnDocNumber($restrictnDocNumber = null)
    {
        $this->RestrictnDocNumber = $restrictnDocNumber;
        return $this;
    }
    /**
     * Get RestrictnDocDate value
     * @return string|null
     */
    public function getRestrictnDocDate()
    {
        return $this->RestrictnDocDate;
    }
    /**
     * Set RestrictnDocDate value
     * @param string $restrictnDocDate
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setRestrictnDocDate($restrictnDocDate = null)
    {
        $this->RestrictnDocDate = $restrictnDocDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get AuthorName value
     * @return string|null
     */
    public function getAuthorName()
    {
        return $this->AuthorName;
    }
    /**
     * Set AuthorName value
     * @param string $authorName
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setAuthorName($authorName = null)
    {
        $this->AuthorName = $authorName;
        return $this;
    }
    /**
     * Get AuthorPost value
     * @return string|null
     */
    public function getAuthorPost()
    {
        return $this->AuthorPost;
    }
    /**
     * Set AuthorPost value
     * @param string $authorPost
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setAuthorPost($authorPost = null)
    {
        $this->AuthorPost = $authorPost;
        return $this;
    }
    /**
     * Get AuthorEmail value
     * @return string|null
     */
    public function getAuthorEmail()
    {
        return $this->AuthorEmail;
    }
    /**
     * Set AuthorEmail value
     * @param string $authorEmail
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setAuthorEmail($authorEmail = null)
    {
        $this->AuthorEmail = $authorEmail;
        return $this;
    }
    /**
     * Get AuthorTelephone value
     * @return string|null
     */
    public function getAuthorTelephone()
    {
        return $this->AuthorTelephone;
    }
    /**
     * Set AuthorTelephone value
     * @param string $authorTelephone
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setAuthorTelephone($authorTelephone = null)
    {
        $this->AuthorTelephone = $authorTelephone;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setData(array $data = array())
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\DebtorNewAccountNotice
     */
    public function addToData(\StructType\Data $item)
    {
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\DebtorNewAccountNotice
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\DebtorNewAccountNotice
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DebtorNewAccountNotice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
