<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeathDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о смерти
 * @subpackage Structs
 */
class DeathDatumType extends InformationType
{
    /**
     * The ActNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер актовой записи о смерти | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ActNumber;
    /**
     * The AktDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата актовой записи о смерти | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AktDate;
    /**
     * The RegistrationData
     * Meta informations extracted from the WSDL
     * - documentation: Место государственной регистрации | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $RegistrationData;
    /**
     * The DeathDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата смерти | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DeathDate;
    /**
     * The DeathPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место смерти | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DeathPlace;
    /**
     * The ComplementaryInfo
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительная информация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ComplementaryInfo;
    /**
     * Constructor method for DeathDatumType
     * @uses DeathDatumType::setActNumber()
     * @uses DeathDatumType::setAktDate()
     * @uses DeathDatumType::setRegistrationData()
     * @uses DeathDatumType::setDeathDate()
     * @uses DeathDatumType::setDeathPlace()
     * @uses DeathDatumType::setComplementaryInfo()
     * @param string $actNumber
     * @param string $aktDate
     * @param string $registrationData
     * @param string $deathDate
     * @param string $deathPlace
     * @param string $complementaryInfo
     */
    public function __construct($actNumber = null, $aktDate = null, $registrationData = null, $deathDate = null, $deathPlace = null, $complementaryInfo = null)
    {
        $this
            ->setActNumber($actNumber)
            ->setAktDate($aktDate)
            ->setRegistrationData($registrationData)
            ->setDeathDate($deathDate)
            ->setDeathPlace($deathPlace)
            ->setComplementaryInfo($complementaryInfo);
    }
    /**
     * Get ActNumber value
     * @return string|null
     */
    public function getActNumber()
    {
        return $this->ActNumber;
    }
    /**
     * Set ActNumber value
     * @param string $actNumber
     * @return \StructType\DeathDatumType
     */
    public function setActNumber($actNumber = null)
    {
        $this->ActNumber = $actNumber;
        return $this;
    }
    /**
     * Get AktDate value
     * @return string|null
     */
    public function getAktDate()
    {
        return $this->AktDate;
    }
    /**
     * Set AktDate value
     * @param string $aktDate
     * @return \StructType\DeathDatumType
     */
    public function setAktDate($aktDate = null)
    {
        $this->AktDate = $aktDate;
        return $this;
    }
    /**
     * Get RegistrationData value
     * @return string|null
     */
    public function getRegistrationData()
    {
        return $this->RegistrationData;
    }
    /**
     * Set RegistrationData value
     * @param string $registrationData
     * @return \StructType\DeathDatumType
     */
    public function setRegistrationData($registrationData = null)
    {
        $this->RegistrationData = $registrationData;
        return $this;
    }
    /**
     * Get DeathDate value
     * @return string|null
     */
    public function getDeathDate()
    {
        return $this->DeathDate;
    }
    /**
     * Set DeathDate value
     * @param string $deathDate
     * @return \StructType\DeathDatumType
     */
    public function setDeathDate($deathDate = null)
    {
        $this->DeathDate = $deathDate;
        return $this;
    }
    /**
     * Get DeathPlace value
     * @return string|null
     */
    public function getDeathPlace()
    {
        return $this->DeathPlace;
    }
    /**
     * Set DeathPlace value
     * @param string $deathPlace
     * @return \StructType\DeathDatumType
     */
    public function setDeathPlace($deathPlace = null)
    {
        $this->DeathPlace = $deathPlace;
        return $this;
    }
    /**
     * Get ComplementaryInfo value
     * @return string|null
     */
    public function getComplementaryInfo()
    {
        return $this->ComplementaryInfo;
    }
    /**
     * Set ComplementaryInfo value
     * @param string $complementaryInfo
     * @return \StructType\DeathDatumType
     */
    public function setComplementaryInfo($complementaryInfo = null)
    {
        $this->ComplementaryInfo = $complementaryInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeathDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
