<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXSystemInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Информация о системе
 * - type: tns:DXSystemInfo
 * @subpackage Structs
 */
class DXSystemInfo extends DXBlock
{
    /**
     * The SystemName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование системы | Заголовок
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $SystemName;
    /**
     * The Organization
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об организации
     * - minOccurs: 0
     * @var \StructType\OrganizationEx
     */
    public $Organization;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о подразделении
     * - minOccurs: 0
     * @var \StructType\DepartmentEx
     */
    public $Department;
    /**
     * Constructor method for DXSystemInfo
     * @uses DXSystemInfo::setSystemName()
     * @uses DXSystemInfo::setOrganization()
     * @uses DXSystemInfo::setDepartment()
     * @param string $systemName
     * @param \StructType\OrganizationEx $organization
     * @param \StructType\DepartmentEx $department
     */
    public function __construct($systemName = null, \StructType\OrganizationEx $organization = null, \StructType\DepartmentEx $department = null)
    {
        $this
            ->setSystemName($systemName)
            ->setOrganization($organization)
            ->setDepartment($department);
    }
    /**
     * Get SystemName value
     * @return string|null
     */
    public function getSystemName()
    {
        return $this->SystemName;
    }
    /**
     * Set SystemName value
     * @param string $systemName
     * @return \StructType\DXSystemInfo
     */
    public function setSystemName($systemName = null)
    {
        $this->SystemName = $systemName;
        return $this;
    }
    /**
     * Get Organization value
     * @return \StructType\OrganizationEx|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param \StructType\OrganizationEx $organization
     * @return \StructType\DXSystemInfo
     */
    public function setOrganization(\StructType\OrganizationEx $organization = null)
    {
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get Department value
     * @return \StructType\DepartmentEx|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * Set Department value
     * @param \StructType\DepartmentEx $department
     * @return \StructType\DXSystemInfo
     */
    public function setDepartment(\StructType\DepartmentEx $department = null)
    {
        $this->Department = $department;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DXSystemInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
