<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXPack StructType
 * Meta informations extracted from the WSDL
 * - documentation: Пакет документов
 * - type: tns:DXPack
 * @subpackage Structs
 */
class DXPack extends DXBlock
{
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата создания пакета документов | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер пакета документов в документообороте | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The Generation
     * Meta informations extracted from the WSDL
     * - documentation: Номер поколения | Номер поколения пакета
     * - minOccurs: 0
     * @var int
     */
    public $Generation;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - documentation: Приоритет пакета
     * - minOccurs: 0
     * @var string
     */
    public $Priority;
    /**
     * The Signed
     * Meta informations extracted from the WSDL
     * - documentation: Подписал
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $Signed;
    /**
     * The Documents
     * @var \StructType\Documents
     */
    public $Documents;
    /**
     * The Envelopes
     * @var \StructType\Envelopes
     */
    public $Envelopes;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - documentation: Технологические сообщения протокола обмена данными
     * - minOccurs: 0
     * @var \StructType\DocNoteCollection
     */
    public $Notes;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType
     */
    public $Signature;
    /**
     * The origin_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор создателя пакета | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $origin_id;
    /**
     * The time_created
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время создания пакета | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $time_created;
    /**
     * The time_queued
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время постановки пакета в очередь | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $time_queued;
    /**
     * The reset
     * Meta informations extracted from the WSDL
     * - documentation: Признак необходимости произвести полную или частичную перезапись пакета получателем | Обертка стандартного xs:boolean |
     * Логический
     * @var bool
     */
    public $reset;
    /**
     * Constructor method for DXPack
     * @uses DXPack::setDocDate()
     * @uses DXPack::setDocNumber()
     * @uses DXPack::setGeneration()
     * @uses DXPack::setPriority()
     * @uses DXPack::setSigned()
     * @uses DXPack::setDocuments()
     * @uses DXPack::setEnvelopes()
     * @uses DXPack::setNotes()
     * @uses DXPack::setSignature()
     * @uses DXPack::setOrigin_id()
     * @uses DXPack::setTime_created()
     * @uses DXPack::setTime_queued()
     * @uses DXPack::setReset()
     * @param string $docDate
     * @param string $docNumber
     * @param int $generation
     * @param string $priority
     * @param string $signed
     * @param \StructType\Documents $documents
     * @param \StructType\Envelopes $envelopes
     * @param \StructType\DocNoteCollection $notes
     * @param \StructType\SignatureType $signature
     * @param string $origin_id
     * @param string $time_created
     * @param string $time_queued
     * @param bool $reset
     */
    public function __construct($docDate = null, $docNumber = null, $generation = null, $priority = null, $signed = null, \StructType\Documents $documents = null, \StructType\Envelopes $envelopes = null, \StructType\DocNoteCollection $notes = null, \StructType\SignatureType $signature = null, $origin_id = null, $time_created = null, $time_queued = null, $reset = null)
    {
        $this
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setGeneration($generation)
            ->setPriority($priority)
            ->setSigned($signed)
            ->setDocuments($documents)
            ->setEnvelopes($envelopes)
            ->setNotes($notes)
            ->setSignature($signature)
            ->setOrigin_id($origin_id)
            ->setTime_created($time_created)
            ->setTime_queued($time_queued)
            ->setReset($reset);
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\DXPack
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\DXPack
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get Generation value
     * @return int|null
     */
    public function getGeneration()
    {
        return $this->Generation;
    }
    /**
     * Set Generation value
     * @param int $generation
     * @return \StructType\DXPack
     */
    public function setGeneration($generation = null)
    {
        $this->Generation = $generation;
        return $this;
    }
    /**
     * Get Priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @uses \EnumType\Priority::valueIsValid()
     * @uses \EnumType\Priority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \StructType\DXPack
     */
    public function setPriority($priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Signed value
     * @return string|null
     */
    public function getSigned()
    {
        return $this->Signed;
    }
    /**
     * Set Signed value
     * @param string $signed
     * @return \StructType\DXPack
     */
    public function setSigned($signed = null)
    {
        $this->Signed = $signed;
        return $this;
    }
    /**
     * Get Documents value
     * @return \StructType\Documents|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \StructType\Documents $documents
     * @return \StructType\DXPack
     */
    public function setDocuments(\StructType\Documents $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Get Envelopes value
     * @return \StructType\Envelopes|null
     */
    public function getEnvelopes()
    {
        return $this->Envelopes;
    }
    /**
     * Set Envelopes value
     * @param \StructType\Envelopes $envelopes
     * @return \StructType\DXPack
     */
    public function setEnvelopes(\StructType\Envelopes $envelopes = null)
    {
        $this->Envelopes = $envelopes;
        return $this;
    }
    /**
     * Get Notes value
     * @return \StructType\DocNoteCollection|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param \StructType\DocNoteCollection $notes
     * @return \StructType\DXPack
     */
    public function setNotes(\StructType\DocNoteCollection $notes = null)
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \StructType\SignatureType $signature
     * @return \StructType\DXPack
     */
    public function setSignature(\StructType\SignatureType $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get origin_id value
     * @return string|null
     */
    public function getOrigin_id()
    {
        return $this->origin_id;
    }
    /**
     * Set origin_id value
     * @param string $origin_id
     * @return \StructType\DXPack
     */
    public function setOrigin_id($origin_id = null)
    {
        $this->origin_id = $origin_id;
        return $this;
    }
    /**
     * Get time_created value
     * @return string|null
     */
    public function getTime_created()
    {
        return $this->time_created;
    }
    /**
     * Set time_created value
     * @param string $time_created
     * @return \StructType\DXPack
     */
    public function setTime_created($time_created = null)
    {
        $this->time_created = $time_created;
        return $this;
    }
    /**
     * Get time_queued value
     * @return string|null
     */
    public function getTime_queued()
    {
        return $this->time_queued;
    }
    /**
     * Set time_queued value
     * @param string $time_queued
     * @return \StructType\DXPack
     */
    public function setTime_queued($time_queued = null)
    {
        $this->time_queued = $time_queued;
        return $this;
    }
    /**
     * Get reset value
     * @return bool|null
     */
    public function getReset()
    {
        return $this->reset;
    }
    /**
     * Set reset value
     * @param bool $reset
     * @return \StructType\DXPack
     */
    public function setReset($reset = null)
    {
        $this->reset = $reset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DXPack
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
