<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXDocumentResult StructType
 * Meta informations extracted from the WSDL
 * - type: tns:DXDocumentResult
 * @subpackage Structs
 */
class DXDocumentResult extends DXBlock
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус обработки документа
     * @var string
     */
    public $Status;
    /**
     * The DocRef
     * Meta informations extracted from the WSDL
     * - documentation: Ссылка на документ
     * @var \StructType\DocumentRef
     */
    public $DocRef;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - documentation: Состояние документа после обработки запроса | Статус документа
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $State;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - documentation: Информация об ошибке
     * @var \StructType\MessageEx
     */
    public $ErrorMessage;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The Document
     * @var \StructType\DocumentContainer
     */
    public $Document;
    /**
     * Constructor method for DXDocumentResult
     * @uses DXDocumentResult::setStatus()
     * @uses DXDocumentResult::setDocRef()
     * @uses DXDocumentResult::setState()
     * @uses DXDocumentResult::setErrorMessage()
     * @uses DXDocumentResult::setDocDate()
     * @uses DXDocumentResult::setDocNumber()
     * @uses DXDocumentResult::setDocument()
     * @param string $status
     * @param \StructType\DocumentRef $docRef
     * @param string $state
     * @param \StructType\MessageEx $errorMessage
     * @param string $docDate
     * @param string $docNumber
     * @param \StructType\DocumentContainer $document
     */
    public function __construct($status = null, \StructType\DocumentRef $docRef = null, $state = null, \StructType\MessageEx $errorMessage = null, $docDate = null, $docNumber = null, \StructType\DocumentContainer $document = null)
    {
        $this
            ->setStatus($status)
            ->setDocRef($docRef)
            ->setState($state)
            ->setErrorMessage($errorMessage)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setDocument($document);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ProcessResult::valueIsValid()
     * @uses \EnumType\ProcessResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\DXDocumentResult
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get DocRef value
     * @return \StructType\DocumentRef|null
     */
    public function getDocRef()
    {
        return $this->DocRef;
    }
    /**
     * Set DocRef value
     * @param \StructType\DocumentRef $docRef
     * @return \StructType\DXDocumentResult
     */
    public function setDocRef(\StructType\DocumentRef $docRef = null)
    {
        $this->DocRef = $docRef;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\DXDocumentResult
     */
    public function setState($state = null)
    {
        $this->State = $state;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return \StructType\MessageEx|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param \StructType\MessageEx $errorMessage
     * @return \StructType\DXDocumentResult
     */
    public function setErrorMessage(\StructType\MessageEx $errorMessage = null)
    {
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\DXDocumentResult
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\DXDocumentResult
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\DocumentContainer|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \StructType\DocumentContainer $document
     * @return \StructType\DXDocumentResult
     */
    public function setDocument(\StructType\DocumentContainer $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DXDocumentResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
