<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrimeRegistryQuery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос на получение сведений из реестра розыска подозреваемых в преступлениях
 * - type: tns:CrimeRegistryQuery
 * @subpackage Structs
 */
class CrimeRegistryQuery extends RequestByDatum
{
    /**
     * The CrimeSuspect
     * Meta informations extracted from the WSDL
     * - documentation: Лицо, подозреваемое в совершении преступления | Сведения о лице, подозреваемом в совершении преступления. При передаче
     * сведений в обязательном порядке необходимо заполнить такие поля физическому лицу, как: Тип контрагента, Наименование контрагента, ФИО
     * контрагента, Дата рождения контрагента, Год рождения контрагента. Дополнительные необязательные поля: Место рождения контрагента,
     * Номер документа, Тип документа, удостоверяющего личность.
     * @var \StructType\ContragentDatumType
     */
    public $CrimeSuspect;
    /**
     * Constructor method for CrimeRegistryQuery
     * @uses CrimeRegistryQuery::setCrimeSuspect()
     * @param \StructType\ContragentDatumType $crimeSuspect
     */
    public function __construct(\StructType\ContragentDatumType $crimeSuspect = null)
    {
        $this
            ->setCrimeSuspect($crimeSuspect);
    }
    /**
     * Get CrimeSuspect value
     * @return \StructType\ContragentDatumType|null
     */
    public function getCrimeSuspect()
    {
        return $this->CrimeSuspect;
    }
    /**
     * Set CrimeSuspect value
     * @param \StructType\ContragentDatumType $crimeSuspect
     * @return \StructType\CrimeRegistryQuery
     */
    public function setCrimeSuspect(\StructType\ContragentDatumType $crimeSuspect = null)
    {
        $this->CrimeSuspect = $crimeSuspect;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CrimeRegistryQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
