<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrimeRegistryInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Выписка из реестра розыска подозреваемых в преступлениях | ЭП
 * - type: tns:CrimeRegistryInfo
 * @subpackage Structs
 */
class CrimeRegistryInfo extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор документа, присвоенный АИС ФССП России. | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The QueryExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор запроса (значение поля ExternalKey), переданного ранее в ФССП России. | Идентификатор
     * объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $QueryExternalKey;
    /**
     * The isActInfo
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия сведений | Признак наличия сведений из реестра розыска подозреваемых в преступлениях. | Обертка стандартного
     * xs:boolean | Логический
     * @var bool
     */
    public $isActInfo;
    /**
     * The Detail
     * Meta informations extracted from the WSDL
     * - documentation: Состав выписки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CrimeRegistryDetail[]
     */
    public $Detail;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for CrimeRegistryInfo
     * @uses CrimeRegistryInfo::setInternalKey()
     * @uses CrimeRegistryInfo::setQueryExternalKey()
     * @uses CrimeRegistryInfo::setIsActInfo()
     * @uses CrimeRegistryInfo::setDetail()
     * @uses CrimeRegistryInfo::setSignDateTime()
     * @uses CrimeRegistryInfo::setSignature()
     * @uses CrimeRegistryInfo::setId()
     * @param int $internalKey
     * @param string $queryExternalKey
     * @param bool $isActInfo
     * @param \StructType\CrimeRegistryDetail[] $detail
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $queryExternalKey = null, $isActInfo = null, array $detail = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setQueryExternalKey($queryExternalKey)
            ->setIsActInfo($isActInfo)
            ->setDetail($detail)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\CrimeRegistryInfo
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get QueryExternalKey value
     * @return string|null
     */
    public function getQueryExternalKey()
    {
        return $this->QueryExternalKey;
    }
    /**
     * Set QueryExternalKey value
     * @param string $queryExternalKey
     * @return \StructType\CrimeRegistryInfo
     */
    public function setQueryExternalKey($queryExternalKey = null)
    {
        $this->QueryExternalKey = $queryExternalKey;
        return $this;
    }
    /**
     * Get isActInfo value
     * @return bool|null
     */
    public function getIsActInfo()
    {
        return $this->isActInfo;
    }
    /**
     * Set isActInfo value
     * @param bool $isActInfo
     * @return \StructType\CrimeRegistryInfo
     */
    public function setIsActInfo($isActInfo = null)
    {
        $this->isActInfo = $isActInfo;
        return $this;
    }
    /**
     * Get Detail value
     * @return \StructType\CrimeRegistryDetail[]|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @throws \InvalidArgumentException
     * @param \StructType\CrimeRegistryDetail[] $detail
     * @return \StructType\CrimeRegistryInfo
     */
    public function setDetail(array $detail = array())
    {
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Add item to Detail value
     * @throws \InvalidArgumentException
     * @param \StructType\CrimeRegistryDetail $item
     * @return \StructType\CrimeRegistryInfo
     */
    public function addToDetail(\StructType\CrimeRegistryDetail $item)
    {
        $this->Detail[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\CrimeRegistryInfo
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\CrimeRegistryInfo
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\CrimeRegistryInfo
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\CrimeRegistryInfo
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CrimeRegistryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
