<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrimeRegistryDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Выписка из реестра розыска подозреваемых в преступлениях
 * - type: tns:CrimeRegistryDetail
 * @subpackage Structs
 */
class CrimeRegistryDetail extends AbstractStructBase
{
    /**
     * The OSPName
     * Meta informations extracted from the WSDL
     * - documentation: Террорган | Наименование ОСП по справочнику ВКСП. | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OSPName;
    /**
     * The CrimeName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО подозреваемого | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $CrimeName;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения подозреваемого | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BirthDate;
    /**
     * The BirthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения подозреваемого | Место рождения контрагента-физического лица. | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $BirthPlace;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Место регистрации подозреваемого
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * The DistinguishingCharacteristics
     * Meta informations extracted from the WSDL
     * - documentation: Особые приметы и иные сведения | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $DistinguishingCharacteristics;
    /**
     * The InitiatorName
     * Meta informations extracted from the WSDL
     * - documentation: Орган, инициирующий розыск | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $InitiatorName;
    /**
     * The ContactInformation
     * Meta informations extracted from the WSDL
     * - documentation: Контактная информация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ContactInformation;
    /**
     * The DateDecreeInvestigation
     * Meta informations extracted from the WSDL
     * - documentation: Дата вынесения постановления о розыске | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDecreeInvestigation;
    /**
     * The InvestigationDepartment
     * Meta informations extracted from the WSDL
     * - documentation: Госорган, осуществляющий розыск | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $InvestigationDepartment;
    /**
     * The CriminalCase
     * Meta informations extracted from the WSDL
     * - documentation: Номер дела | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $CriminalCase;
    /**
     * The DateCriminalCase
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждение дела | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateCriminalCase;
    /**
     * The ArrestLocally
     * Meta informations extracted from the WSDL
     * - documentation: Статья УК РФ | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $ArrestLocally;
    /**
     * The Pre_trialRestrictions
     * Meta informations extracted from the WSDL
     * - documentation: Мера пресечения | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Pre_trialRestrictions;
    /**
     * Constructor method for CrimeRegistryDetail
     * @uses CrimeRegistryDetail::setOSPName()
     * @uses CrimeRegistryDetail::setCrimeName()
     * @uses CrimeRegistryDetail::setBirthDate()
     * @uses CrimeRegistryDetail::setBirthPlace()
     * @uses CrimeRegistryDetail::setAddress()
     * @uses CrimeRegistryDetail::setDistinguishingCharacteristics()
     * @uses CrimeRegistryDetail::setInitiatorName()
     * @uses CrimeRegistryDetail::setContactInformation()
     * @uses CrimeRegistryDetail::setDateDecreeInvestigation()
     * @uses CrimeRegistryDetail::setInvestigationDepartment()
     * @uses CrimeRegistryDetail::setCriminalCase()
     * @uses CrimeRegistryDetail::setDateCriminalCase()
     * @uses CrimeRegistryDetail::setArrestLocally()
     * @uses CrimeRegistryDetail::setPre_trialRestrictions()
     * @param string $oSPName
     * @param string $crimeName
     * @param string $birthDate
     * @param string $birthPlace
     * @param \StructType\AddressType $address
     * @param string $distinguishingCharacteristics
     * @param string $initiatorName
     * @param string $contactInformation
     * @param string $dateDecreeInvestigation
     * @param string $investigationDepartment
     * @param string $criminalCase
     * @param string $dateCriminalCase
     * @param string $arrestLocally
     * @param string $pre_trialRestrictions
     */
    public function __construct($oSPName = null, $crimeName = null, $birthDate = null, $birthPlace = null, \StructType\AddressType $address = null, $distinguishingCharacteristics = null, $initiatorName = null, $contactInformation = null, $dateDecreeInvestigation = null, $investigationDepartment = null, $criminalCase = null, $dateCriminalCase = null, $arrestLocally = null, $pre_trialRestrictions = null)
    {
        $this
            ->setOSPName($oSPName)
            ->setCrimeName($crimeName)
            ->setBirthDate($birthDate)
            ->setBirthPlace($birthPlace)
            ->setAddress($address)
            ->setDistinguishingCharacteristics($distinguishingCharacteristics)
            ->setInitiatorName($initiatorName)
            ->setContactInformation($contactInformation)
            ->setDateDecreeInvestigation($dateDecreeInvestigation)
            ->setInvestigationDepartment($investigationDepartment)
            ->setCriminalCase($criminalCase)
            ->setDateCriminalCase($dateCriminalCase)
            ->setArrestLocally($arrestLocally)
            ->setPre_trialRestrictions($pre_trialRestrictions);
    }
    /**
     * Get OSPName value
     * @return string|null
     */
    public function getOSPName()
    {
        return $this->OSPName;
    }
    /**
     * Set OSPName value
     * @param string $oSPName
     * @return \StructType\CrimeRegistryDetail
     */
    public function setOSPName($oSPName = null)
    {
        $this->OSPName = $oSPName;
        return $this;
    }
    /**
     * Get CrimeName value
     * @return string|null
     */
    public function getCrimeName()
    {
        return $this->CrimeName;
    }
    /**
     * Set CrimeName value
     * @param string $crimeName
     * @return \StructType\CrimeRegistryDetail
     */
    public function setCrimeName($crimeName = null)
    {
        $this->CrimeName = $crimeName;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\CrimeRegistryDetail
     */
    public function setBirthDate($birthDate = null)
    {
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get BirthPlace value
     * @return string|null
     */
    public function getBirthPlace()
    {
        return $this->BirthPlace;
    }
    /**
     * Set BirthPlace value
     * @param string $birthPlace
     * @return \StructType\CrimeRegistryDetail
     */
    public function setBirthPlace($birthPlace = null)
    {
        $this->BirthPlace = $birthPlace;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\CrimeRegistryDetail
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get DistinguishingCharacteristics value
     * @return string|null
     */
    public function getDistinguishingCharacteristics()
    {
        return $this->DistinguishingCharacteristics;
    }
    /**
     * Set DistinguishingCharacteristics value
     * @param string $distinguishingCharacteristics
     * @return \StructType\CrimeRegistryDetail
     */
    public function setDistinguishingCharacteristics($distinguishingCharacteristics = null)
    {
        $this->DistinguishingCharacteristics = $distinguishingCharacteristics;
        return $this;
    }
    /**
     * Get InitiatorName value
     * @return string|null
     */
    public function getInitiatorName()
    {
        return $this->InitiatorName;
    }
    /**
     * Set InitiatorName value
     * @param string $initiatorName
     * @return \StructType\CrimeRegistryDetail
     */
    public function setInitiatorName($initiatorName = null)
    {
        $this->InitiatorName = $initiatorName;
        return $this;
    }
    /**
     * Get ContactInformation value
     * @return string|null
     */
    public function getContactInformation()
    {
        return $this->ContactInformation;
    }
    /**
     * Set ContactInformation value
     * @param string $contactInformation
     * @return \StructType\CrimeRegistryDetail
     */
    public function setContactInformation($contactInformation = null)
    {
        $this->ContactInformation = $contactInformation;
        return $this;
    }
    /**
     * Get DateDecreeInvestigation value
     * @return string|null
     */
    public function getDateDecreeInvestigation()
    {
        return $this->DateDecreeInvestigation;
    }
    /**
     * Set DateDecreeInvestigation value
     * @param string $dateDecreeInvestigation
     * @return \StructType\CrimeRegistryDetail
     */
    public function setDateDecreeInvestigation($dateDecreeInvestigation = null)
    {
        $this->DateDecreeInvestigation = $dateDecreeInvestigation;
        return $this;
    }
    /**
     * Get InvestigationDepartment value
     * @return string|null
     */
    public function getInvestigationDepartment()
    {
        return $this->InvestigationDepartment;
    }
    /**
     * Set InvestigationDepartment value
     * @param string $investigationDepartment
     * @return \StructType\CrimeRegistryDetail
     */
    public function setInvestigationDepartment($investigationDepartment = null)
    {
        $this->InvestigationDepartment = $investigationDepartment;
        return $this;
    }
    /**
     * Get CriminalCase value
     * @return string|null
     */
    public function getCriminalCase()
    {
        return $this->CriminalCase;
    }
    /**
     * Set CriminalCase value
     * @param string $criminalCase
     * @return \StructType\CrimeRegistryDetail
     */
    public function setCriminalCase($criminalCase = null)
    {
        $this->CriminalCase = $criminalCase;
        return $this;
    }
    /**
     * Get DateCriminalCase value
     * @return string|null
     */
    public function getDateCriminalCase()
    {
        return $this->DateCriminalCase;
    }
    /**
     * Set DateCriminalCase value
     * @param string $dateCriminalCase
     * @return \StructType\CrimeRegistryDetail
     */
    public function setDateCriminalCase($dateCriminalCase = null)
    {
        $this->DateCriminalCase = $dateCriminalCase;
        return $this;
    }
    /**
     * Get ArrestLocally value
     * @return string|null
     */
    public function getArrestLocally()
    {
        return $this->ArrestLocally;
    }
    /**
     * Set ArrestLocally value
     * @param string $arrestLocally
     * @return \StructType\CrimeRegistryDetail
     */
    public function setArrestLocally($arrestLocally = null)
    {
        $this->ArrestLocally = $arrestLocally;
        return $this;
    }
    /**
     * Get Pre_trialRestrictions value
     * @return string|null
     */
    public function getPre_trialRestrictions()
    {
        return $this->{'Pre-trialRestrictions'};
    }
    /**
     * Set Pre_trialRestrictions value
     * @param string $pre_trialRestrictions
     * @return \StructType\CrimeRegistryDetail
     */
    public function setPre_trialRestrictions($pre_trialRestrictions = null)
    {
        $this->Pre_trialRestrictions = $this->{'Pre-trialRestrictions'} = $pre_trialRestrictions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CrimeRegistryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
