<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CitizenQuestionsResData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные по вопросам из обращений граждан | ЭП
 * @subpackage Structs
 */
class CitizenQuestionsResData extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус обращения
     * @var string
     */
    public $Status;
    /**
     * The RegDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegDate;
    /**
     * The RegDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $RegDocNumber;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела записи | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The ForwardOspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения пересылки | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ForwardOspCode;
    /**
     * The ForwardDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата пересылки | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ForwardDate;
    /**
     * The ForwardNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер исходящего о пересылке | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ForwardNum;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Текст уведомления | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Text;
    /**
     * The AnswerDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ответа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AnswerDate;
    /**
     * The AnswerRegDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер ответа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $AnswerRegDocNumber;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for CitizenQuestionsResData
     * @uses CitizenQuestionsResData::setInternalKey()
     * @uses CitizenQuestionsResData::setStatus()
     * @uses CitizenQuestionsResData::setRegDate()
     * @uses CitizenQuestionsResData::setRegDocNumber()
     * @uses CitizenQuestionsResData::setOspCode()
     * @uses CitizenQuestionsResData::setForwardOspCode()
     * @uses CitizenQuestionsResData::setForwardDate()
     * @uses CitizenQuestionsResData::setForwardNum()
     * @uses CitizenQuestionsResData::setText()
     * @uses CitizenQuestionsResData::setAnswerDate()
     * @uses CitizenQuestionsResData::setAnswerRegDocNumber()
     * @uses CitizenQuestionsResData::setSignature()
     * @uses CitizenQuestionsResData::setId()
     * @param int $internalKey
     * @param string $status
     * @param string $regDate
     * @param string $regDocNumber
     * @param string $ospCode
     * @param string $forwardOspCode
     * @param string $forwardDate
     * @param string $forwardNum
     * @param string $text
     * @param string $answerDate
     * @param string $answerRegDocNumber
     * @param \StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $status = null, $regDate = null, $regDocNumber = null, $ospCode = null, $forwardOspCode = null, $forwardDate = null, $forwardNum = null, $text = null, $answerDate = null, $answerRegDocNumber = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setStatus($status)
            ->setRegDate($regDate)
            ->setRegDocNumber($regDocNumber)
            ->setOspCode($ospCode)
            ->setForwardOspCode($forwardOspCode)
            ->setForwardDate($forwardDate)
            ->setForwardNum($forwardNum)
            ->setText($text)
            ->setAnswerDate($answerDate)
            ->setAnswerRegDocNumber($answerRegDocNumber)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\CitizenQuestionsResData
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\TreatmentStatusCode::valueIsValid()
     * @uses \EnumType\TreatmentStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\CitizenQuestionsResData
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get RegDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->RegDate;
    }
    /**
     * Set RegDate value
     * @param string $regDate
     * @return \StructType\CitizenQuestionsResData
     */
    public function setRegDate($regDate = null)
    {
        $this->RegDate = $regDate;
        return $this;
    }
    /**
     * Get RegDocNumber value
     * @return string|null
     */
    public function getRegDocNumber()
    {
        return $this->RegDocNumber;
    }
    /**
     * Set RegDocNumber value
     * @param string $regDocNumber
     * @return \StructType\CitizenQuestionsResData
     */
    public function setRegDocNumber($regDocNumber = null)
    {
        $this->RegDocNumber = $regDocNumber;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \StructType\CitizenQuestionsResData
     */
    public function setOspCode($ospCode = null)
    {
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get ForwardOspCode value
     * @return string|null
     */
    public function getForwardOspCode()
    {
        return $this->ForwardOspCode;
    }
    /**
     * Set ForwardOspCode value
     * @param string $forwardOspCode
     * @return \StructType\CitizenQuestionsResData
     */
    public function setForwardOspCode($forwardOspCode = null)
    {
        $this->ForwardOspCode = $forwardOspCode;
        return $this;
    }
    /**
     * Get ForwardDate value
     * @return string|null
     */
    public function getForwardDate()
    {
        return $this->ForwardDate;
    }
    /**
     * Set ForwardDate value
     * @param string $forwardDate
     * @return \StructType\CitizenQuestionsResData
     */
    public function setForwardDate($forwardDate = null)
    {
        $this->ForwardDate = $forwardDate;
        return $this;
    }
    /**
     * Get ForwardNum value
     * @return string|null
     */
    public function getForwardNum()
    {
        return $this->ForwardNum;
    }
    /**
     * Set ForwardNum value
     * @param string $forwardNum
     * @return \StructType\CitizenQuestionsResData
     */
    public function setForwardNum($forwardNum = null)
    {
        $this->ForwardNum = $forwardNum;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\CitizenQuestionsResData
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get AnswerDate value
     * @return string|null
     */
    public function getAnswerDate()
    {
        return $this->AnswerDate;
    }
    /**
     * Set AnswerDate value
     * @param string $answerDate
     * @return \StructType\CitizenQuestionsResData
     */
    public function setAnswerDate($answerDate = null)
    {
        $this->AnswerDate = $answerDate;
        return $this;
    }
    /**
     * Get AnswerRegDocNumber value
     * @return string|null
     */
    public function getAnswerRegDocNumber()
    {
        return $this->AnswerRegDocNumber;
    }
    /**
     * Set AnswerRegDocNumber value
     * @param string $answerRegDocNumber
     * @return \StructType\CitizenQuestionsResData
     */
    public function setAnswerRegDocNumber($answerRegDocNumber = null)
    {
        $this->AnswerRegDocNumber = $answerRegDocNumber;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\CitizenQuestionsResData
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\CitizenQuestionsResData
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\CitizenQuestionsResData
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CitizenQuestionsResData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
