<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CertificateDeliveryAcceptance StructType
 * Meta informations extracted from the WSDL
 * - documentation: Акт приема-передачи арестованного имущества | ЭП
 * - type: tns:CertificateDeliveryAcceptance
 * @subpackage Structs
 */
class CertificateDeliveryAcceptance extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Идентификатор АИС ФССП России. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании
     * объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента. | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DocNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер отчета | Номер отчета о результатах реализации арестованного имущества. | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNum;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата отчета | Дата отчета о результатах реализации арестованного имущества. | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The ProcDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ постановления | Ключ постановления судебного пристава-исполнителя о передачи арестованного имущества должника на
     * реализацию. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $ProcDocId;
    /**
     * The CertificateDeliveryAcceptanceBase
     * Meta informations extracted from the WSDL
     * - documentation: Акт | Оригинал акта приема-передачи арестованного имущества вынесенного в электронном виде согласно формату Приложения № X
     * «Формат постановления должностного лица ФССП России, выданного в виде электронного документа, юридическая значимость которого
     * подтверждена электронной подписью в порядке, установленном законодательством Российской Федерации» в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $CertificateDeliveryAcceptanceBase;
    /**
     * The SignatureCertificateDeliveryAcceptanceBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП уведомления | ЭП акта приема-передачи арестованного имущества вынесенного в электронном виде, элемента «CertificateDeliveryAcceptanceBase»
     * в формате pkcs#7, в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $SignatureCertificateDeliveryAcceptanceBase;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Приложенные файлы | Дополнительные данные в произвольных форматах.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for CertificateDeliveryAcceptance
     * @uses CertificateDeliveryAcceptance::setInternalKey()
     * @uses CertificateDeliveryAcceptance::setExternalKey()
     * @uses CertificateDeliveryAcceptance::setDocNum()
     * @uses CertificateDeliveryAcceptance::setDocDate()
     * @uses CertificateDeliveryAcceptance::setProcDocId()
     * @uses CertificateDeliveryAcceptance::setCertificateDeliveryAcceptanceBase()
     * @uses CertificateDeliveryAcceptance::setSignatureCertificateDeliveryAcceptanceBase()
     * @uses CertificateDeliveryAcceptance::setAttachments()
     * @uses CertificateDeliveryAcceptance::setSignDateTime()
     * @uses CertificateDeliveryAcceptance::setSignature()
     * @param int $internalKey
     * @param string $externalKey
     * @param string $docNum
     * @param string $docDate
     * @param int $procDocId
     * @param string $certificateDeliveryAcceptanceBase
     * @param string $signatureCertificateDeliveryAcceptanceBase
     * @param \StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct($internalKey = null, $externalKey = null, $docNum = null, $docDate = null, $procDocId = null, $certificateDeliveryAcceptanceBase = null, $signatureCertificateDeliveryAcceptanceBase = null, array $attachments = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setExternalKey($externalKey)
            ->setDocNum($docNum)
            ->setDocDate($docDate)
            ->setProcDocId($procDocId)
            ->setCertificateDeliveryAcceptanceBase($certificateDeliveryAcceptanceBase)
            ->setSignatureCertificateDeliveryAcceptanceBase($signatureCertificateDeliveryAcceptanceBase)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function setExternalKey($externalKey = null)
    {
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DocNum value
     * @return string|null
     */
    public function getDocNum()
    {
        return $this->DocNum;
    }
    /**
     * Set DocNum value
     * @param string $docNum
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function setDocNum($docNum = null)
    {
        $this->DocNum = $docNum;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function setDocDate($docDate = null)
    {
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get ProcDocId value
     * @return int|null
     */
    public function getProcDocId()
    {
        return $this->ProcDocId;
    }
    /**
     * Set ProcDocId value
     * @param int $procDocId
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function setProcDocId($procDocId = null)
    {
        $this->ProcDocId = $procDocId;
        return $this;
    }
    /**
     * Get CertificateDeliveryAcceptanceBase value
     * @return string|null
     */
    public function getCertificateDeliveryAcceptanceBase()
    {
        return $this->CertificateDeliveryAcceptanceBase;
    }
    /**
     * Set CertificateDeliveryAcceptanceBase value
     * @param string $certificateDeliveryAcceptanceBase
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function setCertificateDeliveryAcceptanceBase($certificateDeliveryAcceptanceBase = null)
    {
        $this->CertificateDeliveryAcceptanceBase = $certificateDeliveryAcceptanceBase;
        return $this;
    }
    /**
     * Get SignatureCertificateDeliveryAcceptanceBase value
     * @return string|null
     */
    public function getSignatureCertificateDeliveryAcceptanceBase()
    {
        return $this->SignatureCertificateDeliveryAcceptanceBase;
    }
    /**
     * Set SignatureCertificateDeliveryAcceptanceBase value
     * @param string $signatureCertificateDeliveryAcceptanceBase
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function setSignatureCertificateDeliveryAcceptanceBase($signatureCertificateDeliveryAcceptanceBase = null)
    {
        $this->SignatureCertificateDeliveryAcceptanceBase = $signatureCertificateDeliveryAcceptanceBase;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType[] $attachments
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function setAttachments(array $attachments = array())
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentType $item
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function addToAttachments(\StructType\AttachmentType $item)
    {
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CertificateDeliveryAcceptance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
