<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashLetterDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о периодических выплатах, зачислениях
 * @subpackage Structs
 */
class CashLetterDatumType extends InformationType
{
    /**
     * The CashLetter
     * Meta informations extracted from the WSDL
     * - documentation: Вид зачисления
     * @var string
     */
    public $CashLetter;
    /**
     * The TextCashLetter
     * Meta informations extracted from the WSDL
     * - documentation: Наименование зачисления | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $TextCashLetter;
    /**
     * The CashStartDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $CashStartDate;
    /**
     * The CashFinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $CashFinDate;
    /**
     * The PaymentPeriod
     * Meta informations extracted from the WSDL
     * - documentation: Периодичность зачисления
     * - minOccurs: 0
     * @var string
     */
    public $PaymentPeriod;
    /**
     * The NamePaymentPeriod
     * Meta informations extracted from the WSDL
     * - documentation: Наименование периодичности | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $NamePaymentPeriod;
    /**
     * The Outpayments
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Outpayments;
    /**
     * The AccessDrawingFacilities
     * Meta informations extracted from the WSDL
     * - documentation: Порядок получения
     * @var string
     */
    public $AccessDrawingFacilities;
    /**
     * The NameAccessDrawingFacilities
     * Meta informations extracted from the WSDL
     * - documentation: Наименование порядка получения | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $NameAccessDrawingFacilities;
    /**
     * The Grounds
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительная информация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Grounds;
    /**
     * Constructor method for CashLetterDatumType
     * @uses CashLetterDatumType::setCashLetter()
     * @uses CashLetterDatumType::setTextCashLetter()
     * @uses CashLetterDatumType::setCashStartDate()
     * @uses CashLetterDatumType::setCashFinDate()
     * @uses CashLetterDatumType::setPaymentPeriod()
     * @uses CashLetterDatumType::setNamePaymentPeriod()
     * @uses CashLetterDatumType::setOutpayments()
     * @uses CashLetterDatumType::setAccessDrawingFacilities()
     * @uses CashLetterDatumType::setNameAccessDrawingFacilities()
     * @uses CashLetterDatumType::setGrounds()
     * @param string $cashLetter
     * @param string $textCashLetter
     * @param string $cashStartDate
     * @param string $cashFinDate
     * @param string $paymentPeriod
     * @param string $namePaymentPeriod
     * @param float $outpayments
     * @param string $accessDrawingFacilities
     * @param string $nameAccessDrawingFacilities
     * @param string $grounds
     */
    public function __construct($cashLetter = null, $textCashLetter = null, $cashStartDate = null, $cashFinDate = null, $paymentPeriod = null, $namePaymentPeriod = null, $outpayments = null, $accessDrawingFacilities = null, $nameAccessDrawingFacilities = null, $grounds = null)
    {
        $this
            ->setCashLetter($cashLetter)
            ->setTextCashLetter($textCashLetter)
            ->setCashStartDate($cashStartDate)
            ->setCashFinDate($cashFinDate)
            ->setPaymentPeriod($paymentPeriod)
            ->setNamePaymentPeriod($namePaymentPeriod)
            ->setOutpayments($outpayments)
            ->setAccessDrawingFacilities($accessDrawingFacilities)
            ->setNameAccessDrawingFacilities($nameAccessDrawingFacilities)
            ->setGrounds($grounds);
    }
    /**
     * Get CashLetter value
     * @return string|null
     */
    public function getCashLetter()
    {
        return $this->CashLetter;
    }
    /**
     * Set CashLetter value
     * @uses \EnumType\CashLetterType::valueIsValid()
     * @uses \EnumType\CashLetterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cashLetter
     * @return \StructType\CashLetterDatumType
     */
    public function setCashLetter($cashLetter = null)
    {
        $this->CashLetter = $cashLetter;
        return $this;
    }
    /**
     * Get TextCashLetter value
     * @return string|null
     */
    public function getTextCashLetter()
    {
        return $this->TextCashLetter;
    }
    /**
     * Set TextCashLetter value
     * @param string $textCashLetter
     * @return \StructType\CashLetterDatumType
     */
    public function setTextCashLetter($textCashLetter = null)
    {
        $this->TextCashLetter = $textCashLetter;
        return $this;
    }
    /**
     * Get CashStartDate value
     * @return string|null
     */
    public function getCashStartDate()
    {
        return $this->CashStartDate;
    }
    /**
     * Set CashStartDate value
     * @param string $cashStartDate
     * @return \StructType\CashLetterDatumType
     */
    public function setCashStartDate($cashStartDate = null)
    {
        $this->CashStartDate = $cashStartDate;
        return $this;
    }
    /**
     * Get CashFinDate value
     * @return string|null
     */
    public function getCashFinDate()
    {
        return $this->CashFinDate;
    }
    /**
     * Set CashFinDate value
     * @param string $cashFinDate
     * @return \StructType\CashLetterDatumType
     */
    public function setCashFinDate($cashFinDate = null)
    {
        $this->CashFinDate = $cashFinDate;
        return $this;
    }
    /**
     * Get PaymentPeriod value
     * @return string|null
     */
    public function getPaymentPeriod()
    {
        return $this->PaymentPeriod;
    }
    /**
     * Set PaymentPeriod value
     * @uses \EnumType\PaymentPeriodType::valueIsValid()
     * @uses \EnumType\PaymentPeriodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentPeriod
     * @return \StructType\CashLetterDatumType
     */
    public function setPaymentPeriod($paymentPeriod = null)
    {
        $this->PaymentPeriod = $paymentPeriod;
        return $this;
    }
    /**
     * Get NamePaymentPeriod value
     * @return string|null
     */
    public function getNamePaymentPeriod()
    {
        return $this->NamePaymentPeriod;
    }
    /**
     * Set NamePaymentPeriod value
     * @param string $namePaymentPeriod
     * @return \StructType\CashLetterDatumType
     */
    public function setNamePaymentPeriod($namePaymentPeriod = null)
    {
        $this->NamePaymentPeriod = $namePaymentPeriod;
        return $this;
    }
    /**
     * Get Outpayments value
     * @return float|null
     */
    public function getOutpayments()
    {
        return $this->Outpayments;
    }
    /**
     * Set Outpayments value
     * @param float $outpayments
     * @return \StructType\CashLetterDatumType
     */
    public function setOutpayments($outpayments = null)
    {
        $this->Outpayments = $outpayments;
        return $this;
    }
    /**
     * Get AccessDrawingFacilities value
     * @return string|null
     */
    public function getAccessDrawingFacilities()
    {
        return $this->AccessDrawingFacilities;
    }
    /**
     * Set AccessDrawingFacilities value
     * @uses \EnumType\AccessDrawingFacilitiesType::valueIsValid()
     * @uses \EnumType\AccessDrawingFacilitiesType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessDrawingFacilities
     * @return \StructType\CashLetterDatumType
     */
    public function setAccessDrawingFacilities($accessDrawingFacilities = null)
    {
        $this->AccessDrawingFacilities = $accessDrawingFacilities;
        return $this;
    }
    /**
     * Get NameAccessDrawingFacilities value
     * @return string|null
     */
    public function getNameAccessDrawingFacilities()
    {
        return $this->NameAccessDrawingFacilities;
    }
    /**
     * Set NameAccessDrawingFacilities value
     * @param string $nameAccessDrawingFacilities
     * @return \StructType\CashLetterDatumType
     */
    public function setNameAccessDrawingFacilities($nameAccessDrawingFacilities = null)
    {
        $this->NameAccessDrawingFacilities = $nameAccessDrawingFacilities;
        return $this;
    }
    /**
     * Get Grounds value
     * @return string|null
     */
    public function getGrounds()
    {
        return $this->Grounds;
    }
    /**
     * Set Grounds value
     * @param string $grounds
     * @return \StructType\CashLetterDatumType
     */
    public function setGrounds($grounds = null)
    {
        $this->Grounds = $grounds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CashLetterDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
