<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CaAnswer StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ ВУЦ | ЭП
 * - type: tns:CaAnswer
 * @subpackage Structs
 */
class CaAnswer extends AbstractStructBase
{
    /**
     * The externalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ВУЦ | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $externalKey;
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $requestKey;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ответа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ответа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The answerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ответа ВУЦ | Тип ответа ВУЦ
     * - length: 2
     * @var string
     */
    public $answerType;
    /**
     * The certificate
     * Meta informations extracted from the WSDL
     * - documentation: Сертификат | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $certificate;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for CaAnswer
     * @uses CaAnswer::setExternalKey()
     * @uses CaAnswer::setRequestKey()
     * @uses CaAnswer::setDocNumber()
     * @uses CaAnswer::setDocDate()
     * @uses CaAnswer::setAnswerType()
     * @uses CaAnswer::setCertificate()
     * @uses CaAnswer::setSignDateTime()
     * @uses CaAnswer::setSignature()
     * @param string $externalKey
     * @param int $requestKey
     * @param string $docNumber
     * @param string $docDate
     * @param string $answerType
     * @param string $certificate
     * @param string $signDateTime
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct($externalKey = null, $requestKey = null, $docNumber = null, $docDate = null, $answerType = null, $certificate = null, $signDateTime = null, array $signature = array())
    {
        $this
            ->setExternalKey($externalKey)
            ->setRequestKey($requestKey)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setAnswerType($answerType)
            ->setCertificate($certificate)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get externalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->externalKey;
    }
    /**
     * Set externalKey value
     * @param string $externalKey
     * @return \StructType\CaAnswer
     */
    public function setExternalKey($externalKey = null)
    {
        $this->externalKey = $externalKey;
        return $this;
    }
    /**
     * Get requestKey value
     * @return int|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param int $requestKey
     * @return \StructType\CaAnswer
     */
    public function setRequestKey($requestKey = null)
    {
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \StructType\CaAnswer
     */
    public function setDocNumber($docNumber = null)
    {
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \StructType\CaAnswer
     */
    public function setDocDate($docDate = null)
    {
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get answerType value
     * @return string|null
     */
    public function getAnswerType()
    {
        return $this->answerType;
    }
    /**
     * Set answerType value
     * @param string $answerType
     * @return \StructType\CaAnswer
     */
    public function setAnswerType($answerType = null)
    {
        $this->answerType = $answerType;
        return $this;
    }
    /**
     * Get certificate value
     * @return string|null
     */
    public function getCertificate()
    {
        return $this->certificate;
    }
    /**
     * Set certificate value
     * @param string $certificate
     * @return \StructType\CaAnswer
     */
    public function setCertificate($certificate = null)
    {
        $this->certificate = $certificate;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \StructType\CaAnswer
     */
    public function setSignDateTime($signDateTime = null)
    {
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\CaAnswer
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\CaAnswer
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CaAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
