<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BriefIPInformationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных BriefIPInformationType «Сокращенные сведения об ИП»
 * @subpackage Structs
 */
class BriefIPInformationType extends AbstractStructBase
{
    /**
     * The IPKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта
     * от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IPKey;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ИД
     * @var string
     */
    public $IDType;
    /**
     * The IDName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа ИД | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $IDName;
    /**
     * The IDOrgCode
     * Meta informations extracted from the WSDL
     * - documentation: Код органа, выдавшего ИД | Код организации | NSI_MVV_Organization
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $IDOrgCode;
    /**
     * The IDOrgName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование органа, выдавшего ИД | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDOrgName;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИД | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - documentation: Номер исполнительного производства | Строка длиной от 1 до 25 символов
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $number;
    /**
     * The riseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждения | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $riseDate;
    /**
     * The numberComposite
     * Meta informations extracted from the WSDL
     * - documentation: Номер сводного исполнительного производства | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $numberComposite;
    /**
     * The debtText
     * Meta informations extracted from the WSDL
     * - documentation: Предмет исполнения | Строка длиной от 1 до 200 символов
     * - minOccurs: 0
     * - maxLength: 200
     * - minLength: 1
     * @var string
     */
    public $debtText;
    /**
     * The debtorName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование должника | Строка длиной от 1 до 200 символов
     * - maxLength: 200
     * - minLength: 1
     * @var string
     */
    public $debtorName;
    /**
     * The debtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения должника | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $debtorBirthDate;
    /**
     * The debtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $debtorBirthYear;
    /**
     * The debtorBirthplace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения должника | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $debtorBirthplace;
    /**
     * The debtorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника ЮЛ | Строка длиной от 1 до 150 символов
     * - minOccurs: 0
     * - maxLength: 150
     * - minLength: 1
     * @var string
     */
    public $debtorAddress;
    /**
     * The debtSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма долга по ИД | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtSum;
    /**
     * The debtRestTotal
     * Meta informations extracted from the WSDL
     * - documentation: Остаток долга всего | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtRestTotal;
    /**
     * The debtRestIP
     * Meta informations extracted from the WSDL
     * - documentation: Остаток долга по ИП | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtRestIP;
    /**
     * The debtRestFine
     * Meta informations extracted from the WSDL
     * - documentation: Остаток долга по штрафу СПИ | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtRestFine;
    /**
     * The debtRestDuty
     * Meta informations extracted from the WSDL
     * - documentation: Остаток задолженности по исполнительскому сбору | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtRestDuty;
    /**
     * The debtRestOther
     * Meta informations extracted from the WSDL
     * - documentation: Остаток задолженности по расходам по исполнительским действиям | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtRestOther;
    /**
     * The IPEndDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата завершения ИП | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IPEndDate;
    /**
     * The IPEndArticle
     * Meta informations extracted from the WSDL
     * - documentation: Cтатья основание окончания ИП | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $IPEndArticle;
    /**
     * The IPEndPoint
     * Meta informations extracted from the WSDL
     * - documentation: Пункт основание окончания ИП | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $IPEndPoint;
    /**
     * The IPEndSubpoint
     * Meta informations extracted from the WSDL
     * - documentation: Подпункт основание окончания ИП | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $IPEndSubpoint;
    /**
     * The ospCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела судебных приставов | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ospCode;
    /**
     * The divName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование отдела судебных приставов | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $divName;
    /**
     * The divAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес отдела судебных приставов | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $divAdr;
    /**
     * The SPIShortName
     * Meta informations extracted from the WSDL
     * - documentation: Фамилия и инициалы судебного пристава-исполнителя | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $SPIShortName;
    /**
     * The SPITelephone
     * Meta informations extracted from the WSDL
     * - documentation: Телефон судебного пристава-исполнителя | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITelephone;
    /**
     * The actualityDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время актуальности данных | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $actualityDate;
    /**
     * The unifoChargeFssp
     * Meta informations extracted from the WSDL
     * - documentation: УИН ФССП | Код начисления УНИФО
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $unifoChargeFssp;
    /**
     * The unifoChargeExt
     * Meta informations extracted from the WSDL
     * - documentation: УИН Внешнего контрагента | Код начисления УНИФО
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $unifoChargeExt;
    /**
     * Constructor method for BriefIPInformationType
     * @uses BriefIPInformationType::setIPKey()
     * @uses BriefIPInformationType::setIDType()
     * @uses BriefIPInformationType::setIDName()
     * @uses BriefIPInformationType::setIDOrgCode()
     * @uses BriefIPInformationType::setIDOrgName()
     * @uses BriefIPInformationType::setIDNum()
     * @uses BriefIPInformationType::setIDDate()
     * @uses BriefIPInformationType::setNumber()
     * @uses BriefIPInformationType::setRiseDate()
     * @uses BriefIPInformationType::setNumberComposite()
     * @uses BriefIPInformationType::setDebtText()
     * @uses BriefIPInformationType::setDebtorName()
     * @uses BriefIPInformationType::setDebtorBirthDate()
     * @uses BriefIPInformationType::setDebtorBirthYear()
     * @uses BriefIPInformationType::setDebtorBirthplace()
     * @uses BriefIPInformationType::setDebtorAddress()
     * @uses BriefIPInformationType::setDebtSum()
     * @uses BriefIPInformationType::setDebtRestTotal()
     * @uses BriefIPInformationType::setDebtRestIP()
     * @uses BriefIPInformationType::setDebtRestFine()
     * @uses BriefIPInformationType::setDebtRestDuty()
     * @uses BriefIPInformationType::setDebtRestOther()
     * @uses BriefIPInformationType::setIPEndDate()
     * @uses BriefIPInformationType::setIPEndArticle()
     * @uses BriefIPInformationType::setIPEndPoint()
     * @uses BriefIPInformationType::setIPEndSubpoint()
     * @uses BriefIPInformationType::setOspCode()
     * @uses BriefIPInformationType::setDivName()
     * @uses BriefIPInformationType::setDivAdr()
     * @uses BriefIPInformationType::setSPIShortName()
     * @uses BriefIPInformationType::setSPITelephone()
     * @uses BriefIPInformationType::setActualityDate()
     * @uses BriefIPInformationType::setUnifoChargeFssp()
     * @uses BriefIPInformationType::setUnifoChargeExt()
     * @param int $iPKey
     * @param string $iDType
     * @param string $iDName
     * @param string $iDOrgCode
     * @param string $iDOrgName
     * @param string $iDNum
     * @param string $iDDate
     * @param string $number
     * @param string $riseDate
     * @param string $numberComposite
     * @param string $debtText
     * @param string $debtorName
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorBirthplace
     * @param string $debtorAddress
     * @param float $debtSum
     * @param float $debtRestTotal
     * @param float $debtRestIP
     * @param float $debtRestFine
     * @param float $debtRestDuty
     * @param float $debtRestOther
     * @param string $iPEndDate
     * @param string $iPEndArticle
     * @param string $iPEndPoint
     * @param string $iPEndSubpoint
     * @param string $ospCode
     * @param string $divName
     * @param string $divAdr
     * @param string $sPIShortName
     * @param string $sPITelephone
     * @param string $actualityDate
     * @param string $unifoChargeFssp
     * @param string $unifoChargeExt
     */
    public function __construct($iPKey = null, $iDType = null, $iDName = null, $iDOrgCode = null, $iDOrgName = null, $iDNum = null, $iDDate = null, $number = null, $riseDate = null, $numberComposite = null, $debtText = null, $debtorName = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorBirthplace = null, $debtorAddress = null, $debtSum = null, $debtRestTotal = null, $debtRestIP = null, $debtRestFine = null, $debtRestDuty = null, $debtRestOther = null, $iPEndDate = null, $iPEndArticle = null, $iPEndPoint = null, $iPEndSubpoint = null, $ospCode = null, $divName = null, $divAdr = null, $sPIShortName = null, $sPITelephone = null, $actualityDate = null, $unifoChargeFssp = null, $unifoChargeExt = null)
    {
        $this
            ->setIPKey($iPKey)
            ->setIDType($iDType)
            ->setIDName($iDName)
            ->setIDOrgCode($iDOrgCode)
            ->setIDOrgName($iDOrgName)
            ->setIDNum($iDNum)
            ->setIDDate($iDDate)
            ->setNumber($number)
            ->setRiseDate($riseDate)
            ->setNumberComposite($numberComposite)
            ->setDebtText($debtText)
            ->setDebtorName($debtorName)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorBirthplace($debtorBirthplace)
            ->setDebtorAddress($debtorAddress)
            ->setDebtSum($debtSum)
            ->setDebtRestTotal($debtRestTotal)
            ->setDebtRestIP($debtRestIP)
            ->setDebtRestFine($debtRestFine)
            ->setDebtRestDuty($debtRestDuty)
            ->setDebtRestOther($debtRestOther)
            ->setIPEndDate($iPEndDate)
            ->setIPEndArticle($iPEndArticle)
            ->setIPEndPoint($iPEndPoint)
            ->setIPEndSubpoint($iPEndSubpoint)
            ->setOspCode($ospCode)
            ->setDivName($divName)
            ->setDivAdr($divAdr)
            ->setSPIShortName($sPIShortName)
            ->setSPITelephone($sPITelephone)
            ->setActualityDate($actualityDate)
            ->setUnifoChargeFssp($unifoChargeFssp)
            ->setUnifoChargeExt($unifoChargeExt);
    }
    /**
     * Get IPKey value
     * @return int|null
     */
    public function getIPKey()
    {
        return $this->IPKey;
    }
    /**
     * Set IPKey value
     * @param int $iPKey
     * @return \StructType\BriefIPInformationType
     */
    public function setIPKey($iPKey = null)
    {
        $this->IPKey = $iPKey;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \EnumType\IdType::valueIsValid()
     * @uses \EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \StructType\BriefIPInformationType
     */
    public function setIDType($iDType = null)
    {
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get IDName value
     * @return string|null
     */
    public function getIDName()
    {
        return $this->IDName;
    }
    /**
     * Set IDName value
     * @param string $iDName
     * @return \StructType\BriefIPInformationType
     */
    public function setIDName($iDName = null)
    {
        $this->IDName = $iDName;
        return $this;
    }
    /**
     * Get IDOrgCode value
     * @return string|null
     */
    public function getIDOrgCode()
    {
        return $this->IDOrgCode;
    }
    /**
     * Set IDOrgCode value
     * @param string $iDOrgCode
     * @return \StructType\BriefIPInformationType
     */
    public function setIDOrgCode($iDOrgCode = null)
    {
        $this->IDOrgCode = $iDOrgCode;
        return $this;
    }
    /**
     * Get IDOrgName value
     * @return string|null
     */
    public function getIDOrgName()
    {
        return $this->IDOrgName;
    }
    /**
     * Set IDOrgName value
     * @param string $iDOrgName
     * @return \StructType\BriefIPInformationType
     */
    public function setIDOrgName($iDOrgName = null)
    {
        $this->IDOrgName = $iDOrgName;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string|null
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \StructType\BriefIPInformationType
     */
    public function setIDNum($iDNum = null)
    {
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \StructType\BriefIPInformationType
     */
    public function setIDDate($iDDate = null)
    {
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\BriefIPInformationType
     */
    public function setNumber($number = null)
    {
        $this->number = $number;
        return $this;
    }
    /**
     * Get riseDate value
     * @return string|null
     */
    public function getRiseDate()
    {
        return $this->riseDate;
    }
    /**
     * Set riseDate value
     * @param string $riseDate
     * @return \StructType\BriefIPInformationType
     */
    public function setRiseDate($riseDate = null)
    {
        $this->riseDate = $riseDate;
        return $this;
    }
    /**
     * Get numberComposite value
     * @return string|null
     */
    public function getNumberComposite()
    {
        return $this->numberComposite;
    }
    /**
     * Set numberComposite value
     * @param string $numberComposite
     * @return \StructType\BriefIPInformationType
     */
    public function setNumberComposite($numberComposite = null)
    {
        $this->numberComposite = $numberComposite;
        return $this;
    }
    /**
     * Get debtText value
     * @return string|null
     */
    public function getDebtText()
    {
        return $this->debtText;
    }
    /**
     * Set debtText value
     * @param string $debtText
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtText($debtText = null)
    {
        $this->debtText = $debtText;
        return $this;
    }
    /**
     * Get debtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->debtorName;
    }
    /**
     * Set debtorName value
     * @param string $debtorName
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtorName($debtorName = null)
    {
        $this->debtorName = $debtorName;
        return $this;
    }
    /**
     * Get debtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->debtorBirthDate;
    }
    /**
     * Set debtorBirthDate value
     * @param string $debtorBirthDate
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        $this->debtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get debtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->debtorBirthYear;
    }
    /**
     * Set debtorBirthYear value
     * @param string $debtorBirthYear
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        $this->debtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get debtorBirthplace value
     * @return string|null
     */
    public function getDebtorBirthplace()
    {
        return $this->debtorBirthplace;
    }
    /**
     * Set debtorBirthplace value
     * @param string $debtorBirthplace
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtorBirthplace($debtorBirthplace = null)
    {
        $this->debtorBirthplace = $debtorBirthplace;
        return $this;
    }
    /**
     * Get debtorAddress value
     * @return string|null
     */
    public function getDebtorAddress()
    {
        return $this->debtorAddress;
    }
    /**
     * Set debtorAddress value
     * @param string $debtorAddress
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtorAddress($debtorAddress = null)
    {
        $this->debtorAddress = $debtorAddress;
        return $this;
    }
    /**
     * Get debtSum value
     * @return float|null
     */
    public function getDebtSum()
    {
        return $this->debtSum;
    }
    /**
     * Set debtSum value
     * @param float $debtSum
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtSum($debtSum = null)
    {
        $this->debtSum = $debtSum;
        return $this;
    }
    /**
     * Get debtRestTotal value
     * @return float|null
     */
    public function getDebtRestTotal()
    {
        return $this->debtRestTotal;
    }
    /**
     * Set debtRestTotal value
     * @param float $debtRestTotal
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtRestTotal($debtRestTotal = null)
    {
        $this->debtRestTotal = $debtRestTotal;
        return $this;
    }
    /**
     * Get debtRestIP value
     * @return float|null
     */
    public function getDebtRestIP()
    {
        return $this->debtRestIP;
    }
    /**
     * Set debtRestIP value
     * @param float $debtRestIP
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtRestIP($debtRestIP = null)
    {
        $this->debtRestIP = $debtRestIP;
        return $this;
    }
    /**
     * Get debtRestFine value
     * @return float|null
     */
    public function getDebtRestFine()
    {
        return $this->debtRestFine;
    }
    /**
     * Set debtRestFine value
     * @param float $debtRestFine
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtRestFine($debtRestFine = null)
    {
        $this->debtRestFine = $debtRestFine;
        return $this;
    }
    /**
     * Get debtRestDuty value
     * @return float|null
     */
    public function getDebtRestDuty()
    {
        return $this->debtRestDuty;
    }
    /**
     * Set debtRestDuty value
     * @param float $debtRestDuty
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtRestDuty($debtRestDuty = null)
    {
        $this->debtRestDuty = $debtRestDuty;
        return $this;
    }
    /**
     * Get debtRestOther value
     * @return float|null
     */
    public function getDebtRestOther()
    {
        return $this->debtRestOther;
    }
    /**
     * Set debtRestOther value
     * @param float $debtRestOther
     * @return \StructType\BriefIPInformationType
     */
    public function setDebtRestOther($debtRestOther = null)
    {
        $this->debtRestOther = $debtRestOther;
        return $this;
    }
    /**
     * Get IPEndDate value
     * @return string|null
     */
    public function getIPEndDate()
    {
        return $this->IPEndDate;
    }
    /**
     * Set IPEndDate value
     * @param string $iPEndDate
     * @return \StructType\BriefIPInformationType
     */
    public function setIPEndDate($iPEndDate = null)
    {
        $this->IPEndDate = $iPEndDate;
        return $this;
    }
    /**
     * Get IPEndArticle value
     * @return string|null
     */
    public function getIPEndArticle()
    {
        return $this->IPEndArticle;
    }
    /**
     * Set IPEndArticle value
     * @param string $iPEndArticle
     * @return \StructType\BriefIPInformationType
     */
    public function setIPEndArticle($iPEndArticle = null)
    {
        $this->IPEndArticle = $iPEndArticle;
        return $this;
    }
    /**
     * Get IPEndPoint value
     * @return string|null
     */
    public function getIPEndPoint()
    {
        return $this->IPEndPoint;
    }
    /**
     * Set IPEndPoint value
     * @param string $iPEndPoint
     * @return \StructType\BriefIPInformationType
     */
    public function setIPEndPoint($iPEndPoint = null)
    {
        $this->IPEndPoint = $iPEndPoint;
        return $this;
    }
    /**
     * Get IPEndSubpoint value
     * @return string|null
     */
    public function getIPEndSubpoint()
    {
        return $this->IPEndSubpoint;
    }
    /**
     * Set IPEndSubpoint value
     * @param string $iPEndSubpoint
     * @return \StructType\BriefIPInformationType
     */
    public function setIPEndSubpoint($iPEndSubpoint = null)
    {
        $this->IPEndSubpoint = $iPEndSubpoint;
        return $this;
    }
    /**
     * Get ospCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->ospCode;
    }
    /**
     * Set ospCode value
     * @param string $ospCode
     * @return \StructType\BriefIPInformationType
     */
    public function setOspCode($ospCode = null)
    {
        $this->ospCode = $ospCode;
        return $this;
    }
    /**
     * Get divName value
     * @return string|null
     */
    public function getDivName()
    {
        return $this->divName;
    }
    /**
     * Set divName value
     * @param string $divName
     * @return \StructType\BriefIPInformationType
     */
    public function setDivName($divName = null)
    {
        $this->divName = $divName;
        return $this;
    }
    /**
     * Get divAdr value
     * @return string|null
     */
    public function getDivAdr()
    {
        return $this->divAdr;
    }
    /**
     * Set divAdr value
     * @param string $divAdr
     * @return \StructType\BriefIPInformationType
     */
    public function setDivAdr($divAdr = null)
    {
        $this->divAdr = $divAdr;
        return $this;
    }
    /**
     * Get SPIShortName value
     * @return string|null
     */
    public function getSPIShortName()
    {
        return $this->SPIShortName;
    }
    /**
     * Set SPIShortName value
     * @param string $sPIShortName
     * @return \StructType\BriefIPInformationType
     */
    public function setSPIShortName($sPIShortName = null)
    {
        $this->SPIShortName = $sPIShortName;
        return $this;
    }
    /**
     * Get SPITelephone value
     * @return string|null
     */
    public function getSPITelephone()
    {
        return $this->SPITelephone;
    }
    /**
     * Set SPITelephone value
     * @param string $sPITelephone
     * @return \StructType\BriefIPInformationType
     */
    public function setSPITelephone($sPITelephone = null)
    {
        $this->SPITelephone = $sPITelephone;
        return $this;
    }
    /**
     * Get actualityDate value
     * @return string|null
     */
    public function getActualityDate()
    {
        return $this->actualityDate;
    }
    /**
     * Set actualityDate value
     * @param string $actualityDate
     * @return \StructType\BriefIPInformationType
     */
    public function setActualityDate($actualityDate = null)
    {
        $this->actualityDate = $actualityDate;
        return $this;
    }
    /**
     * Get unifoChargeFssp value
     * @return string|null
     */
    public function getUnifoChargeFssp()
    {
        return $this->unifoChargeFssp;
    }
    /**
     * Set unifoChargeFssp value
     * @param string $unifoChargeFssp
     * @return \StructType\BriefIPInformationType
     */
    public function setUnifoChargeFssp($unifoChargeFssp = null)
    {
        $this->unifoChargeFssp = $unifoChargeFssp;
        return $this;
    }
    /**
     * Get unifoChargeExt value
     * @return string|null
     */
    public function getUnifoChargeExt()
    {
        return $this->unifoChargeExt;
    }
    /**
     * Set unifoChargeExt value
     * @param string $unifoChargeExt
     * @return \StructType\BriefIPInformationType
     */
    public function setUnifoChargeExt($unifoChargeExt = null)
    {
        $this->unifoChargeExt = $unifoChargeExt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BriefIPInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
