<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BarcodeList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Список идентификаторов отправлений, присвоенный ФГУП «Почта России»
 * @subpackage Structs
 */
class BarcodeList extends AbstractStructBase
{
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор отправления, присвоенный ФГУП «Почта России» | Штрих-код в формате code39
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - maxLength: 44
     * - minLength: 1
     * - pattern: [0-9A-Z\-\.\+$/%]+
     * @var string[]
     */
    public $Barcode;
    /**
     * Constructor method for BarcodeList
     * @uses BarcodeList::setBarcode()
     * @param string[] $barcode
     */
    public function __construct(array $barcode = array())
    {
        $this
            ->setBarcode($barcode);
    }
    /**
     * Get Barcode value
     * @return string[]
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @throws \InvalidArgumentException
     * @param string[] $barcode
     * @return \StructType\BarcodeList
     */
    public function setBarcode(array $barcode = array())
    {
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Add item to Barcode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BarcodeList
     */
    public function addToBarcode($item)
    {
        $this->Barcode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BarcodeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
