<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BKIResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения из банка данных для БКИ | Используется для передачи Бюро кредитных историй запрошенных ранее сведений из банка
 * данных.
 * - type: tns:BKIResponse
 * @subpackage Structs
 */
class BKIResponse extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор реестра, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор запроса реестра, полученный ранее от АИС внешнего контрагента | Идентификатор
     * объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The IsUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Признак обновления | Устанавливается в true в случае если файл данных это обновление, а не полная выгрузка данных | Обертка
     * стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsUpdate;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выгрузки | Дата актуальности выгруженных данных | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The PrevDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата предыдущей выгрузки | Дата предыдущей выгрузки данных. В случае если передается полная выгрузка данных не заполняется. |
     * Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $PrevDate;
    /**
     * The HasMoreDebt
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия обновлений | Устанавливается в true в случае, если это не последний реестр обновлений и существуют ещё данные |
     * Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $HasMoreDebt;
    /**
     * The DebtRecordCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество записей реестра долга | Количество записей о задолженности по ИП в файле долга. Нулевое количество обозначает, что
     * система не может найти реестр задолженности ФССП России, соответствующий условиям запроса для конкретного Бюро кредитных историй. |
     * Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $DebtRecordCount;
    /**
     * The ToFrom
     * Meta informations extracted from the WSDL
     * - documentation: Код территориального органа | Код территориального органа, для которого сформирован реестр задолженности ФССП России. |
     * Ведомственный классификатор территориальных отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $ToFrom;
    /**
     * The DebtDetail
     * Meta informations extracted from the WSDL
     * - documentation: Реестр задолженности для БКИ | В элементе передаются данные в Base64. Данное поле не заполняется в случае, если система не может
     * найти реестр задолженности ФССП России, соответствующий условиям запроса. Реквизитный состав реестра задолженности для БКИ указан в
     * Приложение 1. Реквизитный состав файла Сведения из банка данных исполнительных производств для БКИ (Реестра задолженности для БКИ)
     * - expectedContentTypes: application/zip
     * - minOccurs: 0
     * @var string
     */
    public $DebtDetail;
    /**
     * Constructor method for BKIResponse
     * @uses BKIResponse::setInternalKey()
     * @uses BKIResponse::setRequestExternalKey()
     * @uses BKIResponse::setIsUpdate()
     * @uses BKIResponse::setUnloadDate()
     * @uses BKIResponse::setPrevDate()
     * @uses BKIResponse::setHasMoreDebt()
     * @uses BKIResponse::setDebtRecordCount()
     * @uses BKIResponse::setToFrom()
     * @uses BKIResponse::setDebtDetail()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param bool $isUpdate
     * @param string $unloadDate
     * @param string $prevDate
     * @param bool $hasMoreDebt
     * @param int $debtRecordCount
     * @param string $toFrom
     * @param string $debtDetail
     */
    public function __construct($internalKey = null, $requestExternalKey = null, $isUpdate = null, $unloadDate = null, $prevDate = null, $hasMoreDebt = null, $debtRecordCount = null, $toFrom = null, $debtDetail = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setIsUpdate($isUpdate)
            ->setUnloadDate($unloadDate)
            ->setPrevDate($prevDate)
            ->setHasMoreDebt($hasMoreDebt)
            ->setDebtRecordCount($debtRecordCount)
            ->setToFrom($toFrom)
            ->setDebtDetail($debtDetail);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \StructType\BKIResponse
     */
    public function setInternalKey($internalKey = null)
    {
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \StructType\BKIResponse
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get IsUpdate value
     * @return bool|null
     */
    public function getIsUpdate()
    {
        return $this->IsUpdate;
    }
    /**
     * Set IsUpdate value
     * @param bool $isUpdate
     * @return \StructType\BKIResponse
     */
    public function setIsUpdate($isUpdate = null)
    {
        $this->IsUpdate = $isUpdate;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \StructType\BKIResponse
     */
    public function setUnloadDate($unloadDate = null)
    {
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get PrevDate value
     * @return string|null
     */
    public function getPrevDate()
    {
        return $this->PrevDate;
    }
    /**
     * Set PrevDate value
     * @param string $prevDate
     * @return \StructType\BKIResponse
     */
    public function setPrevDate($prevDate = null)
    {
        $this->PrevDate = $prevDate;
        return $this;
    }
    /**
     * Get HasMoreDebt value
     * @return bool|null
     */
    public function getHasMoreDebt()
    {
        return $this->HasMoreDebt;
    }
    /**
     * Set HasMoreDebt value
     * @param bool $hasMoreDebt
     * @return \StructType\BKIResponse
     */
    public function setHasMoreDebt($hasMoreDebt = null)
    {
        $this->HasMoreDebt = $hasMoreDebt;
        return $this;
    }
    /**
     * Get DebtRecordCount value
     * @return int|null
     */
    public function getDebtRecordCount()
    {
        return $this->DebtRecordCount;
    }
    /**
     * Set DebtRecordCount value
     * @param int $debtRecordCount
     * @return \StructType\BKIResponse
     */
    public function setDebtRecordCount($debtRecordCount = null)
    {
        $this->DebtRecordCount = $debtRecordCount;
        return $this;
    }
    /**
     * Get ToFrom value
     * @return string|null
     */
    public function getToFrom()
    {
        return $this->ToFrom;
    }
    /**
     * Set ToFrom value
     * @param string $toFrom
     * @return \StructType\BKIResponse
     */
    public function setToFrom($toFrom = null)
    {
        $this->ToFrom = $toFrom;
        return $this;
    }
    /**
     * Get DebtDetail value
     * @return string|null
     */
    public function getDebtDetail()
    {
        return $this->DebtDetail;
    }
    /**
     * Set DebtDetail value
     * @param string $debtDetail
     * @return \StructType\BKIResponse
     */
    public function setDebtDetail($debtDetail = null)
    {
        $this->DebtDetail = $debtDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BKIResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
