<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilityAccExtDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений AvailabilityAccExtDataType "Расширенные сведения о наличие денежных средств на счёте от налогового органа"
 * @subpackage Structs
 */
class AvailabilityAccExtDataType extends AvailabilityAccDataType
{
    /**
     * The IDDoc
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа | Строка длиной от 1 до 36 символов
     * - maxLength: 36
     * - minLength: 1
     * @var string
     */
    public $IDDoc;
    /**
     * The QueryNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер запроса или решения налогового органа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $QueryNumber;
    /**
     * The QueryDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса или решения налогового органа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $QueryDate;
    /**
     * The SOUN
     * Meta informations extracted from the WSDL
     * - documentation: Код налогового органа | Строка длиной от 1 до 4 символов
     * - maxLength: 4
     * - minLength: 1
     * @var string
     */
    public $SOUN;
    /**
     * The InquiryNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер справки | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $InquiryNumber;
    /**
     * The InquiryDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата формирования справки | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $InquiryDate;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование кредитной организации | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $BankName;
    /**
     * The RepresentativeBankFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО представителя банка
     * @var \StructType\FioType
     */
    public $RepresentativeBankFIO;
    /**
     * The RepresentativeBankPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность представителя банка | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $RepresentativeBankPost;
    /**
     * The TaxPayerName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование налогоплательщика | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $TaxPayerName;
    /**
     * The TaxPayerFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО налогоплательщика
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $TaxPayerFIO;
    /**
     * The TaxPayerINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН налогоплательщика | ИНН
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $TaxPayerINN;
    /**
     * The TaxPayerKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП налогоплательщика | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $TaxPayerKPP;
    /**
     * The TaxPayerKIO
     * Meta informations extracted from the WSDL
     * - documentation: КИО налогоплательщика | Строка длиной от 1 до 5 символов
     * - minOccurs: 0
     * - maxLength: 5
     * - minLength: 1
     * @var string
     */
    public $TaxPayerKIO;
    /**
     * The AccountKind
     * Meta informations extracted from the WSDL
     * - documentation: Вид счета | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $AccountKind;
    /**
     * Constructor method for AvailabilityAccExtDataType
     * @uses AvailabilityAccExtDataType::setIDDoc()
     * @uses AvailabilityAccExtDataType::setQueryNumber()
     * @uses AvailabilityAccExtDataType::setQueryDate()
     * @uses AvailabilityAccExtDataType::setSOUN()
     * @uses AvailabilityAccExtDataType::setInquiryNumber()
     * @uses AvailabilityAccExtDataType::setInquiryDate()
     * @uses AvailabilityAccExtDataType::setBankName()
     * @uses AvailabilityAccExtDataType::setRepresentativeBankFIO()
     * @uses AvailabilityAccExtDataType::setRepresentativeBankPost()
     * @uses AvailabilityAccExtDataType::setTaxPayerName()
     * @uses AvailabilityAccExtDataType::setTaxPayerFIO()
     * @uses AvailabilityAccExtDataType::setTaxPayerINN()
     * @uses AvailabilityAccExtDataType::setTaxPayerKPP()
     * @uses AvailabilityAccExtDataType::setTaxPayerKIO()
     * @uses AvailabilityAccExtDataType::setAccountKind()
     * @param string $iDDoc
     * @param string $queryNumber
     * @param string $queryDate
     * @param string $sOUN
     * @param string $inquiryNumber
     * @param string $inquiryDate
     * @param string $bankName
     * @param \StructType\FioType $representativeBankFIO
     * @param string $representativeBankPost
     * @param string $taxPayerName
     * @param \StructType\FioType $taxPayerFIO
     * @param string $taxPayerINN
     * @param string $taxPayerKPP
     * @param string $taxPayerKIO
     * @param string $accountKind
     */
    public function __construct($iDDoc = null, $queryNumber = null, $queryDate = null, $sOUN = null, $inquiryNumber = null, $inquiryDate = null, $bankName = null, \StructType\FioType $representativeBankFIO = null, $representativeBankPost = null, $taxPayerName = null, \StructType\FioType $taxPayerFIO = null, $taxPayerINN = null, $taxPayerKPP = null, $taxPayerKIO = null, $accountKind = null)
    {
        $this
            ->setIDDoc($iDDoc)
            ->setQueryNumber($queryNumber)
            ->setQueryDate($queryDate)
            ->setSOUN($sOUN)
            ->setInquiryNumber($inquiryNumber)
            ->setInquiryDate($inquiryDate)
            ->setBankName($bankName)
            ->setRepresentativeBankFIO($representativeBankFIO)
            ->setRepresentativeBankPost($representativeBankPost)
            ->setTaxPayerName($taxPayerName)
            ->setTaxPayerFIO($taxPayerFIO)
            ->setTaxPayerINN($taxPayerINN)
            ->setTaxPayerKPP($taxPayerKPP)
            ->setTaxPayerKIO($taxPayerKIO)
            ->setAccountKind($accountKind);
    }
    /**
     * Get IDDoc value
     * @return string|null
     */
    public function getIDDoc()
    {
        return $this->IDDoc;
    }
    /**
     * Set IDDoc value
     * @param string $iDDoc
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setIDDoc($iDDoc = null)
    {
        $this->IDDoc = $iDDoc;
        return $this;
    }
    /**
     * Get QueryNumber value
     * @return string|null
     */
    public function getQueryNumber()
    {
        return $this->QueryNumber;
    }
    /**
     * Set QueryNumber value
     * @param string $queryNumber
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setQueryNumber($queryNumber = null)
    {
        $this->QueryNumber = $queryNumber;
        return $this;
    }
    /**
     * Get QueryDate value
     * @return string|null
     */
    public function getQueryDate()
    {
        return $this->QueryDate;
    }
    /**
     * Set QueryDate value
     * @param string $queryDate
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setQueryDate($queryDate = null)
    {
        $this->QueryDate = $queryDate;
        return $this;
    }
    /**
     * Get SOUN value
     * @return string|null
     */
    public function getSOUN()
    {
        return $this->SOUN;
    }
    /**
     * Set SOUN value
     * @param string $sOUN
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setSOUN($sOUN = null)
    {
        $this->SOUN = $sOUN;
        return $this;
    }
    /**
     * Get InquiryNumber value
     * @return string|null
     */
    public function getInquiryNumber()
    {
        return $this->InquiryNumber;
    }
    /**
     * Set InquiryNumber value
     * @param string $inquiryNumber
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setInquiryNumber($inquiryNumber = null)
    {
        $this->InquiryNumber = $inquiryNumber;
        return $this;
    }
    /**
     * Get InquiryDate value
     * @return string|null
     */
    public function getInquiryDate()
    {
        return $this->InquiryDate;
    }
    /**
     * Set InquiryDate value
     * @param string $inquiryDate
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setInquiryDate($inquiryDate = null)
    {
        $this->InquiryDate = $inquiryDate;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setBankName($bankName = null)
    {
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get RepresentativeBankFIO value
     * @return \StructType\FioType|null
     */
    public function getRepresentativeBankFIO()
    {
        return $this->RepresentativeBankFIO;
    }
    /**
     * Set RepresentativeBankFIO value
     * @param \StructType\FioType $representativeBankFIO
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setRepresentativeBankFIO(\StructType\FioType $representativeBankFIO = null)
    {
        $this->RepresentativeBankFIO = $representativeBankFIO;
        return $this;
    }
    /**
     * Get RepresentativeBankPost value
     * @return string|null
     */
    public function getRepresentativeBankPost()
    {
        return $this->RepresentativeBankPost;
    }
    /**
     * Set RepresentativeBankPost value
     * @param string $representativeBankPost
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setRepresentativeBankPost($representativeBankPost = null)
    {
        $this->RepresentativeBankPost = $representativeBankPost;
        return $this;
    }
    /**
     * Get TaxPayerName value
     * @return string|null
     */
    public function getTaxPayerName()
    {
        return $this->TaxPayerName;
    }
    /**
     * Set TaxPayerName value
     * @param string $taxPayerName
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setTaxPayerName($taxPayerName = null)
    {
        $this->TaxPayerName = $taxPayerName;
        return $this;
    }
    /**
     * Get TaxPayerFIO value
     * @return \StructType\FioType|null
     */
    public function getTaxPayerFIO()
    {
        return $this->TaxPayerFIO;
    }
    /**
     * Set TaxPayerFIO value
     * @param \StructType\FioType $taxPayerFIO
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setTaxPayerFIO(\StructType\FioType $taxPayerFIO = null)
    {
        $this->TaxPayerFIO = $taxPayerFIO;
        return $this;
    }
    /**
     * Get TaxPayerINN value
     * @return string|null
     */
    public function getTaxPayerINN()
    {
        return $this->TaxPayerINN;
    }
    /**
     * Set TaxPayerINN value
     * @param string $taxPayerINN
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setTaxPayerINN($taxPayerINN = null)
    {
        $this->TaxPayerINN = $taxPayerINN;
        return $this;
    }
    /**
     * Get TaxPayerKPP value
     * @return string|null
     */
    public function getTaxPayerKPP()
    {
        return $this->TaxPayerKPP;
    }
    /**
     * Set TaxPayerKPP value
     * @param string $taxPayerKPP
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setTaxPayerKPP($taxPayerKPP = null)
    {
        $this->TaxPayerKPP = $taxPayerKPP;
        return $this;
    }
    /**
     * Get TaxPayerKIO value
     * @return string|null
     */
    public function getTaxPayerKIO()
    {
        return $this->TaxPayerKIO;
    }
    /**
     * Set TaxPayerKIO value
     * @param string $taxPayerKIO
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setTaxPayerKIO($taxPayerKIO = null)
    {
        $this->TaxPayerKIO = $taxPayerKIO;
        return $this;
    }
    /**
     * Get AccountKind value
     * @return string|null
     */
    public function getAccountKind()
    {
        return $this->AccountKind;
    }
    /**
     * Set AccountKind value
     * @param string $accountKind
     * @return \StructType\AvailabilityAccExtDataType
     */
    public function setAccountKind($accountKind = null)
    {
        $this->AccountKind = $accountKind;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailabilityAccExtDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
