<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrestRegistryDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Строка выписки из реестра арестованного имущество отправленного на реализацию
 * - type: tns:ArrestRegistryDetail
 * @subpackage Structs
 */
class ArrestRegistryDetail extends AbstractStructBase
{
    /**
     * The IPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNumber;
    /**
     * The IPStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус ИП | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $IPStatus;
    /**
     * The OSPName
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия сведений | Наименование ОСП по справочнику ВКСП. | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OSPName;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Код СПИ. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО СПИ полностью. | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIFioParts
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО СПИ. Заполняется только в том случае, если соответствующие данные есть в системе.
     * - minOccurs: 0
     * @var \StructType\FioType
     */
    public $SPIFioParts;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ по справочнику должностей СПИ на основе ОКПДТР / РДФГГС. | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The Debtor
     * Meta informations extracted from the WSDL
     * - documentation: Должник | Сведения о должнике. В рамках сведений не передается такая информация, как: Место рождения контрагента, Номер
     * документа, Тип документа, удостоверяющего личность, Адрес контрагента, Телефон, Электропочта, Должность.
     * - minOccurs: 0
     * @var \StructType\ContragentDatumType
     */
    public $Debtor;
    /**
     * The IDSubjName
     * Meta informations extracted from the WSDL
     * - documentation: Сущность исполнения | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDSubjName;
    /**
     * The IPDebt
     * Meta informations extracted from the WSDL
     * - documentation: Сумма взыскания | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebt;
    /**
     * The DateArrest
     * Meta informations extracted from the WSDL
     * - documentation: Дата наложения ареста | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateArrest;
    /**
     * The TypeProperty
     * Meta informations extracted from the WSDL
     * - documentation: Тип имущества | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $TypeProperty;
    /**
     * The TypePropertyText
     * Meta informations extracted from the WSDL
     * - documentation: Наименование имущества | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $TypePropertyText;
    /**
     * The CostPropertyAct
     * Meta informations extracted from the WSDL
     * - documentation: Стоимость имущества по акту | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $CostPropertyAct;
    /**
     * The NumberRealEstate
     * Meta informations extracted from the WSDL
     * - documentation: Номер заявки на оценку | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $NumberRealEstate;
    /**
     * The DateRealEstate
     * Meta informations extracted from the WSDL
     * - documentation: Дата заявки на оценку | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateRealEstate;
    /**
     * The DateDecreeAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления об участии оценщика | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDecreeAppraiser;
    /**
     * The NameOrgAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Наименование оценочной организации | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $NameOrgAppraiser;
    /**
     * The DateReportAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Дата отчета об оценке | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateReportAppraiser;
    /**
     * The DateDecreeApprovalAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления об утверждении оценки | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDecreeApprovalAppraiser;
    /**
     * The DateAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Дата оценки | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateAppraiser;
    /**
     * The CostPropertyAppraiser
     * Meta informations extracted from the WSDL
     * - documentation: Стоимость имущества по результатам оценки | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $CostPropertyAppraiser;
    /**
     * The DateDecreeSelling
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления о передаче на реализацию | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDecreeSelling;
    /**
     * The NumberApplicationSelling
     * Meta informations extracted from the WSDL
     * - documentation: Номер заявки на реализацию | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $NumberApplicationSelling;
    /**
     * The DateApplicationSelling
     * Meta informations extracted from the WSDL
     * - documentation: Дата заявки на реализацию | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateApplicationSelling;
    /**
     * The DateDliverySelling
     * Meta informations extracted from the WSDL
     * - documentation: Дата передачи на реализацию | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateDliverySelling;
    /**
     * The OrganizationSelling
     * Meta informations extracted from the WSDL
     * - documentation: Наименование реализатора | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $OrganizationSelling;
    /**
     * The AddressOrganizationSelling
     * Meta informations extracted from the WSDL
     * - documentation: Адрес реализатора
     * @var \StructType\AddressType
     */
    public $AddressOrganizationSelling;
    /**
     * The PhoneOrganizationSelling
     * Meta informations extracted from the WSDL
     * - documentation: Контактный телефон | Номер телефона
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PhoneOrganizationSelling;
    /**
     * The DateSelling
     * Meta informations extracted from the WSDL
     * - documentation: Дата проведения торгов или выставления имущества на экспозицию | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateSelling;
    /**
     * The AddressSelling
     * Meta informations extracted from the WSDL
     * - documentation: Адрес места проведения торгов (место экспозиции)
     * @var \StructType\AddressType
     */
    public $AddressSelling;
    /**
     * The NameMedia
     * Meta informations extracted from the WSDL
     * - documentation: Наименование СМИ | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $NameMedia;
    /**
     * The DatePublication
     * Meta informations extracted from the WSDL
     * - documentation: Дата публикации информации о реализации арестованного имущества | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DatePublication;
    /**
     * The StartingPrice
     * Meta informations extracted from the WSDL
     * - documentation: Начальная продажная цена (руб.) | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $StartingPrice;
    /**
     * Constructor method for ArrestRegistryDetail
     * @uses ArrestRegistryDetail::setIPNumber()
     * @uses ArrestRegistryDetail::setIPStatus()
     * @uses ArrestRegistryDetail::setOSPName()
     * @uses ArrestRegistryDetail::setSPI()
     * @uses ArrestRegistryDetail::setSPIFio()
     * @uses ArrestRegistryDetail::setSPIFioParts()
     * @uses ArrestRegistryDetail::setSPITel()
     * @uses ArrestRegistryDetail::setSPIPost()
     * @uses ArrestRegistryDetail::setDebtor()
     * @uses ArrestRegistryDetail::setIDSubjName()
     * @uses ArrestRegistryDetail::setIPDebt()
     * @uses ArrestRegistryDetail::setDateArrest()
     * @uses ArrestRegistryDetail::setTypeProperty()
     * @uses ArrestRegistryDetail::setTypePropertyText()
     * @uses ArrestRegistryDetail::setCostPropertyAct()
     * @uses ArrestRegistryDetail::setNumberRealEstate()
     * @uses ArrestRegistryDetail::setDateRealEstate()
     * @uses ArrestRegistryDetail::setDateDecreeAppraiser()
     * @uses ArrestRegistryDetail::setNameOrgAppraiser()
     * @uses ArrestRegistryDetail::setDateReportAppraiser()
     * @uses ArrestRegistryDetail::setDateDecreeApprovalAppraiser()
     * @uses ArrestRegistryDetail::setDateAppraiser()
     * @uses ArrestRegistryDetail::setCostPropertyAppraiser()
     * @uses ArrestRegistryDetail::setDateDecreeSelling()
     * @uses ArrestRegistryDetail::setNumberApplicationSelling()
     * @uses ArrestRegistryDetail::setDateApplicationSelling()
     * @uses ArrestRegistryDetail::setDateDliverySelling()
     * @uses ArrestRegistryDetail::setOrganizationSelling()
     * @uses ArrestRegistryDetail::setAddressOrganizationSelling()
     * @uses ArrestRegistryDetail::setPhoneOrganizationSelling()
     * @uses ArrestRegistryDetail::setDateSelling()
     * @uses ArrestRegistryDetail::setAddressSelling()
     * @uses ArrestRegistryDetail::setNameMedia()
     * @uses ArrestRegistryDetail::setDatePublication()
     * @uses ArrestRegistryDetail::setStartingPrice()
     * @param string $iPNumber
     * @param string $iPStatus
     * @param string $oSPName
     * @param int $sPI
     * @param string $sPIFio
     * @param \StructType\FioType $sPIFioParts
     * @param string $sPITel
     * @param string $sPIPost
     * @param \StructType\ContragentDatumType $debtor
     * @param string $iDSubjName
     * @param float $iPDebt
     * @param string $dateArrest
     * @param string $typeProperty
     * @param string $typePropertyText
     * @param float $costPropertyAct
     * @param string $numberRealEstate
     * @param string $dateRealEstate
     * @param string $dateDecreeAppraiser
     * @param string $nameOrgAppraiser
     * @param string $dateReportAppraiser
     * @param string $dateDecreeApprovalAppraiser
     * @param string $dateAppraiser
     * @param float $costPropertyAppraiser
     * @param string $dateDecreeSelling
     * @param string $numberApplicationSelling
     * @param string $dateApplicationSelling
     * @param string $dateDliverySelling
     * @param string $organizationSelling
     * @param \StructType\AddressType $addressOrganizationSelling
     * @param string $phoneOrganizationSelling
     * @param string $dateSelling
     * @param \StructType\AddressType $addressSelling
     * @param string $nameMedia
     * @param string $datePublication
     * @param float $startingPrice
     */
    public function __construct($iPNumber = null, $iPStatus = null, $oSPName = null, $sPI = null, $sPIFio = null, \StructType\FioType $sPIFioParts = null, $sPITel = null, $sPIPost = null, \StructType\ContragentDatumType $debtor = null, $iDSubjName = null, $iPDebt = null, $dateArrest = null, $typeProperty = null, $typePropertyText = null, $costPropertyAct = null, $numberRealEstate = null, $dateRealEstate = null, $dateDecreeAppraiser = null, $nameOrgAppraiser = null, $dateReportAppraiser = null, $dateDecreeApprovalAppraiser = null, $dateAppraiser = null, $costPropertyAppraiser = null, $dateDecreeSelling = null, $numberApplicationSelling = null, $dateApplicationSelling = null, $dateDliverySelling = null, $organizationSelling = null, \StructType\AddressType $addressOrganizationSelling = null, $phoneOrganizationSelling = null, $dateSelling = null, \StructType\AddressType $addressSelling = null, $nameMedia = null, $datePublication = null, $startingPrice = null)
    {
        $this
            ->setIPNumber($iPNumber)
            ->setIPStatus($iPStatus)
            ->setOSPName($oSPName)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setSPIFioParts($sPIFioParts)
            ->setSPITel($sPITel)
            ->setSPIPost($sPIPost)
            ->setDebtor($debtor)
            ->setIDSubjName($iDSubjName)
            ->setIPDebt($iPDebt)
            ->setDateArrest($dateArrest)
            ->setTypeProperty($typeProperty)
            ->setTypePropertyText($typePropertyText)
            ->setCostPropertyAct($costPropertyAct)
            ->setNumberRealEstate($numberRealEstate)
            ->setDateRealEstate($dateRealEstate)
            ->setDateDecreeAppraiser($dateDecreeAppraiser)
            ->setNameOrgAppraiser($nameOrgAppraiser)
            ->setDateReportAppraiser($dateReportAppraiser)
            ->setDateDecreeApprovalAppraiser($dateDecreeApprovalAppraiser)
            ->setDateAppraiser($dateAppraiser)
            ->setCostPropertyAppraiser($costPropertyAppraiser)
            ->setDateDecreeSelling($dateDecreeSelling)
            ->setNumberApplicationSelling($numberApplicationSelling)
            ->setDateApplicationSelling($dateApplicationSelling)
            ->setDateDliverySelling($dateDliverySelling)
            ->setOrganizationSelling($organizationSelling)
            ->setAddressOrganizationSelling($addressOrganizationSelling)
            ->setPhoneOrganizationSelling($phoneOrganizationSelling)
            ->setDateSelling($dateSelling)
            ->setAddressSelling($addressSelling)
            ->setNameMedia($nameMedia)
            ->setDatePublication($datePublication)
            ->setStartingPrice($startingPrice);
    }
    /**
     * Get IPNumber value
     * @return string|null
     */
    public function getIPNumber()
    {
        return $this->IPNumber;
    }
    /**
     * Set IPNumber value
     * @param string $iPNumber
     * @return \StructType\ArrestRegistryDetail
     */
    public function setIPNumber($iPNumber = null)
    {
        $this->IPNumber = $iPNumber;
        return $this;
    }
    /**
     * Get IPStatus value
     * @return string|null
     */
    public function getIPStatus()
    {
        return $this->IPStatus;
    }
    /**
     * Set IPStatus value
     * @param string $iPStatus
     * @return \StructType\ArrestRegistryDetail
     */
    public function setIPStatus($iPStatus = null)
    {
        $this->IPStatus = $iPStatus;
        return $this;
    }
    /**
     * Get OSPName value
     * @return string|null
     */
    public function getOSPName()
    {
        return $this->OSPName;
    }
    /**
     * Set OSPName value
     * @param string $oSPName
     * @return \StructType\ArrestRegistryDetail
     */
    public function setOSPName($oSPName = null)
    {
        $this->OSPName = $oSPName;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \StructType\ArrestRegistryDetail
     */
    public function setSPI($sPI = null)
    {
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \StructType\ArrestRegistryDetail
     */
    public function setSPIFio($sPIFio = null)
    {
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIFioParts value
     * @return \StructType\FioType|null
     */
    public function getSPIFioParts()
    {
        return $this->SPIFioParts;
    }
    /**
     * Set SPIFioParts value
     * @param \StructType\FioType $sPIFioParts
     * @return \StructType\ArrestRegistryDetail
     */
    public function setSPIFioParts(\StructType\FioType $sPIFioParts = null)
    {
        $this->SPIFioParts = $sPIFioParts;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \StructType\ArrestRegistryDetail
     */
    public function setSPITel($sPITel = null)
    {
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \StructType\ArrestRegistryDetail
     */
    public function setSPIPost($sPIPost = null)
    {
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get Debtor value
     * @return \StructType\ContragentDatumType|null
     */
    public function getDebtor()
    {
        return $this->Debtor;
    }
    /**
     * Set Debtor value
     * @param \StructType\ContragentDatumType $debtor
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDebtor(\StructType\ContragentDatumType $debtor = null)
    {
        $this->Debtor = $debtor;
        return $this;
    }
    /**
     * Get IDSubjName value
     * @return string|null
     */
    public function getIDSubjName()
    {
        return $this->IDSubjName;
    }
    /**
     * Set IDSubjName value
     * @param string $iDSubjName
     * @return \StructType\ArrestRegistryDetail
     */
    public function setIDSubjName($iDSubjName = null)
    {
        $this->IDSubjName = $iDSubjName;
        return $this;
    }
    /**
     * Get IPDebt value
     * @return float|null
     */
    public function getIPDebt()
    {
        return $this->IPDebt;
    }
    /**
     * Set IPDebt value
     * @param float $iPDebt
     * @return \StructType\ArrestRegistryDetail
     */
    public function setIPDebt($iPDebt = null)
    {
        $this->IPDebt = $iPDebt;
        return $this;
    }
    /**
     * Get DateArrest value
     * @return string|null
     */
    public function getDateArrest()
    {
        return $this->DateArrest;
    }
    /**
     * Set DateArrest value
     * @param string $dateArrest
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDateArrest($dateArrest = null)
    {
        $this->DateArrest = $dateArrest;
        return $this;
    }
    /**
     * Get TypeProperty value
     * @return string|null
     */
    public function getTypeProperty()
    {
        return $this->TypeProperty;
    }
    /**
     * Set TypeProperty value
     * @param string $typeProperty
     * @return \StructType\ArrestRegistryDetail
     */
    public function setTypeProperty($typeProperty = null)
    {
        $this->TypeProperty = $typeProperty;
        return $this;
    }
    /**
     * Get TypePropertyText value
     * @return string|null
     */
    public function getTypePropertyText()
    {
        return $this->TypePropertyText;
    }
    /**
     * Set TypePropertyText value
     * @param string $typePropertyText
     * @return \StructType\ArrestRegistryDetail
     */
    public function setTypePropertyText($typePropertyText = null)
    {
        $this->TypePropertyText = $typePropertyText;
        return $this;
    }
    /**
     * Get CostPropertyAct value
     * @return float|null
     */
    public function getCostPropertyAct()
    {
        return $this->CostPropertyAct;
    }
    /**
     * Set CostPropertyAct value
     * @param float $costPropertyAct
     * @return \StructType\ArrestRegistryDetail
     */
    public function setCostPropertyAct($costPropertyAct = null)
    {
        $this->CostPropertyAct = $costPropertyAct;
        return $this;
    }
    /**
     * Get NumberRealEstate value
     * @return string|null
     */
    public function getNumberRealEstate()
    {
        return $this->NumberRealEstate;
    }
    /**
     * Set NumberRealEstate value
     * @param string $numberRealEstate
     * @return \StructType\ArrestRegistryDetail
     */
    public function setNumberRealEstate($numberRealEstate = null)
    {
        $this->NumberRealEstate = $numberRealEstate;
        return $this;
    }
    /**
     * Get DateRealEstate value
     * @return string|null
     */
    public function getDateRealEstate()
    {
        return $this->DateRealEstate;
    }
    /**
     * Set DateRealEstate value
     * @param string $dateRealEstate
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDateRealEstate($dateRealEstate = null)
    {
        $this->DateRealEstate = $dateRealEstate;
        return $this;
    }
    /**
     * Get DateDecreeAppraiser value
     * @return string|null
     */
    public function getDateDecreeAppraiser()
    {
        return $this->DateDecreeAppraiser;
    }
    /**
     * Set DateDecreeAppraiser value
     * @param string $dateDecreeAppraiser
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDateDecreeAppraiser($dateDecreeAppraiser = null)
    {
        $this->DateDecreeAppraiser = $dateDecreeAppraiser;
        return $this;
    }
    /**
     * Get NameOrgAppraiser value
     * @return string|null
     */
    public function getNameOrgAppraiser()
    {
        return $this->NameOrgAppraiser;
    }
    /**
     * Set NameOrgAppraiser value
     * @param string $nameOrgAppraiser
     * @return \StructType\ArrestRegistryDetail
     */
    public function setNameOrgAppraiser($nameOrgAppraiser = null)
    {
        $this->NameOrgAppraiser = $nameOrgAppraiser;
        return $this;
    }
    /**
     * Get DateReportAppraiser value
     * @return string|null
     */
    public function getDateReportAppraiser()
    {
        return $this->DateReportAppraiser;
    }
    /**
     * Set DateReportAppraiser value
     * @param string $dateReportAppraiser
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDateReportAppraiser($dateReportAppraiser = null)
    {
        $this->DateReportAppraiser = $dateReportAppraiser;
        return $this;
    }
    /**
     * Get DateDecreeApprovalAppraiser value
     * @return string|null
     */
    public function getDateDecreeApprovalAppraiser()
    {
        return $this->DateDecreeApprovalAppraiser;
    }
    /**
     * Set DateDecreeApprovalAppraiser value
     * @param string $dateDecreeApprovalAppraiser
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDateDecreeApprovalAppraiser($dateDecreeApprovalAppraiser = null)
    {
        $this->DateDecreeApprovalAppraiser = $dateDecreeApprovalAppraiser;
        return $this;
    }
    /**
     * Get DateAppraiser value
     * @return string|null
     */
    public function getDateAppraiser()
    {
        return $this->DateAppraiser;
    }
    /**
     * Set DateAppraiser value
     * @param string $dateAppraiser
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDateAppraiser($dateAppraiser = null)
    {
        $this->DateAppraiser = $dateAppraiser;
        return $this;
    }
    /**
     * Get CostPropertyAppraiser value
     * @return float|null
     */
    public function getCostPropertyAppraiser()
    {
        return $this->CostPropertyAppraiser;
    }
    /**
     * Set CostPropertyAppraiser value
     * @param float $costPropertyAppraiser
     * @return \StructType\ArrestRegistryDetail
     */
    public function setCostPropertyAppraiser($costPropertyAppraiser = null)
    {
        $this->CostPropertyAppraiser = $costPropertyAppraiser;
        return $this;
    }
    /**
     * Get DateDecreeSelling value
     * @return string|null
     */
    public function getDateDecreeSelling()
    {
        return $this->DateDecreeSelling;
    }
    /**
     * Set DateDecreeSelling value
     * @param string $dateDecreeSelling
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDateDecreeSelling($dateDecreeSelling = null)
    {
        $this->DateDecreeSelling = $dateDecreeSelling;
        return $this;
    }
    /**
     * Get NumberApplicationSelling value
     * @return string|null
     */
    public function getNumberApplicationSelling()
    {
        return $this->NumberApplicationSelling;
    }
    /**
     * Set NumberApplicationSelling value
     * @param string $numberApplicationSelling
     * @return \StructType\ArrestRegistryDetail
     */
    public function setNumberApplicationSelling($numberApplicationSelling = null)
    {
        $this->NumberApplicationSelling = $numberApplicationSelling;
        return $this;
    }
    /**
     * Get DateApplicationSelling value
     * @return string|null
     */
    public function getDateApplicationSelling()
    {
        return $this->DateApplicationSelling;
    }
    /**
     * Set DateApplicationSelling value
     * @param string $dateApplicationSelling
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDateApplicationSelling($dateApplicationSelling = null)
    {
        $this->DateApplicationSelling = $dateApplicationSelling;
        return $this;
    }
    /**
     * Get DateDliverySelling value
     * @return string|null
     */
    public function getDateDliverySelling()
    {
        return $this->DateDliverySelling;
    }
    /**
     * Set DateDliverySelling value
     * @param string $dateDliverySelling
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDateDliverySelling($dateDliverySelling = null)
    {
        $this->DateDliverySelling = $dateDliverySelling;
        return $this;
    }
    /**
     * Get OrganizationSelling value
     * @return string|null
     */
    public function getOrganizationSelling()
    {
        return $this->OrganizationSelling;
    }
    /**
     * Set OrganizationSelling value
     * @param string $organizationSelling
     * @return \StructType\ArrestRegistryDetail
     */
    public function setOrganizationSelling($organizationSelling = null)
    {
        $this->OrganizationSelling = $organizationSelling;
        return $this;
    }
    /**
     * Get AddressOrganizationSelling value
     * @return \StructType\AddressType|null
     */
    public function getAddressOrganizationSelling()
    {
        return $this->AddressOrganizationSelling;
    }
    /**
     * Set AddressOrganizationSelling value
     * @param \StructType\AddressType $addressOrganizationSelling
     * @return \StructType\ArrestRegistryDetail
     */
    public function setAddressOrganizationSelling(\StructType\AddressType $addressOrganizationSelling = null)
    {
        $this->AddressOrganizationSelling = $addressOrganizationSelling;
        return $this;
    }
    /**
     * Get PhoneOrganizationSelling value
     * @return string|null
     */
    public function getPhoneOrganizationSelling()
    {
        return $this->PhoneOrganizationSelling;
    }
    /**
     * Set PhoneOrganizationSelling value
     * @param string $phoneOrganizationSelling
     * @return \StructType\ArrestRegistryDetail
     */
    public function setPhoneOrganizationSelling($phoneOrganizationSelling = null)
    {
        $this->PhoneOrganizationSelling = $phoneOrganizationSelling;
        return $this;
    }
    /**
     * Get DateSelling value
     * @return string|null
     */
    public function getDateSelling()
    {
        return $this->DateSelling;
    }
    /**
     * Set DateSelling value
     * @param string $dateSelling
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDateSelling($dateSelling = null)
    {
        $this->DateSelling = $dateSelling;
        return $this;
    }
    /**
     * Get AddressSelling value
     * @return \StructType\AddressType|null
     */
    public function getAddressSelling()
    {
        return $this->AddressSelling;
    }
    /**
     * Set AddressSelling value
     * @param \StructType\AddressType $addressSelling
     * @return \StructType\ArrestRegistryDetail
     */
    public function setAddressSelling(\StructType\AddressType $addressSelling = null)
    {
        $this->AddressSelling = $addressSelling;
        return $this;
    }
    /**
     * Get NameMedia value
     * @return string|null
     */
    public function getNameMedia()
    {
        return $this->NameMedia;
    }
    /**
     * Set NameMedia value
     * @param string $nameMedia
     * @return \StructType\ArrestRegistryDetail
     */
    public function setNameMedia($nameMedia = null)
    {
        $this->NameMedia = $nameMedia;
        return $this;
    }
    /**
     * Get DatePublication value
     * @return string|null
     */
    public function getDatePublication()
    {
        return $this->DatePublication;
    }
    /**
     * Set DatePublication value
     * @param string $datePublication
     * @return \StructType\ArrestRegistryDetail
     */
    public function setDatePublication($datePublication = null)
    {
        $this->DatePublication = $datePublication;
        return $this;
    }
    /**
     * Get StartingPrice value
     * @return float|null
     */
    public function getStartingPrice()
    {
        return $this->StartingPrice;
    }
    /**
     * Set StartingPrice value
     * @param float $startingPrice
     * @return \StructType\ArrestRegistryDetail
     */
    public function setStartingPrice($startingPrice = null)
    {
        $this->StartingPrice = $startingPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArrestRegistryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
