<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrestRecoveryAmountDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об арестованных и взысканных средствах
 * @subpackage Structs
 */
class ArrestRecoveryAmountDataType extends AccountDatumType
{
    /**
     * The ArrestAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма ареста в валюте счета | Заполняется для передачи данных об исполнении постановления об аресте средств, постановления о
     * снятии ареста. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $ArrestAmount;
    /**
     * The ArrestAmountRub
     * Meta informations extracted from the WSDL
     * - documentation: Сумма ареста в рублях | Заполняется для передачи данных об исполнении постановления об аресте средств, постановления о снятии
     * ареста. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $ArrestAmountRub;
    /**
     * The RecoveryAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма взыскания в валюте счета | Заполняется для передачи данных об исполнении постановления о взыскании средств,
     * постановления об отмене обращения взыскания. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $RecoveryAmount;
    /**
     * The RecoveryAmountRub
     * Meta informations extracted from the WSDL
     * - documentation: Сумма взыскания в рублях | Заполняется для передачи данных об исполнении постановления о взыскании средств, постановления об
     * отмене обращения взыскания. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $RecoveryAmountRub;
    /**
     * The ArrestRecoveryState
     * Meta informations extracted from the WSDL
     * - documentation: Статус ареста и взыскания
     * - minOccurs: 0
     * @var string
     */
    public $ArrestRecoveryState;
    /**
     * Constructor method for ArrestRecoveryAmountDataType
     * @uses ArrestRecoveryAmountDataType::setArrestAmount()
     * @uses ArrestRecoveryAmountDataType::setArrestAmountRub()
     * @uses ArrestRecoveryAmountDataType::setRecoveryAmount()
     * @uses ArrestRecoveryAmountDataType::setRecoveryAmountRub()
     * @uses ArrestRecoveryAmountDataType::setArrestRecoveryState()
     * @param float $arrestAmount
     * @param float $arrestAmountRub
     * @param float $recoveryAmount
     * @param float $recoveryAmountRub
     * @param string $arrestRecoveryState
     */
    public function __construct($arrestAmount = null, $arrestAmountRub = null, $recoveryAmount = null, $recoveryAmountRub = null, $arrestRecoveryState = null)
    {
        $this
            ->setArrestAmount($arrestAmount)
            ->setArrestAmountRub($arrestAmountRub)
            ->setRecoveryAmount($recoveryAmount)
            ->setRecoveryAmountRub($recoveryAmountRub)
            ->setArrestRecoveryState($arrestRecoveryState);
    }
    /**
     * Get ArrestAmount value
     * @return float|null
     */
    public function getArrestAmount()
    {
        return $this->ArrestAmount;
    }
    /**
     * Set ArrestAmount value
     * @param float $arrestAmount
     * @return \StructType\ArrestRecoveryAmountDataType
     */
    public function setArrestAmount($arrestAmount = null)
    {
        $this->ArrestAmount = $arrestAmount;
        return $this;
    }
    /**
     * Get ArrestAmountRub value
     * @return float|null
     */
    public function getArrestAmountRub()
    {
        return $this->ArrestAmountRub;
    }
    /**
     * Set ArrestAmountRub value
     * @param float $arrestAmountRub
     * @return \StructType\ArrestRecoveryAmountDataType
     */
    public function setArrestAmountRub($arrestAmountRub = null)
    {
        $this->ArrestAmountRub = $arrestAmountRub;
        return $this;
    }
    /**
     * Get RecoveryAmount value
     * @return float|null
     */
    public function getRecoveryAmount()
    {
        return $this->RecoveryAmount;
    }
    /**
     * Set RecoveryAmount value
     * @param float $recoveryAmount
     * @return \StructType\ArrestRecoveryAmountDataType
     */
    public function setRecoveryAmount($recoveryAmount = null)
    {
        $this->RecoveryAmount = $recoveryAmount;
        return $this;
    }
    /**
     * Get RecoveryAmountRub value
     * @return float|null
     */
    public function getRecoveryAmountRub()
    {
        return $this->RecoveryAmountRub;
    }
    /**
     * Set RecoveryAmountRub value
     * @param float $recoveryAmountRub
     * @return \StructType\ArrestRecoveryAmountDataType
     */
    public function setRecoveryAmountRub($recoveryAmountRub = null)
    {
        $this->RecoveryAmountRub = $recoveryAmountRub;
        return $this;
    }
    /**
     * Get ArrestRecoveryState value
     * @return string|null
     */
    public function getArrestRecoveryState()
    {
        return $this->ArrestRecoveryState;
    }
    /**
     * Set ArrestRecoveryState value
     * @uses \EnumType\ArrestRecoveryStateType::valueIsValid()
     * @uses \EnumType\ArrestRecoveryStateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrestRecoveryState
     * @return \StructType\ArrestRecoveryAmountDataType
     */
    public function setArrestRecoveryState($arrestRecoveryState = null)
    {
        $this->ArrestRecoveryState = $arrestRecoveryState;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArrestRecoveryAmountDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
