<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnswerMessage StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ интерактивный (синхронный) | ЭЦП | Технологическая ЭЦП (накладывается сервером, формирующим сообщение)
 * @subpackage Structs
 */
class AnswerMessage extends SyncRs
{
    /**
     * The DebtorIPListResponseType
     * Meta informations extracted from the WSDL
     * - documentation: Список исполнительных производств по должнику
     * @var \StructType\DebtorIPListResponseType
     */
    public $DebtorIPListResponseType;
    /**
     * The IPReqAppResponseType
     * Meta informations extracted from the WSDL
     * - documentation: Подтверждение регистрации запроса или заявления в ОСП
     * @var \StructType\IPReqAppResponseType
     */
    public $IPReqAppResponseType;
    /**
     * The IPReqAppResultReponseType
     * Meta informations extracted from the WSDL
     * - documentation: Ответы ОСП на запросы или заявления
     * @var \StructType\IPReqAppResultReponseType
     */
    public $IPReqAppResultReponseType;
    /**
     * The IPBriefInfoResponse
     * Meta informations extracted from the WSDL
     * - documentation: Сведения ИП
     * @var \StructType\IPBriefInfoResponseType
     */
    public $IPBriefInfoResponse;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for AnswerMessage
     * @uses AnswerMessage::setDebtorIPListResponseType()
     * @uses AnswerMessage::setIPReqAppResponseType()
     * @uses AnswerMessage::setIPReqAppResultReponseType()
     * @uses AnswerMessage::setIPBriefInfoResponse()
     * @uses AnswerMessage::setSignature()
     * @param \StructType\DebtorIPListResponseType $debtorIPListResponseType
     * @param \StructType\IPReqAppResponseType $iPReqAppResponseType
     * @param \StructType\IPReqAppResultReponseType $iPReqAppResultReponseType
     * @param \StructType\IPBriefInfoResponseType $iPBriefInfoResponse
     * @param \StructType\SignatureType[] $signature
     */
    public function __construct(\StructType\DebtorIPListResponseType $debtorIPListResponseType = null, \StructType\IPReqAppResponseType $iPReqAppResponseType = null, \StructType\IPReqAppResultReponseType $iPReqAppResultReponseType = null, \StructType\IPBriefInfoResponseType $iPBriefInfoResponse = null, array $signature = array())
    {
        $this
            ->setDebtorIPListResponseType($debtorIPListResponseType)
            ->setIPReqAppResponseType($iPReqAppResponseType)
            ->setIPReqAppResultReponseType($iPReqAppResultReponseType)
            ->setIPBriefInfoResponse($iPBriefInfoResponse)
            ->setSignature($signature);
    }
    /**
     * Get DebtorIPListResponseType value
     * @return \StructType\DebtorIPListResponseType|null
     */
    public function getDebtorIPListResponseType()
    {
        return $this->DebtorIPListResponseType;
    }
    /**
     * Set DebtorIPListResponseType value
     * @param \StructType\DebtorIPListResponseType $debtorIPListResponseType
     * @return \StructType\AnswerMessage
     */
    public function setDebtorIPListResponseType(\StructType\DebtorIPListResponseType $debtorIPListResponseType = null)
    {
        $this->DebtorIPListResponseType = $debtorIPListResponseType;
        return $this;
    }
    /**
     * Get IPReqAppResponseType value
     * @return \StructType\IPReqAppResponseType|null
     */
    public function getIPReqAppResponseType()
    {
        return $this->IPReqAppResponseType;
    }
    /**
     * Set IPReqAppResponseType value
     * @param \StructType\IPReqAppResponseType $iPReqAppResponseType
     * @return \StructType\AnswerMessage
     */
    public function setIPReqAppResponseType(\StructType\IPReqAppResponseType $iPReqAppResponseType = null)
    {
        $this->IPReqAppResponseType = $iPReqAppResponseType;
        return $this;
    }
    /**
     * Get IPReqAppResultReponseType value
     * @return \StructType\IPReqAppResultReponseType|null
     */
    public function getIPReqAppResultReponseType()
    {
        return $this->IPReqAppResultReponseType;
    }
    /**
     * Set IPReqAppResultReponseType value
     * @param \StructType\IPReqAppResultReponseType $iPReqAppResultReponseType
     * @return \StructType\AnswerMessage
     */
    public function setIPReqAppResultReponseType(\StructType\IPReqAppResultReponseType $iPReqAppResultReponseType = null)
    {
        $this->IPReqAppResultReponseType = $iPReqAppResultReponseType;
        return $this;
    }
    /**
     * Get IPBriefInfoResponse value
     * @return \StructType\IPBriefInfoResponseType|null
     */
    public function getIPBriefInfoResponse()
    {
        return $this->IPBriefInfoResponse;
    }
    /**
     * Set IPBriefInfoResponse value
     * @param \StructType\IPBriefInfoResponseType $iPBriefInfoResponse
     * @return \StructType\AnswerMessage
     */
    public function setIPBriefInfoResponse(\StructType\IPBriefInfoResponseType $iPBriefInfoResponse = null)
    {
        $this->IPBriefInfoResponse = $iPBriefInfoResponse;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType[] $signature
     * @return \StructType\AnswerMessage
     */
    public function setSignature(array $signature = array())
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \StructType\SignatureType $item
     * @return \StructType\AnswerMessage
     */
    public function addToSignature(\StructType\SignatureType $item)
    {
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnswerMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
