<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных AddressType «Адрес»
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: При отсутствии данных в этом поле, объект, адрес которого задаётся, считается находящимся в Российской Федерации (код страны 643)
     * | Код страны цифровой | Цифровой код страны по ОКСМ
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9]{3}
     * @var string
     */
    public $countryCode;
    /**
     * The OKATO
     * Meta informations extracted from the WSDL
     * - documentation: ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $OKATO;
    /**
     * The OKTMO
     * Meta informations extracted from the WSDL
     * - documentation: ОКТMО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - maxLength: 11
     * - minLength: 8
     * - pattern: ([0-9]{8})|([0-9]{11})
     * @var string
     */
    public $OKTMO;
    /**
     * The zipCode
     * Meta informations extracted from the WSDL
     * - documentation: Индекс | Почтовый индекс
     * - minOccurs: 0
     * - length: 6
     * - pattern: [0-9]{6}
     * @var string
     */
    public $zipCode;
    /**
     * The regionCode
     * Meta informations extracted from the WSDL
     * - documentation: Область | Код региона по КЛАДР
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $regionCode;
    /**
     * The area
     * Meta informations extracted from the WSDL
     * - documentation: Район | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $area;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - documentation: Город | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $city;
    /**
     * The settlement
     * Meta informations extracted from the WSDL
     * - documentation: Населенный пункт | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $settlement;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - documentation: Улица | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta informations extracted from the WSDL
     * - documentation: Дом | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $houseNumber;
    /**
     * The buildingNumber
     * Meta informations extracted from the WSDL
     * - documentation: Корпус | Строка длиной от 1 до 8 символов
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $buildingNumber;
    /**
     * The structureNumber
     * Meta informations extracted from the WSDL
     * - documentation: Строение/владение | Строка длиной от 1 до 8 символов
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $structureNumber;
    /**
     * The flatNumber
     * Meta informations extracted from the WSDL
     * - documentation: Квартира | Строка длиной от 1 до 8 символов
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $flatNumber;
    /**
     * The kladrRegion
     * Meta informations extracted from the WSDL
     * - documentation: Код региона | Код КЛАДР первого раздела | Код КЛАДР первого раздела
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $kladrRegion;
    /**
     * The kladrArea
     * Meta informations extracted from the WSDL
     * - documentation: Код района | Код КЛАДР первого раздела | Код КЛАДР первого раздела
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $kladrArea;
    /**
     * The kladrCity
     * Meta informations extracted from the WSDL
     * - documentation: Код города или населенного пункта | Код КЛАДР первого раздела | Код КЛАДР первого раздела
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $kladrCity;
    /**
     * The kladrSettlement
     * Meta informations extracted from the WSDL
     * - documentation: Код населенного пункта | Код КЛАДР первого раздела | Код КЛАДР первого раздела
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $kladrSettlement;
    /**
     * The kladrStreet
     * Meta informations extracted from the WSDL
     * - documentation: Код улицы | Код КЛАДР второго раздела | Код КЛАДР второго раздела
     * - minOccurs: 0
     * - length: 15
     * - pattern: [0-9]{15}
     * @var string
     */
    public $kladrStreet;
    /**
     * The addressText
     * Meta informations extracted from the WSDL
     * - documentation: Адрес в произвольном формате | Может заполняться в случае, если указывается иностранный адрес (указан код страны, отличный от
     * 643). | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $addressText;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setCountryCode()
     * @uses AddressType::setOKATO()
     * @uses AddressType::setOKTMO()
     * @uses AddressType::setZipCode()
     * @uses AddressType::setRegionCode()
     * @uses AddressType::setArea()
     * @uses AddressType::setCity()
     * @uses AddressType::setSettlement()
     * @uses AddressType::setStreet()
     * @uses AddressType::setHouseNumber()
     * @uses AddressType::setBuildingNumber()
     * @uses AddressType::setStructureNumber()
     * @uses AddressType::setFlatNumber()
     * @uses AddressType::setKladrRegion()
     * @uses AddressType::setKladrArea()
     * @uses AddressType::setKladrCity()
     * @uses AddressType::setKladrSettlement()
     * @uses AddressType::setKladrStreet()
     * @uses AddressType::setAddressText()
     * @param string $countryCode
     * @param string $oKATO
     * @param string $oKTMO
     * @param string $zipCode
     * @param string $regionCode
     * @param string $area
     * @param string $city
     * @param string $settlement
     * @param string $street
     * @param string $houseNumber
     * @param string $buildingNumber
     * @param string $structureNumber
     * @param string $flatNumber
     * @param string $kladrRegion
     * @param string $kladrArea
     * @param string $kladrCity
     * @param string $kladrSettlement
     * @param string $kladrStreet
     * @param string $addressText
     */
    public function __construct($countryCode = null, $oKATO = null, $oKTMO = null, $zipCode = null, $regionCode = null, $area = null, $city = null, $settlement = null, $street = null, $houseNumber = null, $buildingNumber = null, $structureNumber = null, $flatNumber = null, $kladrRegion = null, $kladrArea = null, $kladrCity = null, $kladrSettlement = null, $kladrStreet = null, $addressText = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setOKATO($oKATO)
            ->setOKTMO($oKTMO)
            ->setZipCode($zipCode)
            ->setRegionCode($regionCode)
            ->setArea($area)
            ->setCity($city)
            ->setSettlement($settlement)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setBuildingNumber($buildingNumber)
            ->setStructureNumber($structureNumber)
            ->setFlatNumber($flatNumber)
            ->setKladrRegion($kladrRegion)
            ->setKladrArea($kladrArea)
            ->setKladrCity($kladrCity)
            ->setKladrSettlement($kladrSettlement)
            ->setKladrStreet($kladrStreet)
            ->setAddressText($addressText);
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\AddressType
     */
    public function setCountryCode($countryCode = null)
    {
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get OKATO value
     * @return string|null
     */
    public function getOKATO()
    {
        return $this->OKATO;
    }
    /**
     * Set OKATO value
     * @param string $oKATO
     * @return \StructType\AddressType
     */
    public function setOKATO($oKATO = null)
    {
        $this->OKATO = $oKATO;
        return $this;
    }
    /**
     * Get OKTMO value
     * @return string|null
     */
    public function getOKTMO()
    {
        return $this->OKTMO;
    }
    /**
     * Set OKTMO value
     * @param string $oKTMO
     * @return \StructType\AddressType
     */
    public function setOKTMO($oKTMO = null)
    {
        $this->OKTMO = $oKTMO;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \StructType\AddressType
     */
    public function setZipCode($zipCode = null)
    {
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \StructType\AddressType
     */
    public function setRegionCode($regionCode = null)
    {
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Get area value
     * @return string|null
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @param string $area
     * @return \StructType\AddressType
     */
    public function setArea($area = null)
    {
        $this->area = $area;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\AddressType
     */
    public function setCity($city = null)
    {
        $this->city = $city;
        return $this;
    }
    /**
     * Get settlement value
     * @return string|null
     */
    public function getSettlement()
    {
        return $this->settlement;
    }
    /**
     * Set settlement value
     * @param string $settlement
     * @return \StructType\AddressType
     */
    public function setSettlement($settlement = null)
    {
        $this->settlement = $settlement;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\AddressType
     */
    public function setStreet($street = null)
    {
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \StructType\AddressType
     */
    public function setHouseNumber($houseNumber = null)
    {
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get buildingNumber value
     * @return string|null
     */
    public function getBuildingNumber()
    {
        return $this->buildingNumber;
    }
    /**
     * Set buildingNumber value
     * @param string $buildingNumber
     * @return \StructType\AddressType
     */
    public function setBuildingNumber($buildingNumber = null)
    {
        $this->buildingNumber = $buildingNumber;
        return $this;
    }
    /**
     * Get structureNumber value
     * @return string|null
     */
    public function getStructureNumber()
    {
        return $this->structureNumber;
    }
    /**
     * Set structureNumber value
     * @param string $structureNumber
     * @return \StructType\AddressType
     */
    public function setStructureNumber($structureNumber = null)
    {
        $this->structureNumber = $structureNumber;
        return $this;
    }
    /**
     * Get flatNumber value
     * @return string|null
     */
    public function getFlatNumber()
    {
        return $this->flatNumber;
    }
    /**
     * Set flatNumber value
     * @param string $flatNumber
     * @return \StructType\AddressType
     */
    public function setFlatNumber($flatNumber = null)
    {
        $this->flatNumber = $flatNumber;
        return $this;
    }
    /**
     * Get kladrRegion value
     * @return string|null
     */
    public function getKladrRegion()
    {
        return $this->kladrRegion;
    }
    /**
     * Set kladrRegion value
     * @param string $kladrRegion
     * @return \StructType\AddressType
     */
    public function setKladrRegion($kladrRegion = null)
    {
        $this->kladrRegion = $kladrRegion;
        return $this;
    }
    /**
     * Get kladrArea value
     * @return string|null
     */
    public function getKladrArea()
    {
        return $this->kladrArea;
    }
    /**
     * Set kladrArea value
     * @param string $kladrArea
     * @return \StructType\AddressType
     */
    public function setKladrArea($kladrArea = null)
    {
        $this->kladrArea = $kladrArea;
        return $this;
    }
    /**
     * Get kladrCity value
     * @return string|null
     */
    public function getKladrCity()
    {
        return $this->kladrCity;
    }
    /**
     * Set kladrCity value
     * @param string $kladrCity
     * @return \StructType\AddressType
     */
    public function setKladrCity($kladrCity = null)
    {
        $this->kladrCity = $kladrCity;
        return $this;
    }
    /**
     * Get kladrSettlement value
     * @return string|null
     */
    public function getKladrSettlement()
    {
        return $this->kladrSettlement;
    }
    /**
     * Set kladrSettlement value
     * @param string $kladrSettlement
     * @return \StructType\AddressType
     */
    public function setKladrSettlement($kladrSettlement = null)
    {
        $this->kladrSettlement = $kladrSettlement;
        return $this;
    }
    /**
     * Get kladrStreet value
     * @return string|null
     */
    public function getKladrStreet()
    {
        return $this->kladrStreet;
    }
    /**
     * Set kladrStreet value
     * @param string $kladrStreet
     * @return \StructType\AddressType
     */
    public function setKladrStreet($kladrStreet = null)
    {
        $this->kladrStreet = $kladrStreet;
        return $this;
    }
    /**
     * Get addressText value
     * @return string|null
     */
    public function getAddressText()
    {
        return $this->addressText;
    }
    /**
     * Set addressText value
     * @param string $addressText
     * @return \StructType\AddressType
     */
    public function setAddressText($addressText = null)
    {
        $this->addressText = $addressText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
