<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений AccountingDataType "Бухгалтерская отчетность"
 * @subpackage Structs
 */
class AccountingDataType extends InformationType
{
    /**
     * The PeriodText
     * Meta informations extracted from the WSDL
     * - documentation: Отчетный период | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $PeriodText;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - documentation: Состояние счета | Множество элементов, описывающих счета баланса
     * - maxOccurs: unbounded
     * @var \StructType\AccountType[]
     */
    public $Account;
    /**
     * Constructor method for AccountingDataType
     * @uses AccountingDataType::setPeriodText()
     * @uses AccountingDataType::setAccount()
     * @param string $periodText
     * @param \StructType\AccountType[] $account
     */
    public function __construct($periodText = null, array $account = array())
    {
        $this
            ->setPeriodText($periodText)
            ->setAccount($account);
    }
    /**
     * Get PeriodText value
     * @return string|null
     */
    public function getPeriodText()
    {
        return $this->PeriodText;
    }
    /**
     * Set PeriodText value
     * @param string $periodText
     * @return \StructType\AccountingDataType
     */
    public function setPeriodText($periodText = null)
    {
        $this->PeriodText = $periodText;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\AccountType[]|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountType[] $account
     * @return \StructType\AccountingDataType
     */
    public function setAccount(array $account = array())
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Add item to Account value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountType $item
     * @return \StructType\AccountingDataType
     */
    public function addToAccount(\StructType\AccountType $item)
    {
        $this->Account[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountingDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
