<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountTransactionDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об операциях по счету
 * @subpackage Structs
 */
class AccountTransactionDatumType extends InformationType
{
    /**
     * The IsArchive
     * Meta informations extracted from the WSDL
     * - documentation: Признак архивного счета | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsArchive;
    /**
     * The TransactionType
     * Meta informations extracted from the WSDL
     * - documentation: Тип операции
     * @var string
     */
    public $TransactionType;
    /**
     * The BIK
     * Meta informations extracted from the WSDL
     * - documentation: БИК | Банковский идентификационный код (БИК)
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $BIK;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - documentation: Счет | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $AccountNumber;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата операции | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $TransactionDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма операции | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * The ContragentName
     * Meta informations extracted from the WSDL
     * - documentation: Контрагент | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ContragentName;
    /**
     * The CorrBIK
     * Meta informations extracted from the WSDL
     * - documentation: БИК банка корреспондента | Банковский идентификационный код (БИК)
     * - minOccurs: 0
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $CorrBIK;
    /**
     * The CorrAccountNumber
     * Meta informations extracted from the WSDL
     * - documentation: Кор.счет | Указывается номер корреспондентского счета. Поле обязательно для заполнения если тип операции «1» - Приход, «2» -
     * Расход. Поле необязательно для заполнения в случае если тип операции «3» - Остаток на начало, «4» - Остаток на конец. Поле необязательно
     * для заполнения при передачи сведений о платежах в адрес Федерального казначейства | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $CorrAccountNumber;
    /**
     * The Grounds
     * Meta informations extracted from the WSDL
     * - documentation: Основание | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Grounds;
    /**
     * Constructor method for AccountTransactionDatumType
     * @uses AccountTransactionDatumType::setIsArchive()
     * @uses AccountTransactionDatumType::setTransactionType()
     * @uses AccountTransactionDatumType::setBIK()
     * @uses AccountTransactionDatumType::setAccountNumber()
     * @uses AccountTransactionDatumType::setTransactionDate()
     * @uses AccountTransactionDatumType::setAmount()
     * @uses AccountTransactionDatumType::setContragentName()
     * @uses AccountTransactionDatumType::setCorrBIK()
     * @uses AccountTransactionDatumType::setCorrAccountNumber()
     * @uses AccountTransactionDatumType::setGrounds()
     * @param bool $isArchive
     * @param string $transactionType
     * @param string $bIK
     * @param string $accountNumber
     * @param string $transactionDate
     * @param float $amount
     * @param string $contragentName
     * @param string $corrBIK
     * @param string $corrAccountNumber
     * @param string $grounds
     */
    public function __construct($isArchive = null, $transactionType = null, $bIK = null, $accountNumber = null, $transactionDate = null, $amount = null, $contragentName = null, $corrBIK = null, $corrAccountNumber = null, $grounds = null)
    {
        $this
            ->setIsArchive($isArchive)
            ->setTransactionType($transactionType)
            ->setBIK($bIK)
            ->setAccountNumber($accountNumber)
            ->setTransactionDate($transactionDate)
            ->setAmount($amount)
            ->setContragentName($contragentName)
            ->setCorrBIK($corrBIK)
            ->setCorrAccountNumber($corrAccountNumber)
            ->setGrounds($grounds);
    }
    /**
     * Get IsArchive value
     * @return bool|null
     */
    public function getIsArchive()
    {
        return $this->IsArchive;
    }
    /**
     * Set IsArchive value
     * @param bool $isArchive
     * @return \StructType\AccountTransactionDatumType
     */
    public function setIsArchive($isArchive = null)
    {
        $this->IsArchive = $isArchive;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @uses \EnumType\AccountTransactionType::valueIsValid()
     * @uses \EnumType\AccountTransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\AccountTransactionDatumType
     */
    public function setTransactionType($transactionType = null)
    {
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get BIK value
     * @return string|null
     */
    public function getBIK()
    {
        return $this->BIK;
    }
    /**
     * Set BIK value
     * @param string $bIK
     * @return \StructType\AccountTransactionDatumType
     */
    public function setBIK($bIK = null)
    {
        $this->BIK = $bIK;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\AccountTransactionDatumType
     */
    public function setAccountNumber($accountNumber = null)
    {
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\AccountTransactionDatumType
     */
    public function setTransactionDate($transactionDate = null)
    {
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AccountTransactionDatumType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ContragentName value
     * @return string|null
     */
    public function getContragentName()
    {
        return $this->ContragentName;
    }
    /**
     * Set ContragentName value
     * @param string $contragentName
     * @return \StructType\AccountTransactionDatumType
     */
    public function setContragentName($contragentName = null)
    {
        $this->ContragentName = $contragentName;
        return $this;
    }
    /**
     * Get CorrBIK value
     * @return string|null
     */
    public function getCorrBIK()
    {
        return $this->CorrBIK;
    }
    /**
     * Set CorrBIK value
     * @param string $corrBIK
     * @return \StructType\AccountTransactionDatumType
     */
    public function setCorrBIK($corrBIK = null)
    {
        $this->CorrBIK = $corrBIK;
        return $this;
    }
    /**
     * Get CorrAccountNumber value
     * @return string|null
     */
    public function getCorrAccountNumber()
    {
        return $this->CorrAccountNumber;
    }
    /**
     * Set CorrAccountNumber value
     * @param string $corrAccountNumber
     * @return \StructType\AccountTransactionDatumType
     */
    public function setCorrAccountNumber($corrAccountNumber = null)
    {
        $this->CorrAccountNumber = $corrAccountNumber;
        return $this;
    }
    /**
     * Get Grounds value
     * @return string|null
     */
    public function getGrounds()
    {
        return $this->Grounds;
    }
    /**
     * Set Grounds value
     * @param string $grounds
     * @return \StructType\AccountTransactionDatumType
     */
    public function setGrounds($grounds = null)
    {
        $this->Grounds = $grounds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountTransactionDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
