<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountExtDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Расширенные сведения о банковском счете
 * @subpackage Structs
 */
class AccountExtDatumType extends AccountDatumType
{
    /**
     * The accountTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Код типа банковского счёта | Строка длиной 2 символа
     * - length: 2
     * @var string
     */
    public $accountTypeCode;
    /**
     * The accountTypeName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа банковского счёта | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $accountTypeName;
    /**
     * Constructor method for AccountExtDatumType
     * @uses AccountExtDatumType::setAccountTypeCode()
     * @uses AccountExtDatumType::setAccountTypeName()
     * @param string $accountTypeCode
     * @param string $accountTypeName
     */
    public function __construct($accountTypeCode = null, $accountTypeName = null)
    {
        $this
            ->setAccountTypeCode($accountTypeCode)
            ->setAccountTypeName($accountTypeName);
    }
    /**
     * Get accountTypeCode value
     * @return string|null
     */
    public function getAccountTypeCode()
    {
        return $this->accountTypeCode;
    }
    /**
     * Set accountTypeCode value
     * @param string $accountTypeCode
     * @return \StructType\AccountExtDatumType
     */
    public function setAccountTypeCode($accountTypeCode = null)
    {
        $this->accountTypeCode = $accountTypeCode;
        return $this;
    }
    /**
     * Get accountTypeName value
     * @return string|null
     */
    public function getAccountTypeName()
    {
        return $this->accountTypeName;
    }
    /**
     * Set accountTypeName value
     * @param string $accountTypeName
     * @return \StructType\AccountExtDatumType
     */
    public function setAccountTypeName($accountTypeName = null)
    {
        $this->accountTypeName = $accountTypeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountExtDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
